---
title: "module Grammar"
id: Grammar
slug: /Library//Grammar
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-Not specified</div>

A simple but effective internal format for the representation of context-free grammars.
#### Usage

```rascal
import Grammar;
```

#### Dependencies
```rascal
extend ParseTree;
```


## data Grammar {#Grammar-Grammar}
The Grammar datatype

```rascal
data Grammar  
     = \grammar(set[Symbol] starts, map[Symbol sort, Production def] rules)
     ;
```


Grammar is the internal representation (AST) of syntax definitions used in Rascal.
A grammar is a set of productions and set of start symbols. The productions are 
stored in a map for efficient access.

## data GrammarModule {#Grammar-GrammarModule}

```rascal
data GrammarModule  
     = \module(str name, set[str] imports, set[str] extends, Grammar grammar)
     ;
```

## data GrammarDefinition {#Grammar-GrammarDefinition}

```rascal
data GrammarDefinition  
     = \definition(str main, map[str name, GrammarModule \mod] modules)
     ;
```

## function grammar {#Grammar-grammar}

```rascal
Grammar grammar(set[Symbol] starts, set[Production] prods)

Grammar grammar(type[&T <: Tree] sym)
```

## data Item {#Grammar-Item}
An item is an index into the symbol list of a production rule.

```rascal
data Item  
     = item(Production production, int index)
     ;
```

## function compose {#Grammar-compose}

Compose two grammars.

```rascal
Grammar compose(Grammar g1, Grammar g2)
```


Compose two grammars by adding the rules of g2 to the rules of g1.
The start symbols of g1 will be the start symbols of the resulting grammar.

## function extends {#Grammar-extends}

Compute a relation from extender to extended module for the given grammar

```rascal
rel[str \module, str extended] extends(GrammarDefinition def)
```


Note that this relation is already transitively closed because that is the semantics of extend.

## function imports {#Grammar-imports}

Compute a relation from importer to imported modules for the given grammar

```rascal
rel[str \module, str imported] imports(GrammarDefinition def)
```

## function dependencies {#Grammar-dependencies}

Compute which modules directly depend on which other modules.

```rascal
rel[str \module, str dependency] dependencies(GrammarDefinition def)
```


This function computes dependencies via import and extend relations. Every module
X that imports Y or extends Y ends up in the result as <X, Y>. The extends relation
that we use is already transitively closed. Next to this we also add dependencies
<X, Z> for all modules X that import Y which extends Z. Because of the transitive
nature of module extension, a module that extends another module exposes all
rules to any importing module. 

