/*
 * Decompiled with CFR 0.152.
 */
package engineering.swat.watch.impl.overflows;

import engineering.swat.watch.WatchEvent;
import engineering.swat.watch.WatchScope;
import engineering.swat.watch.impl.EventHandlingWatch;
import engineering.swat.watch.impl.overflows.BaseFileVisitor;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.stream.Stream;

public class MemorylessRescanner
implements BiConsumer<EventHandlingWatch, WatchEvent> {
    private final Executor exec;

    public MemorylessRescanner(Executor exec) {
        this.exec = exec;
    }

    protected void rescan(EventHandlingWatch watch) {
        Generator generator = this.newGenerator(watch.getPath(), watch.getScope());
        generator.walkFileTree();
        generator.eventStream().map(watch::relativize).forEach(watch::handleEvent);
    }

    protected Generator newGenerator(Path path, WatchScope scope) {
        return new Generator(path, scope);
    }

    @Override
    public void accept(EventHandlingWatch watch, WatchEvent event) {
        if (event.getKind() == WatchEvent.Kind.OVERFLOW) {
            this.exec.execute(() -> this.rescan(watch));
        }
    }

    protected class Generator
    extends BaseFileVisitor {
        protected final List<WatchEvent> events;

        public Generator(Path path, WatchScope scope) {
            super(path, scope);
            this.events = new ArrayList<WatchEvent>();
        }

        public Stream<WatchEvent> eventStream() {
            return this.events.stream();
        }

        protected void generateEvents(Path path, BasicFileAttributes attrs) {
            this.events.add(new WatchEvent(WatchEvent.Kind.CREATED, path));
            if (attrs.isRegularFile() && attrs.size() > 0L) {
                this.events.add(new WatchEvent(WatchEvent.Kind.MODIFIED, path));
            }
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            if (!this.path.equals(dir)) {
                this.generateEvents(dir, attrs);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            this.generateEvents(file, attrs);
            return FileVisitResult.CONTINUE;
        }
    }
}

