/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang;

import io.usethesource.capsule.Map;
import io.usethesource.capsule.util.collection.AbstractSpecialisedImmutableMap;
import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.INode;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IWithKeywordParameters;
import io.usethesource.vallang.exceptions.UndeclaredFieldException;
import io.usethesource.vallang.impl.fields.AbstractDefaultWithKeywordParameters;
import io.usethesource.vallang.impl.fields.ConstructorWithKeywordParametersFacade;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import io.usethesource.vallang.visitors.IValueVisitor;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public interface IExternalValue
extends IValue {
    @Override
    public int getMatchFingerprint();

    @Override
    public Type getType();

    default public IConstructor encodeAsConstructor() {
        return new IConstructor(){

            @Override
            public Type getConstructorType() {
                return TypeFactory.getInstance().constructor(new TypeStore(new TypeStore[0]), this.getType(), this.getName(), new Type[0]);
            }

            @Override
            public INode setChildren(IValue[] childArray) {
                return this;
            }

            @Override
            public Type getType() {
                return TypeFactory.getInstance().valueType();
            }

            @Override
            public String getName() {
                return IExternalValue.this.getClass().getSimpleName().toLowerCase();
            }

            @Override
            public Type getUninstantiatedConstructorType() {
                return this.getConstructorType();
            }

            @Override
            public IValue get(String label) {
                throw new UndeclaredFieldException(this.getConstructorType(), label);
            }

            @Override
            public IConstructor set(String label, IValue newChild) {
                return this;
            }

            @Override
            public boolean has(String label) {
                return false;
            }

            @Override
            public IConstructor set(int index, IValue newChild) {
                return this;
            }

            @Override
            public Type getChildrenTypes() {
                return TypeFactory.getInstance().voidType();
            }

            @Override
            public boolean mayHaveKeywordParameters() {
                return true;
            }

            @Override
            public INode replace(int first, int second, int end, IList repl) {
                return this;
            }

            @Override
            public int arity() {
                return 0;
            }

            @Override
            public IValue get(int i) {
                throw new IndexOutOfBoundsException(Integer.toString(i));
            }

            @Override
            public Iterable<IValue> getChildren() {
                return Collections.emptyList();
            }

            @Override
            public Iterator<IValue> iterator() {
                return Collections.emptyIterator();
            }

            public IWithKeywordParameters<IConstructor> asWithKeywordParameters() {
                return new AbstractDefaultWithKeywordParameters<IConstructor>((IConstructor)this, AbstractSpecialisedImmutableMap.mapOf()){

                    @Override
                    protected IConstructor wrap(IConstructor content, Map.Immutable<String, IValue> parameters) {
                        return new ConstructorWithKeywordParametersFacade(content, parameters);
                    }

                    @Override
                    public boolean hasParameters() {
                        return false;
                    }

                    @Override
                    public Set<String> getParameterNames() {
                        return Collections.emptySet();
                    }

                    @Override
                    public Map<String, IValue> getParameters() {
                        return Collections.unmodifiableMap(this.parameters);
                    }
                };
            }
        };
    }

    @Override
    default public <T, E extends Throwable> T accept(IValueVisitor<T, E> v) throws E {
        return v.visitExternal(this);
    }
}

