/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.Expression;
import org.rascalmpl.ast.IASTVisitor;
import org.rascalmpl.ast.OptionalEqualSign;
import org.rascalmpl.ast.OptionalTerminator;
import org.rascalmpl.ast.QualifiedName;

public abstract class ShellCommand
extends AbstractAST {
    public ShellCommand(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasOptName() {
        return false;
    }

    public @MonotonicNonNull QualifiedName getOptName() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasExpression() {
        return false;
    }

    public Expression getExpression() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasSign() {
        return false;
    }

    public OptionalEqualSign getSign() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasTerminator() {
        return false;
    }

    public OptionalTerminator getTerminator() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasName() {
        return false;
    }

    public QualifiedName getName() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean isClear() {
        return false;
    }

    public boolean isEdit() {
        return false;
    }

    public boolean isHelp() {
        return false;
    }

    public boolean isHistory() {
        return false;
    }

    public boolean isListDeclarations() {
        return false;
    }

    public boolean isListModules() {
        return false;
    }

    public boolean isQuit() {
        return false;
    }

    public boolean isSetOption() {
        return false;
    }

    public boolean isSetOptionTrue() {
        return false;
    }

    public boolean isTest() {
        return false;
    }

    public boolean isUndeclare() {
        return false;
    }

    public boolean isUnextend() {
        return false;
    }

    public boolean isUnimport() {
        return false;
    }

    public boolean isUnsetOption() {
        return false;
    }

    public static class UnsetOption
    extends ShellCommand {
        private final QualifiedName name;
        private final OptionalTerminator terminator;

        public UnsetOption(ISourceLocation src, IConstructor node, QualifiedName name, OptionalTerminator terminator) {
            super(src, node);
            this.name = name;
            this.terminator = terminator;
        }

        @Override
        public boolean isUnsetOption() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitShellCommandUnsetOption(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.name.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.name.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.terminator.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.terminator.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof UnsetOption)) {
                return false;
            }
            UnsetOption tmp = (UnsetOption)o;
            return tmp.name.equals(this.name) && tmp.terminator.equals(this.terminator);
        }

        @Override
        public int hashCode() {
            return 317 + 857 * this.name.hashCode() + 353 * this.terminator.hashCode();
        }

        @Override
        public QualifiedName getName() {
            return this.name;
        }

        @Override
        public boolean hasName() {
            return true;
        }

        @Override
        public OptionalTerminator getTerminator() {
            return this.terminator;
        }

        @Override
        public boolean hasTerminator() {
            return true;
        }

        @Override
        public Object clone() {
            return UnsetOption.newInstance(this.getClass(), this.src, null, this.clone(this.name), this.clone(this.terminator));
        }
    }

    public static class Unimport
    extends ShellCommand {
        private final QualifiedName name;
        private final OptionalTerminator terminator;

        public Unimport(ISourceLocation src, IConstructor node, QualifiedName name, OptionalTerminator terminator) {
            super(src, node);
            this.name = name;
            this.terminator = terminator;
        }

        @Override
        public boolean isUnimport() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitShellCommandUnimport(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.name.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.name.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.terminator.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.terminator.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Unimport)) {
                return false;
            }
            Unimport tmp = (Unimport)o;
            return tmp.name.equals(this.name) && tmp.terminator.equals(this.terminator);
        }

        @Override
        public int hashCode() {
            return 619 + 401 * this.name.hashCode() + 463 * this.terminator.hashCode();
        }

        @Override
        public QualifiedName getName() {
            return this.name;
        }

        @Override
        public boolean hasName() {
            return true;
        }

        @Override
        public OptionalTerminator getTerminator() {
            return this.terminator;
        }

        @Override
        public boolean hasTerminator() {
            return true;
        }

        @Override
        public Object clone() {
            return Unimport.newInstance(this.getClass(), this.src, null, this.clone(this.name), this.clone(this.terminator));
        }
    }

    public static class Unextend
    extends ShellCommand {
        private final QualifiedName name;
        private final OptionalTerminator terminator;

        public Unextend(ISourceLocation src, IConstructor node, QualifiedName name, OptionalTerminator terminator) {
            super(src, node);
            this.name = name;
            this.terminator = terminator;
        }

        @Override
        public boolean isUnextend() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitShellCommandUnextend(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.name.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.name.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.terminator.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.terminator.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Unextend)) {
                return false;
            }
            Unextend tmp = (Unextend)o;
            return tmp.name.equals(this.name) && tmp.terminator.equals(this.terminator);
        }

        @Override
        public int hashCode() {
            return 823 + 757 * this.name.hashCode() + 89 * this.terminator.hashCode();
        }

        @Override
        public QualifiedName getName() {
            return this.name;
        }

        @Override
        public boolean hasName() {
            return true;
        }

        @Override
        public OptionalTerminator getTerminator() {
            return this.terminator;
        }

        @Override
        public boolean hasTerminator() {
            return true;
        }

        @Override
        public Object clone() {
            return Unextend.newInstance(this.getClass(), this.src, null, this.clone(this.name), this.clone(this.terminator));
        }
    }

    public static class Undeclare
    extends ShellCommand {
        private final @Nullable QualifiedName optName;
        private final OptionalTerminator terminator;

        public Undeclare(ISourceLocation src, IConstructor node, @Nullable QualifiedName optName, OptionalTerminator terminator) {
            super(src, node);
            this.optName = optName;
            this.terminator = terminator;
        }

        @Override
        public boolean isUndeclare() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitShellCommandUndeclare(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            ISourceLocation iSourceLocation = $l = this.optName == null ? null : this.optName.getLocation();
            if ($l != null && $l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.optName.addForLineNumber($line, $result);
            }
            if ($l != null && $l.getBeginLine() > $line) {
                return;
            }
            $l = this.terminator.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.terminator.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Undeclare)) {
                return false;
            }
            Undeclare tmp = (Undeclare)o;
            return Objects.equals(tmp.optName, this.optName) && tmp.terminator.equals(this.terminator);
        }

        @Override
        public int hashCode() {
            return 881 + 313 * Objects.hashCode(this.optName) + 127 * this.terminator.hashCode();
        }

        @Override
        public @MonotonicNonNull QualifiedName getOptName() {
            return this.optName;
        }

        @Override
        @EnsuresNonNullIf(expression={"getOptName()"}, result=true)
        public boolean hasOptName() {
            return this.optName != null;
        }

        @Override
        public OptionalTerminator getTerminator() {
            return this.terminator;
        }

        @Override
        public boolean hasTerminator() {
            return true;
        }

        @Override
        public Object clone() {
            return Undeclare.newInstance(this.getClass(), this.src, null, this.clone(this.optName), this.clone(this.terminator));
        }
    }

    public static class Test
    extends ShellCommand {
        private final @Nullable QualifiedName optName;
        private final OptionalTerminator terminator;

        public Test(ISourceLocation src, IConstructor node, @Nullable QualifiedName optName, OptionalTerminator terminator) {
            super(src, node);
            this.optName = optName;
            this.terminator = terminator;
        }

        @Override
        public boolean isTest() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitShellCommandTest(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            ISourceLocation iSourceLocation = $l = this.optName == null ? null : this.optName.getLocation();
            if ($l != null && $l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.optName.addForLineNumber($line, $result);
            }
            if ($l != null && $l.getBeginLine() > $line) {
                return;
            }
            $l = this.terminator.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.terminator.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Test)) {
                return false;
            }
            Test tmp = (Test)o;
            return Objects.equals(tmp.optName, this.optName) && tmp.terminator.equals(this.terminator);
        }

        @Override
        public int hashCode() {
            return 547 + 293 * Objects.hashCode(this.optName) + 997 * this.terminator.hashCode();
        }

        @Override
        public @MonotonicNonNull QualifiedName getOptName() {
            return this.optName;
        }

        @Override
        @EnsuresNonNullIf(expression={"getOptName()"}, result=true)
        public boolean hasOptName() {
            return this.optName != null;
        }

        @Override
        public OptionalTerminator getTerminator() {
            return this.terminator;
        }

        @Override
        public boolean hasTerminator() {
            return true;
        }

        @Override
        public Object clone() {
            return Test.newInstance(this.getClass(), this.src, null, this.clone(this.optName), this.clone(this.terminator));
        }
    }

    public static class SetOptionTrue
    extends ShellCommand {
        private final QualifiedName name;
        private final OptionalTerminator terminator;

        public SetOptionTrue(ISourceLocation src, IConstructor node, QualifiedName name, OptionalTerminator terminator) {
            super(src, node);
            this.name = name;
            this.terminator = terminator;
        }

        @Override
        public boolean isSetOptionTrue() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitShellCommandSetOptionTrue(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.name.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.name.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.terminator.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.terminator.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof SetOptionTrue)) {
                return false;
            }
            SetOptionTrue tmp = (SetOptionTrue)o;
            return tmp.name.equals(this.name) && tmp.terminator.equals(this.terminator);
        }

        @Override
        public int hashCode() {
            return 163 + 491 * this.name.hashCode() + 887 * this.terminator.hashCode();
        }

        @Override
        public QualifiedName getName() {
            return this.name;
        }

        @Override
        public boolean hasName() {
            return true;
        }

        @Override
        public OptionalTerminator getTerminator() {
            return this.terminator;
        }

        @Override
        public boolean hasTerminator() {
            return true;
        }

        @Override
        public Object clone() {
            return SetOptionTrue.newInstance(this.getClass(), this.src, null, this.clone(this.name), this.clone(this.terminator));
        }
    }

    public static class SetOption
    extends ShellCommand {
        private final QualifiedName name;
        private final OptionalEqualSign sign;
        private final Expression expression;
        private final OptionalTerminator terminator;

        public SetOption(ISourceLocation src, IConstructor node, QualifiedName name, OptionalEqualSign sign, Expression expression, OptionalTerminator terminator) {
            super(src, node);
            this.name = name;
            this.sign = sign;
            this.expression = expression;
            this.terminator = terminator;
        }

        @Override
        public boolean isSetOption() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitShellCommandSetOption(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.name.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.name.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.sign.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.sign.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.expression.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.expression.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.terminator.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.terminator.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof SetOption)) {
                return false;
            }
            SetOption tmp = (SetOption)o;
            return tmp.name.equals(this.name) && tmp.sign.equals(this.sign) && tmp.expression.equals(this.expression) && tmp.terminator.equals(this.terminator);
        }

        @Override
        public int hashCode() {
            return 631 + 449 * this.name.hashCode() + 113 * this.sign.hashCode() + 659 * this.expression.hashCode() + 113 * this.terminator.hashCode();
        }

        @Override
        public QualifiedName getName() {
            return this.name;
        }

        @Override
        public boolean hasName() {
            return true;
        }

        @Override
        public OptionalEqualSign getSign() {
            return this.sign;
        }

        @Override
        public boolean hasSign() {
            return true;
        }

        @Override
        public Expression getExpression() {
            return this.expression;
        }

        @Override
        public boolean hasExpression() {
            return true;
        }

        @Override
        public OptionalTerminator getTerminator() {
            return this.terminator;
        }

        @Override
        public boolean hasTerminator() {
            return true;
        }

        @Override
        public Object clone() {
            return SetOption.newInstance(this.getClass(), this.src, null, this.clone(this.name), this.clone(this.sign), this.clone(this.expression), this.clone(this.terminator));
        }
    }

    public static class Quit
    extends ShellCommand {
        private final OptionalTerminator terminator;

        public Quit(ISourceLocation src, IConstructor node, OptionalTerminator terminator) {
            super(src, node);
            this.terminator = terminator;
        }

        @Override
        public boolean isQuit() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitShellCommandQuit(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.terminator.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.terminator.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Quit)) {
                return false;
            }
            Quit tmp = (Quit)o;
            return tmp.terminator.equals(this.terminator);
        }

        @Override
        public int hashCode() {
            return 127 + 607 * this.terminator.hashCode();
        }

        @Override
        public OptionalTerminator getTerminator() {
            return this.terminator;
        }

        @Override
        public boolean hasTerminator() {
            return true;
        }

        @Override
        public Object clone() {
            return Quit.newInstance(this.getClass(), this.src, null, this.clone(this.terminator));
        }
    }

    public static class ListModules
    extends ShellCommand {
        private final OptionalTerminator terminator;

        public ListModules(ISourceLocation src, IConstructor node, OptionalTerminator terminator) {
            super(src, node);
            this.terminator = terminator;
        }

        @Override
        public boolean isListModules() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitShellCommandListModules(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.terminator.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.terminator.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof ListModules)) {
                return false;
            }
            ListModules tmp = (ListModules)o;
            return tmp.terminator.equals(this.terminator);
        }

        @Override
        public int hashCode() {
            return 997 + 857 * this.terminator.hashCode();
        }

        @Override
        public OptionalTerminator getTerminator() {
            return this.terminator;
        }

        @Override
        public boolean hasTerminator() {
            return true;
        }

        @Override
        public Object clone() {
            return ListModules.newInstance(this.getClass(), this.src, null, this.clone(this.terminator));
        }
    }

    public static class ListDeclarations
    extends ShellCommand {
        private final OptionalTerminator terminator;

        public ListDeclarations(ISourceLocation src, IConstructor node, OptionalTerminator terminator) {
            super(src, node);
            this.terminator = terminator;
        }

        @Override
        public boolean isListDeclarations() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitShellCommandListDeclarations(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.terminator.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.terminator.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof ListDeclarations)) {
                return false;
            }
            ListDeclarations tmp = (ListDeclarations)o;
            return tmp.terminator.equals(this.terminator);
        }

        @Override
        public int hashCode() {
            return 397 + 929 * this.terminator.hashCode();
        }

        @Override
        public OptionalTerminator getTerminator() {
            return this.terminator;
        }

        @Override
        public boolean hasTerminator() {
            return true;
        }

        @Override
        public Object clone() {
            return ListDeclarations.newInstance(this.getClass(), this.src, null, this.clone(this.terminator));
        }
    }

    public static class History
    extends ShellCommand {
        private final OptionalTerminator terminator;

        public History(ISourceLocation src, IConstructor node, OptionalTerminator terminator) {
            super(src, node);
            this.terminator = terminator;
        }

        @Override
        public boolean isHistory() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitShellCommandHistory(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.terminator.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.terminator.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof History)) {
                return false;
            }
            History tmp = (History)o;
            return tmp.terminator.equals(this.terminator);
        }

        @Override
        public int hashCode() {
            return 479 + 383 * this.terminator.hashCode();
        }

        @Override
        public OptionalTerminator getTerminator() {
            return this.terminator;
        }

        @Override
        public boolean hasTerminator() {
            return true;
        }

        @Override
        public Object clone() {
            return History.newInstance(this.getClass(), this.src, null, this.clone(this.terminator));
        }
    }

    public static class Help
    extends ShellCommand {
        private final OptionalTerminator terminator;

        public Help(ISourceLocation src, IConstructor node, OptionalTerminator terminator) {
            super(src, node);
            this.terminator = terminator;
        }

        @Override
        public boolean isHelp() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitShellCommandHelp(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.terminator.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.terminator.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Help)) {
                return false;
            }
            Help tmp = (Help)o;
            return tmp.terminator.equals(this.terminator);
        }

        @Override
        public int hashCode() {
            return 271 + 907 * this.terminator.hashCode();
        }

        @Override
        public OptionalTerminator getTerminator() {
            return this.terminator;
        }

        @Override
        public boolean hasTerminator() {
            return true;
        }

        @Override
        public Object clone() {
            return Help.newInstance(this.getClass(), this.src, null, this.clone(this.terminator));
        }
    }

    public static class Edit
    extends ShellCommand {
        private final QualifiedName name;
        private final OptionalTerminator terminator;

        public Edit(ISourceLocation src, IConstructor node, QualifiedName name, OptionalTerminator terminator) {
            super(src, node);
            this.name = name;
            this.terminator = terminator;
        }

        @Override
        public boolean isEdit() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitShellCommandEdit(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.name.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.name.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.terminator.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.terminator.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Edit)) {
                return false;
            }
            Edit tmp = (Edit)o;
            return tmp.name.equals(this.name) && tmp.terminator.equals(this.terminator);
        }

        @Override
        public int hashCode() {
            return 449 + 983 * this.name.hashCode() + 523 * this.terminator.hashCode();
        }

        @Override
        public QualifiedName getName() {
            return this.name;
        }

        @Override
        public boolean hasName() {
            return true;
        }

        @Override
        public OptionalTerminator getTerminator() {
            return this.terminator;
        }

        @Override
        public boolean hasTerminator() {
            return true;
        }

        @Override
        public Object clone() {
            return Edit.newInstance(this.getClass(), this.src, null, this.clone(this.name), this.clone(this.terminator));
        }
    }

    public static class Clear
    extends ShellCommand {
        private final OptionalTerminator terminator;

        public Clear(ISourceLocation src, IConstructor node, OptionalTerminator terminator) {
            super(src, node);
            this.terminator = terminator;
        }

        @Override
        public boolean isClear() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitShellCommandClear(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.terminator.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.terminator.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Clear)) {
                return false;
            }
            Clear tmp = (Clear)o;
            return tmp.terminator.equals(this.terminator);
        }

        @Override
        public int hashCode() {
            return 283 + 727 * this.terminator.hashCode();
        }

        @Override
        public OptionalTerminator getTerminator() {
            return this.terminator;
        }

        @Override
        public boolean hasTerminator() {
            return true;
        }

        @Override
        public Object clone() {
            return Clear.newInstance(this.getClass(), this.src, null, this.clone(this.terminator));
        }
    }
}

