/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.debug;

import java.util.Collection;
import org.rascalmpl.debug.IRascalEventListener;
import org.rascalmpl.debug.IRascalEventTrigger;
import org.rascalmpl.debug.RascalEvent;

public abstract class AbstractInterpreterEventTrigger
implements IRascalEventTrigger {
    private Object source;

    public AbstractInterpreterEventTrigger(Object source) {
        this.source = source;
    }

    protected abstract void fireEvent(RascalEvent var1);

    public void fireCreationEvent() {
        this.fireEvent(new RascalEvent(this.source, RascalEvent.Kind.CREATE));
    }

    public void fireTerminateEvent() {
        this.fireEvent(new RascalEvent(this.source, RascalEvent.Kind.TERMINATE));
    }

    public void fireResumeEvent(RascalEvent.Detail detail) {
        this.fireEvent(new RascalEvent(this.source, RascalEvent.Kind.RESUME, detail));
    }

    public void fireResumeByStepIntoEvent() {
        this.fireResumeEvent(RascalEvent.Detail.STEP_INTO);
    }

    public void fireResumeByStepOverEvent() {
        this.fireResumeEvent(RascalEvent.Detail.STEP_OVER);
    }

    public void fireResumeByStepOutEvent() {
        this.fireResumeEvent(RascalEvent.Detail.STEP_OUT);
    }

    public void fireResumeByClientRequestEvent() {
        this.fireResumeEvent(RascalEvent.Detail.CLIENT_REQUEST);
    }

    public void fireSuspendEvent(RascalEvent.Detail detail) {
        this.fireEvent(new RascalEvent(this.source, RascalEvent.Kind.SUSPEND, detail));
    }

    public void fireSuspendByClientRequestEvent() {
        this.fireSuspendEvent(RascalEvent.Detail.CLIENT_REQUEST);
    }

    public void fireSuspendByStepEndEvent() {
        this.fireSuspendEvent(RascalEvent.Detail.STEP_END);
    }

    public void fireSuspendByBreakpointEvent(Object data) {
        RascalEvent event = new RascalEvent(this.source, RascalEvent.Kind.SUSPEND, RascalEvent.Detail.BREAKPOINT);
        event.setData(data);
        this.fireEvent(event);
    }

    public void fireIdleEvent() {
        this.fireEvent(new RascalEvent(this.source, RascalEvent.Kind.IDLE));
    }

    public static AbstractInterpreterEventTrigger newNullEventTrigger() {
        return new NullEventTrigger();
    }

    public static AbstractInterpreterEventTrigger newInterpreterEventTrigger(Object source, Collection<IRascalEventListener> eventListeners) {
        return new InterpreterEventTrigger(source, eventListeners);
    }

    protected static class InterpreterEventTrigger
    extends AbstractInterpreterEventTrigger {
        private final Collection<IRascalEventListener> eventListeners;

        public InterpreterEventTrigger(Object source, Collection<IRascalEventListener> eventListeners) {
            super(source);
            this.eventListeners = eventListeners;
        }

        @Override
        protected void fireEvent(RascalEvent event) {
            for (IRascalEventListener listener : this.eventListeners) {
                listener.handleRascalEvent(event);
            }
        }

        @Override
        public void addRascalEventListener(IRascalEventListener listener) {
            if (!this.eventListeners.contains(listener)) {
                this.eventListeners.add(listener);
            }
        }

        @Override
        public void removeRascalEventListener(IRascalEventListener listener) {
            this.eventListeners.remove(listener);
        }
    }

    protected static class NullEventTrigger
    extends AbstractInterpreterEventTrigger {
        public NullEventTrigger() {
            super(new Object());
        }

        @Override
        protected void fireEvent(RascalEvent event) {
        }

        @Override
        public void addRascalEventListener(IRascalEventListener listener) {
        }

        @Override
        public void removeRascalEventListener(IRascalEventListener listener) {
        }
    }
}

