/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter;

public class Configuration {
    public static final String RASCAL_FILE_EXT = ".rsc";
    public static final String RASCAL_BIN_FILE_EXT = ".bin";
    public static final String SDF_EXT = ".sdf";
    public static final String RASCAL_MODULE_SEP = "::";
    public static final String RASCAL_PATH_SEP = "/";
    public static final String PROFILING_PROPERTY = "rascal.profiling";
    public static final String GENERATOR_PROFILING_PROPERTY = "rascal.generatorProfiling";
    public static final String TRACING_PROPERTY = "rascal.tracing";
    public static final String ERRORS_PROPERTY = "rascal.errors";
    public static final String DEBUGGING_PROPERTY = "rascal.debugging";
    private boolean profiling = Configuration.getDefaultBoolean("rascal.profiling", false);
    private boolean generatorProfiling = Configuration.getDefaultBoolean("rascal.generatorProfiling", false);
    private boolean tracing = Configuration.getDefaultBoolean("rascal.tracing", false);
    private boolean errors = Configuration.getDefaultBoolean("rascal.errors", false);
    private boolean debugging = Configuration.getDefaultBoolean("rascal.debugging", false);

    private static boolean getDefaultBoolean(String property, boolean def) {
        String prop = System.getProperty(property);
        if (prop == null) {
            return def;
        }
        return prop.equals("true");
    }

    public boolean getDebuggingProperty() {
        return this.debugging;
    }

    public boolean getProfilingProperty() {
        return this.profiling;
    }

    public boolean getGeneratorProfilingProperty() {
        return this.generatorProfiling;
    }

    public boolean getTracingProperty() {
        return this.tracing;
    }

    public boolean printErrors() {
        return this.errors;
    }

    public void setErrors(boolean errors) {
        this.errors = errors;
    }

    public void setProfiling(boolean profiling) {
        this.profiling = profiling;
    }

    public void setGeneratorProfiling(boolean profiling) {
        this.generatorProfiling = profiling;
    }

    public void setTracing(boolean tracing) {
        this.tracing = tracing;
    }

    public void setDebugging(boolean debugging) {
        this.debugging = debugging;
    }
}

