/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter;

import io.usethesource.vallang.IValue;
import io.usethesource.vallang.exceptions.FactTypeDeclarationException;
import io.usethesource.vallang.exceptions.FactTypeRedeclaredException;
import io.usethesource.vallang.exceptions.RedeclaredConstructorException;
import io.usethesource.vallang.exceptions.RedeclaredFieldNameException;
import io.usethesource.vallang.type.TypeFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.rascalmpl.ast.Declaration;
import org.rascalmpl.ast.KeywordFormal;
import org.rascalmpl.ast.NullASTVisitor;
import org.rascalmpl.ast.QualifiedName;
import org.rascalmpl.ast.Toplevel;
import org.rascalmpl.ast.Type;
import org.rascalmpl.ast.TypeArg;
import org.rascalmpl.ast.TypeVar;
import org.rascalmpl.ast.UserType;
import org.rascalmpl.ast.Variant;
import org.rascalmpl.exceptions.ImplementationError;
import org.rascalmpl.interpreter.Evaluator;
import org.rascalmpl.interpreter.IEvaluator;
import org.rascalmpl.interpreter.env.Environment;
import org.rascalmpl.interpreter.result.ConstructorFunction;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.staticErrors.IllegalQualifiedDeclaration;
import org.rascalmpl.interpreter.staticErrors.RedeclaredField;
import org.rascalmpl.interpreter.staticErrors.RedeclaredType;
import org.rascalmpl.interpreter.staticErrors.SyntaxError;
import org.rascalmpl.interpreter.staticErrors.UndeclaredType;
import org.rascalmpl.interpreter.staticErrors.UnsupportedOperation;
import org.rascalmpl.interpreter.utils.Names;

public class TypeDeclarationEvaluator {
    private Evaluator eval;
    private Environment env;
    private static List<String> TreeDeclaringModules = Arrays.asList("lang::rascalcore::check::AType", "ParseTree");

    public TypeDeclarationEvaluator(Evaluator eval) {
        this.eval = eval;
    }

    public void evaluateDeclarations(List<Toplevel> decls, Environment env, boolean ignoreErrors) {
        this.env = env;
        HashSet<UserType> abstractDataTypes = new HashSet<UserType>();
        HashSet<Declaration.Data> constructorDecls = new HashSet<Declaration.Data>();
        HashSet<Declaration.Alias> aliasDecls = new HashSet<Declaration.Alias>();
        HashSet<Declaration.Annotation> annotationDecls = new HashSet<Declaration.Annotation>();
        this.collectDeclarations(decls, abstractDataTypes, constructorDecls, aliasDecls, annotationDecls);
        this.declareAbstractDataTypes(abstractDataTypes);
        if (!ignoreErrors) {
            this.declareAnnotations(annotationDecls);
        }
        this.declareAliases(aliasDecls, ignoreErrors);
        if (!ignoreErrors) {
            this.declareConstructors(constructorDecls, ignoreErrors);
        }
    }

    private void declareAnnotations(Set<Declaration.Annotation> annotationDecls) {
        for (Declaration.Annotation anno : annotationDecls) {
            this.declareAnnotation(anno, this.env);
        }
    }

    private void declareAnnotation(Declaration.Annotation anno, Environment env2) {
        anno.interpret(this.eval);
    }

    private void declareConstructors(Set<Declaration.Data> constructorDecls, boolean ignoreErrors) {
        for (Declaration.Data data : constructorDecls) {
            try {
                this.declareConstructor(data, this.env);
            }
            catch (UndeclaredType e) {
                if (ignoreErrors) {
                    return;
                }
                throw e;
            }
        }
    }

    public static io.usethesource.vallang.type.Type computeKeywordParametersType(List<KeywordFormal> kws, IEvaluator<Result<IValue>> eval) {
        io.usethesource.vallang.type.Type[] kwTypes = new io.usethesource.vallang.type.Type[kws.size()];
        String[] kwLabels = new String[kws.size()];
        int i = 0;
        for (KeywordFormal kw : kws) {
            kwLabels[i] = Names.name(kw.getName());
            kwTypes[i++] = kw.getType().typeOf(eval.getCurrentEnvt(), eval, true);
        }
        return TypeFactory.getInstance().tupleType(kwTypes, kwLabels);
    }

    public void declareConstructor(Declaration.Data x, Environment env) {
        List<KeywordFormal> common;
        TypeFactory tf = TypeFactory.getInstance();
        io.usethesource.vallang.type.Type adt = this.declareAbstractDataType(x.getUser(), env);
        if (adt.getName().equals("Tree") && !TreeDeclaringModules.contains(env.getRoot().getName())) {
            throw new UnsupportedOperation("The Tree data-type from the ParseTree library module is \"final\"; it can not be extended. Please choose another name.", x.getUser());
        }
        List<KeywordFormal> list = common = x.getCommonKeywordParameters().isPresent() ? x.getCommonKeywordParameters().getKeywordFormalList() : Collections.emptyList();
        if (common.size() > 0) {
            env.declareGenericKeywordParameters(adt, TypeDeclarationEvaluator.computeKeywordParametersType(common, this.eval), common);
        }
        for (Variant var : x.getVariants()) {
            String altName = Names.name(var.getName());
            if (!var.isNAryConstructor()) continue;
            List<KeywordFormal> local = var.getKeywordArguments().hasKeywordFormalList() ? var.getKeywordArguments().getKeywordFormalList() : Collections.emptyList();
            List<TypeArg> args = var.getArguments();
            int nAllArgs = args.size();
            io.usethesource.vallang.type.Type[] fields = new io.usethesource.vallang.type.Type[nAllArgs];
            String[] labels = new String[nAllArgs];
            for (int i = 0; i < args.size(); ++i) {
                TypeArg arg = args.get(i);
                fields[i] = arg.getType().typeOf(env, this.eval, true);
                if (fields[i] == null) {
                    throw new UndeclaredType(arg.hasName() ? Names.name(arg.getName()) : "?", arg);
                }
                labels[i] = arg.hasName() ? Names.name(arg.getName()) : "arg" + Integer.toString(i);
            }
            try {
                ConstructorFunction cons = env.constructorFromTuple(var, this.eval, adt, altName, tf.tupleType(fields, labels), local);
                if (local.size() <= 0) continue;
                io.usethesource.vallang.type.Type kwType = TypeDeclarationEvaluator.computeKeywordParametersType(local, this.eval);
                for (String label : kwType.getFieldNames()) {
                    env.getStore().declareKeywordParameter(cons.getConstructorType(), label, kwType.getFieldType(label));
                }
            }
            catch (RedeclaredConstructorException e) {
                throw new RedeclaredType(altName, var);
            }
            catch (RedeclaredFieldNameException e) {
                throw new RedeclaredField(e.getMessage(), var);
            }
        }
    }

    public void declareAbstractADT(Declaration.DataAbstract x, Environment env) {
        List<KeywordFormal> common;
        io.usethesource.vallang.type.Type adt = this.declareAbstractDataType(x.getUser(), env);
        List<KeywordFormal> list = common = x.getCommonKeywordParameters().isPresent() ? x.getCommonKeywordParameters().getKeywordFormalList() : Collections.emptyList();
        if (common.size() > 0) {
            env.declareGenericKeywordParameters(adt, TypeDeclarationEvaluator.computeKeywordParametersType(common, this.eval), common);
        }
    }

    private void declareAliases(Set<Declaration.Alias> aliasDecls, boolean ignoreErrors) {
        LinkedList<Declaration.Alias> todo = new LinkedList<Declaration.Alias>();
        todo.addAll(aliasDecls);
        int countdown = todo.size();
        while (!todo.isEmpty()) {
            Declaration.Alias trial = (Declaration.Alias)todo.remove(0);
            --countdown;
            try {
                this.declareAlias(trial, this.env);
                countdown = todo.size();
            }
            catch (UndeclaredType e) {
                if (countdown == 0) {
                    if (!ignoreErrors) {
                        throw e;
                    }
                    return;
                }
                todo.add(trial);
            }
        }
    }

    public void declareAlias(Declaration.Alias x, Environment env) {
        try {
            io.usethesource.vallang.type.Type base = x.getBase().typeOf(env, this.eval, false);
            assert (base != null);
            QualifiedName name = x.getUser().getName();
            if (Names.isQualified(name)) {
                throw new IllegalQualifiedDeclaration(name);
            }
            env.aliasType(Names.typeName(name), base, this.computeTypeParameters(x.getUser(), env));
        }
        catch (FactTypeRedeclaredException e) {
            throw new RedeclaredType(e.getName(), x);
        }
        catch (FactTypeDeclarationException e) {
            throw new ImplementationError("Unknown FactTypeDeclarationException: " + e.getMessage());
        }
    }

    private void declareAbstractDataTypes(Set<UserType> abstractDataTypes) {
        LinkedList<UserType> todo = new LinkedList<UserType>();
        todo.addAll(abstractDataTypes);
        int countdown = todo.size();
        while (!todo.isEmpty()) {
            UserType trial = (UserType)todo.remove(0);
            --countdown;
            try {
                this.declareAbstractDataType(trial, this.env);
                countdown = todo.size();
            }
            catch (UndeclaredType e) {
                if (countdown == 0) {
                    throw e;
                }
                todo.add(trial);
            }
        }
    }

    public io.usethesource.vallang.type.Type declareAbstractDataType(UserType decl, Environment env) {
        QualifiedName name = decl.getName();
        if (Names.isQualified(name)) {
            throw new IllegalQualifiedDeclaration(name);
        }
        return env.abstractDataType(Names.typeName(name), this.computeTypeParameters(decl, env));
    }

    private io.usethesource.vallang.type.Type[] computeTypeParameters(UserType decl, Environment env) {
        io.usethesource.vallang.type.Type[] params;
        TypeFactory tf = TypeFactory.getInstance();
        if (decl.isParametric()) {
            List<Type> formals = decl.getParameters();
            params = new io.usethesource.vallang.type.Type[formals.size()];
            int i = 0;
            for (Type formal : formals) {
                if (!formal.isVariable()) {
                    throw new SyntaxError("Declaration of parameterized type with type instance " + formal + " is not allowed", formal.getLocation());
                }
                TypeVar var = formal.getTypeVar();
                io.usethesource.vallang.type.Type bound = var.hasBound() ? var.getBound().typeOf(env, this.eval, false) : tf.valueType();
                params[i++] = tf.parameterType(Names.name(var.getName()), bound);
            }
        } else {
            params = new io.usethesource.vallang.type.Type[]{};
        }
        return params;
    }

    private void collectDeclarations(List<Toplevel> decls, Set<UserType> abstractDataTypes, Set<Declaration.Data> constructorDecls, Set<Declaration.Alias> aliasDecls, Set<Declaration.Annotation> annotations) {
        DeclarationCollector collector = new DeclarationCollector(abstractDataTypes, constructorDecls, aliasDecls, annotations);
        for (Toplevel t2 : decls) {
            t2.accept(collector);
        }
    }

    private static class DeclarationCollector
    extends NullASTVisitor<Declaration> {
        private final Set<UserType> abstractDataTypes;
        private final Set<Declaration.Data> constructorDecls;
        private final Set<Declaration.Alias> aliasDecls;
        private final Set<Declaration.Annotation> annotations;

        public DeclarationCollector(Set<UserType> abstractDataTypes, Set<Declaration.Data> constructorDecls, Set<Declaration.Alias> aliasDecls, Set<Declaration.Annotation> annotations) {
            this.abstractDataTypes = abstractDataTypes;
            this.constructorDecls = constructorDecls;
            this.aliasDecls = aliasDecls;
            this.annotations = annotations;
        }

        @Override
        public Declaration visitToplevelGivenVisibility(Toplevel.GivenVisibility x) {
            return x.getDeclaration().accept(this);
        }

        @Override
        public Declaration visitDeclarationAlias(Declaration.Alias x) {
            this.aliasDecls.add(x);
            return x;
        }

        @Override
        public Declaration visitDeclarationData(Declaration.Data x) {
            this.abstractDataTypes.add(x.getUser());
            this.constructorDecls.add(x);
            return x;
        }

        @Override
        public Declaration visitDeclarationDataAbstract(Declaration.DataAbstract x) {
            this.abstractDataTypes.add(x.getUser());
            return x;
        }

        @Override
        public Declaration visitDeclarationAnnotation(Declaration.Annotation x) {
            this.annotations.add(x);
            return x;
        }
    }
}

