/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.matching;

import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.matching.AbstractBooleanResult;
import org.rascalmpl.interpreter.matching.IBooleanResult;

public class AndResult
extends AbstractBooleanResult {
    private final IBooleanResult left;
    private final IBooleanResult right;
    private boolean firstMatch = true;
    private boolean leftResult;

    public AndResult(IEvaluatorContext ctx, IBooleanResult left, IBooleanResult right) {
        super(ctx);
        this.left = left;
        this.right = right;
    }

    @Override
    public void init() {
        super.init();
        this.leftResult = false;
        this.left.init();
        this.firstMatch = true;
    }

    @Override
    public boolean hasNext() {
        if (this.firstMatch) {
            return this.left.hasNext();
        }
        return this.left.hasNext() || this.leftResult && this.right.hasNext();
    }

    @Override
    public boolean next() {
        if (this.firstMatch) {
            this.firstMatch = false;
            this.leftResult = this.left.next();
            if (this.leftResult) {
                this.right.init();
            }
        }
        if (this.leftResult) {
            return this.nextRight();
        }
        return false;
    }

    private boolean nextRight() {
        if (this.right.hasNext() && this.right.next()) {
            return true;
        }
        if (this.left.hasNext()) {
            this.leftResult = this.left.next();
            this.right.init();
            return this.next();
        }
        return false;
    }
}

