/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.result;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.result.ElementResult;
import org.rascalmpl.interpreter.result.LessThanOrEqualResult;
import org.rascalmpl.interpreter.result.ListOrRelationResult;
import org.rascalmpl.interpreter.result.ListRelationResult;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.result.ResultFactory;
import org.rascalmpl.interpreter.staticErrors.UnexpectedType;
import org.rascalmpl.interpreter.staticErrors.UnsupportedSubscriptArity;

public class ListResult
extends ListOrRelationResult<IList> {
    public ListResult(Type type, IList list, IEvaluatorContext ctx) {
        super(type, list, ctx);
    }

    @Override
    public Result<IBool> isKeyDefined(Result<?>[] subscripts) {
        if (subscripts.length != 1) {
            throw new UnsupportedSubscriptArity(this.getStaticType(), subscripts.length, this.ctx.getCurrentAST());
        }
        Result<?> key = subscripts[0];
        if (!key.getStaticType().isSubtypeOf(this.getTypeFactory().integerType())) {
            throw new UnexpectedType(this.getTypeFactory().integerType(), key.getStaticType(), this.ctx.getCurrentAST());
        }
        int idx = ((IInteger)key.getValue()).intValue();
        int len = ((IList)this.getValue()).length();
        if (idx >= 0 && idx >= len || idx < 0 && idx < -len) {
            return ResultFactory.makeResult(this.getTypeFactory().boolType(), this.getValueFactory().bool(false), this.ctx);
        }
        return ResultFactory.makeResult(this.getTypeFactory().boolType(), this.getValueFactory().bool(true), this.ctx);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> add(Result<V> result) {
        return result.addList(this);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> subtract(Result<V> result) {
        return result.subtractList(this);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> join(Result<V> that) {
        return that.joinList(this);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> intersect(Result<V> result) {
        return result.intersectList(this);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> multiply(Result<V> result) {
        return result.multiplyList(this);
    }

    @Override
    public <V extends IValue> Result<IBool> in(Result<V> result) {
        return result.inList(this);
    }

    @Override
    public <V extends IValue> Result<IBool> notIn(Result<V> result) {
        return result.notInList(this);
    }

    @Override
    public <V extends IValue> Result<IBool> equals(Result<V> that) {
        return that.equalToList(this);
    }

    @Override
    public <V extends IValue> Result<IBool> nonEquals(Result<V> that) {
        return that.nonEqualToList(this);
    }

    @Override
    public <V extends IValue> Result<IBool> lessThan(Result<V> that) {
        return that.lessThanList(this);
    }

    @Override
    public <V extends IValue> LessThanOrEqualResult lessThanOrEqual(Result<V> that) {
        return that.lessThanOrEqualList(this);
    }

    @Override
    public <V extends IValue> Result<IBool> greaterThan(Result<V> that) {
        return that.greaterThanList(this);
    }

    @Override
    public <V extends IValue> Result<IBool> greaterThanOrEqual(Result<V> that) {
        return that.greaterThanOrEqualList(this);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> subscript(Result<?>[] subscripts) {
        if (subscripts.length != 1) {
            throw new UnsupportedSubscriptArity(this.getStaticType(), subscripts.length, this.ctx.getCurrentAST());
        }
        Result<?> key = subscripts[0];
        if (!key.getStaticType().isInteger()) {
            throw new UnexpectedType(TypeFactory.getInstance().integerType(), key.getStaticType(), this.ctx.getCurrentAST());
        }
        if (((IList)this.getValue()).length() == 0) {
            throw RuntimeExceptionFactory.emptyList(this.ctx.getCurrentAST(), this.ctx.getStackTrace());
        }
        IInteger index = (IInteger)key.getValue();
        int idx = index.intValue();
        if (idx < 0) {
            idx += ((IList)this.getValue()).length();
        }
        if (idx >= ((IList)this.getValue()).length() || idx < 0) {
            throw RuntimeExceptionFactory.indexOutOfBounds(index, this.ctx.getCurrentAST(), this.ctx.getStackTrace());
        }
        return ResultFactory.makeResult(this.getStaticType().getElementType(), ((IList)this.getValue()).get(idx), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> addList(ListResult l) {
        return ResultFactory.makeResult(this.getStaticType().lub(l.getStaticType()), ((IList)l.getValue()).concat((IList)this.getValue()), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> subtractList(ListResult l) {
        IList list = (IList)l.getValue();
        for (IValue v : (IList)this.getValue()) {
            if (!list.contains(v)) continue;
            list = list.delete(v);
        }
        return ResultFactory.makeResult(l.getStaticType(), list, this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> multiplyList(ListResult that) {
        Type t1 = that.type.getElementType();
        Type t2 = this.type.getElementType();
        Type type = this.getTypeFactory().listType(this.getTypeFactory().tupleType(t1, t2));
        IListWriter w = this.getValueFactory().listWriter();
        for (IValue v1 : (IList)that.getValue()) {
            for (IValue v2 : (IList)this.getValue()) {
                w.append(this.getValueFactory().tuple(v1, v2));
            }
        }
        return ResultFactory.makeResult(type, w.done(), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> intersectList(ListResult that) {
        IListWriter w = this.getValueFactory().listWriter();
        Type type = this.getStaticType().lub(that.getStaticType());
        for (IValue v : (IList)that.getValue()) {
            if (!((IList)this.getValue()).contains(v)) continue;
            w.append(v);
        }
        return ResultFactory.makeResult(type, w.done(), this.ctx);
    }

    <U extends IValue, V extends IValue> Result<U> appendElement(ElementResult<V> that) {
        Type newType = this.getTypeFactory().listType(that.getStaticType().lub(this.getStaticType().getElementType()));
        return ResultFactory.makeResult(newType, ((IList)this.value).append((IValue)that.getValue()), this.ctx);
    }

    @Override
    protected <U extends IValue, V extends IValue> Result<U> removeElement(ElementResult<V> value) {
        IList list = (IList)this.getValue();
        return ResultFactory.makeResult(this.getStaticType(), list.delete((IValue)value.getValue()), this.ctx);
    }

    @Override
    protected <V extends IValue> Result<IBool> elementOf(ElementResult<V> elementResult) {
        return ResultFactory.bool(((IList)this.getValue()).contains((IValue)elementResult.getValue()), this.ctx);
    }

    @Override
    protected <V extends IValue> Result<IBool> notElementOf(ElementResult<V> elementResult) {
        return ResultFactory.bool(!((IList)this.getValue()).contains((IValue)elementResult.getValue()), this.ctx);
    }

    @Override
    protected Result<IBool> equalToList(ListResult that) {
        return that.equalityBoolean(this);
    }

    @Override
    protected Result<IBool> nonEqualToList(ListResult that) {
        return that.nonEqualityBoolean(this);
    }

    @Override
    protected Result<IBool> nonEqualToListRelation(ListRelationResult that) {
        return that.nonEqualityBoolean(this);
    }

    @Override
    protected Result<IBool> greaterThanList(ListResult that) {
        return that.lessThanList(this);
    }

    @Override
    protected Result<IBool> greaterThanOrEqualList(ListResult that) {
        return that.lessThanOrEqualList(this);
    }

    @Override
    protected Result<IBool> lessThanList(ListResult that) {
        IList val = (IList)that.getValue();
        if (val.length() > ((IList)this.value).length()) {
            return ResultFactory.bool(false, this.ctx);
        }
        int iThis = 0;
        block0: for (int iThat = 0; iThat < val.length(); ++iThat) {
            for (iThis = Math.max(iThis, iThat); iThis < ((IList)this.value).length(); ++iThis) {
                if (!val.get(iThat).equals(((IList)this.value).get(iThis))) continue;
                ++iThis;
                continue block0;
            }
            return ResultFactory.bool(false, this.ctx);
        }
        return ResultFactory.bool(val.length() != ((IList)this.value).length(), this.ctx);
    }

    @Override
    protected LessThanOrEqualResult lessThanOrEqualList(ListResult that) {
        IList left = (IList)that.getValue();
        IList right = (IList)this.getValue();
        if (left.length() == 0) {
            return new LessThanOrEqualResult(right.length() > 0, right.length() == 0, this.ctx);
        }
        if (left.length() > right.length()) {
            return new LessThanOrEqualResult(false, false, this.ctx);
        }
        int iThis = 0;
        block0: for (int iThat = 0; iThat < left.length(); ++iThat) {
            for (iThis = Math.max(iThis, iThat); iThis < right.length(); ++iThis) {
                if (left.get(iThat).equals(right.get(iThis))) continue block0;
            }
            return new LessThanOrEqualResult(false, false, this.ctx);
        }
        return new LessThanOrEqualResult(left.length() < right.length(), left.length() == right.length(), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> joinListRelation(ListRelationResult that) {
        int arity1 = ((IList)that.getValue()).asRelation().arity();
        Type eltType = this.getStaticType().getElementType();
        Type tupleType = that.getStaticType().getElementType();
        Type[] fieldTypes = new Type[arity1 + 1];
        for (int i = 0; i < arity1; ++i) {
            fieldTypes[i] = tupleType.getFieldType(i);
        }
        fieldTypes[arity1] = eltType;
        Type resultTupleType = this.getTypeFactory().tupleType(fieldTypes);
        IListWriter writer = this.getValueFactory().listWriter();
        IValue[] fieldValues = new IValue[arity1 + 1];
        for (IValue relValue : (IList)that.getValue()) {
            for (IValue setValue : (IList)this.getValue()) {
                for (int i = 0; i < arity1; ++i) {
                    fieldValues[i] = ((ITuple)relValue).get(i);
                }
                fieldValues[arity1] = setValue;
                writer.append(this.getValueFactory().tuple(fieldValues));
            }
        }
        Type resultType = this.getTypeFactory().lrelTypeFromTuple(resultTupleType);
        return ResultFactory.makeResult(resultType, writer.done(), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> joinList(ListResult that) {
        Type tupleType = this.getTypeFactory().tupleType(that.getStaticType().getElementType(), this.getStaticType().getElementType());
        return ResultFactory.makeResult(this.getTypeFactory().lrelTypeFromTuple(tupleType), ((IList)that.getValue()).product((IList)this.getValue()), this.ctx);
    }
}

