/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.gtd.stack;

import org.rascalmpl.parser.gtd.result.AbstractNode;
import org.rascalmpl.parser.gtd.result.LiteralNode;
import org.rascalmpl.parser.gtd.stack.AbstractMatchableStackNode;
import org.rascalmpl.parser.gtd.stack.AbstractStackNode;
import org.rascalmpl.parser.gtd.stack.StackNodeVisitor;
import org.rascalmpl.parser.gtd.stack.filter.ICompletionFilter;
import org.rascalmpl.parser.gtd.stack.filter.IEnterFilter;

public final class LiteralStackNode<P>
extends AbstractMatchableStackNode<P> {
    private final int[] literal;
    private final P production;
    private final LiteralNode result;

    public LiteralStackNode(int id, int dot, P production, int[] literal) {
        super(id, dot);
        this.literal = literal;
        this.production = production;
        this.result = new LiteralNode(production, literal);
    }

    public LiteralStackNode(int id, int dot, P production, int[] literal, IEnterFilter[] enterFilters, ICompletionFilter[] completionFilters) {
        super(id, dot, enterFilters, completionFilters);
        this.literal = literal;
        this.production = production;
        this.result = new LiteralNode(production, literal);
    }

    public int[] getLiteral() {
        return this.literal;
    }

    private LiteralStackNode(LiteralStackNode<P> original, int startLocation) {
        super(original, startLocation);
        this.literal = original.literal;
        this.production = original.production;
        this.result = original.result;
    }

    @Override
    public boolean isEmptyLeafNode() {
        return false;
    }

    @Override
    public AbstractNode match(int[] input, int location) {
        for (int i = this.literal.length - 1; i >= 0; --i) {
            if (this.literal[i] == input[location + i]) continue;
            return null;
        }
        return this.result;
    }

    @Override
    public AbstractStackNode<P> getCleanCopy(int startLocation) {
        return new LiteralStackNode<P>(this, startLocation);
    }

    @Override
    public AbstractStackNode<P> getCleanCopyWithResult(int startLocation, AbstractNode result) {
        return new LiteralStackNode<P>(this, startLocation);
    }

    @Override
    public int getLength() {
        return this.literal.length;
    }

    @Override
    public AbstractNode getResult() {
        return this.result;
    }

    @Override
    public String toShortString() {
        return "'" + new String(this.literal, 0, this.literal.length) + "'";
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("lit['");
        sb.append(new String(this.literal, 0, this.literal.length));
        sb.append("',");
        sb.append(super.toString());
        sb.append(']');
        return sb.toString();
    }

    @Override
    public int hashCode() {
        return this.production.hashCode();
    }

    @Override
    public boolean equals(Object peer) {
        return super.equals(peer);
    }

    @Override
    public boolean isEqual(AbstractStackNode<P> stackNode) {
        if (!(stackNode instanceof LiteralStackNode)) {
            return false;
        }
        LiteralStackNode otherNode = (LiteralStackNode)stackNode;
        if (!this.production.equals(otherNode.production)) {
            return false;
        }
        return this.hasEqualFilters(stackNode);
    }

    @Override
    public <R> R accept(StackNodeVisitor<P, R> visitor) {
        return visitor.visit(this);
    }
}

