/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.uptr.debug;

import io.usethesource.vallang.IConstructor;
import java.io.PrintWriter;
import org.rascalmpl.parser.gtd.debug.IDebugListener;
import org.rascalmpl.parser.gtd.location.PositionStore;
import org.rascalmpl.parser.gtd.result.AbstractNode;
import org.rascalmpl.parser.gtd.result.struct.Link;
import org.rascalmpl.parser.gtd.stack.AbstractStackNode;
import org.rascalmpl.parser.gtd.stack.edge.EdgesSet;
import org.rascalmpl.parser.gtd.util.ArrayList;
import org.rascalmpl.parser.gtd.util.DoubleArrayList;
import org.rascalmpl.parser.gtd.util.DoubleStack;
import org.rascalmpl.parser.gtd.util.Stack;
import org.rascalmpl.values.parsetrees.ProductionAdapter;

public class DebugLogger
implements IDebugListener<IConstructor> {
    private final PrintWriter out;
    private final boolean verbose;

    public DebugLogger(PrintWriter out, boolean verbose) {
        this.out = out;
        this.verbose = verbose;
    }

    public DebugLogger(PrintWriter out) {
        this(out, false);
    }

    private static void collectProductions(AbstractStackNode<IConstructor> node, ArrayList<IConstructor> productions) {
        AbstractStackNode<IConstructor>[] production = node.getProduction();
        if (production == null) {
            return;
        }
        int dot = node.getDot();
        if (node.isEndNode()) {
            IConstructor parentProduction = node.getParentProduction();
            productions.add(parentProduction);
            if (ProductionAdapter.isList(parentProduction)) {
                return;
            }
        }
        for (int i = dot + 1; i < production.length; ++i) {
            AbstractStackNode<IConstructor>[][] alternateProductions;
            AbstractStackNode<IConstructor> currentNode = production[i];
            if (currentNode.isEndNode()) {
                productions.add(currentNode.getParentProduction());
            }
            if ((alternateProductions = currentNode.getAlternateProductions()) == null) continue;
            for (int j = alternateProductions.length - 1; j >= 0; --j) {
                DebugLogger.collectProductions(alternateProductions[j][i], productions);
            }
        }
    }

    private void printProductions(AbstractStackNode<IConstructor> node, boolean indent) {
        ArrayList<IConstructor> productions = new ArrayList<IConstructor>();
        DebugLogger.collectProductions(node, productions);
        for (int i = productions.size() - 1; i >= 0; --i) {
            if (indent) {
                this.out.print('\t');
            }
            this.out.println(productions.get(i));
        }
    }

    @Override
    public void shifting(int offset, int[] input, PositionStore positionStore) {
        int line = positionStore.findLine(offset);
        int column = positionStore.getColumn(offset, line);
        this.out.println(String.format("Shifting to offset: %d (line: %d, column: %d)", offset, line, column));
    }

    @Override
    public void iterating() {
        this.out.println("Iterating");
    }

    @Override
    public void matched(AbstractStackNode<IConstructor> node, AbstractNode result) {
        this.out.println(String.format("Matched: %s", node));
    }

    @Override
    public void failedToMatch(AbstractStackNode<IConstructor> node) {
        this.out.println(String.format("Failed to match: %s", node));
    }

    @Override
    public void expanding(AbstractStackNode<IConstructor> node) {
        this.out.println(String.format("Expanding: %s", node));
        if (this.verbose) {
            this.out.println("\tPart of the following production(s):");
            this.printProductions(node, true);
        }
    }

    @Override
    public void expanded(AbstractStackNode<IConstructor> node, AbstractStackNode<IConstructor> child) {
        this.out.println(String.format("Expanded: %s", node));
    }

    @Override
    public void foundIterationCachedNullableResult(AbstractStackNode<IConstructor> node) {
        this.out.println(String.format("Found cached nullable result for: %s", node));
    }

    @Override
    public void moving(AbstractStackNode<IConstructor> node, AbstractNode result) {
        this.out.println(String.format("Moving: %s", node));
        if (this.verbose) {
            this.out.println("\tPart of the following production(s):");
            this.printProductions(node, true);
        }
    }

    @Override
    public void progressed(AbstractStackNode<IConstructor> node, AbstractNode result, AbstractStackNode<IConstructor> next) {
        this.out.println(String.format("Progressed: %s to %s", node, next));
        if (this.verbose) {
            this.out.println("\tPart of the following production(s):");
            this.printProductions(next, true);
        }
    }

    @Override
    public void propagated(AbstractStackNode<IConstructor> node, AbstractNode nodeResult, AbstractStackNode<IConstructor> next) {
        this.out.println(String.format("Propagated prefixes from %s to %s", node, next));
        if (this.verbose) {
            this.out.println("\tPart of the following production(s):");
            this.printProductions(next, true);
        }
    }

    @Override
    public void reducing(AbstractStackNode<IConstructor> node, Link resultLink, EdgesSet<IConstructor> edges) {
        this.out.println(String.format("Reducing: %s, start location: %d", node.getParentProduction(), edges.get(0).getStartLocation()));
    }

    @Override
    public void reduced(AbstractStackNode<IConstructor> parent) {
        this.out.println(String.format("Reduced to: %s", parent));
        if (this.verbose) {
            this.out.println(String.format("\tPart of the following production(s) (Dot position: %d):", parent.getDot()));
            this.printProductions(parent, true);
        }
    }

    @Override
    public void filteredByNestingRestriction(AbstractStackNode<IConstructor> parent) {
        this.out.println(String.format("Filtered by nesting restriction: %s (parent)", parent));
    }

    @Override
    public void filteredByEnterFilter(AbstractStackNode<IConstructor> node) {
        this.out.println(String.format("Filtered by enter filter restriction: %s", node));
    }

    @Override
    public void filteredByCompletionFilter(AbstractStackNode<IConstructor> node, AbstractNode result) {
        this.out.println(String.format("Filtered by completion filter: %s", node));
    }

    @Override
    public void reviving(int[] input, int location, Stack<AbstractStackNode<IConstructor>> unexpandableNodes, Stack<AbstractStackNode<IConstructor>> unmatchableLeafNodes, DoubleStack<DoubleArrayList<AbstractStackNode<IConstructor>, AbstractNode>, AbstractStackNode<IConstructor>> unmatchableMidProductionNodes, DoubleStack<AbstractStackNode<IConstructor>, AbstractNode> filteredNodes) {
        this.out.print("Reviving at ");
        this.out.print(location);
        this.out.print(": input='");
        for (int i = 0; i < 8 && location + i < input.length; ++i) {
            this.out.print((char)input[location + i]);
        }
        this.out.print("', unexpandable=");
        boolean first = true;
        for (int i = 0; i < unexpandableNodes.getSize(); ++i) {
            if (first) {
                first = false;
            } else {
                this.out.print(", ");
            }
            this.out.print(unexpandableNodes.get(i));
        }
        if (unmatchableLeafNodes.getSize() > 0) {
            this.out.print(", unmatchableLeafNodes=");
            this.out.print(unmatchableLeafNodes.getSize());
        }
        if (unmatchableMidProductionNodes.getSize() > 0) {
            this.out.print(", unmatchableMidProductionNodes=");
            this.out.print(unmatchableMidProductionNodes.toString());
        }
        if (filteredNodes.getSize() > 0) {
            this.out.print(", filteredNodes=");
            this.out.print(filteredNodes.getSize());
        }
        this.out.println();
    }

    @Override
    public void revived(DoubleArrayList<AbstractStackNode<IConstructor>, AbstractNode> recoveredNodes) {
        this.out.println("Revived nodes:");
        for (int i = 0; i < recoveredNodes.size(); ++i) {
            this.out.print("    stack node: ");
            this.out.print(recoveredNodes.getFirst(i));
            this.out.print(", result node: ");
            this.out.println(recoveredNodes.getSecond(i));
        }
    }
}

