/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.repl;

import io.usethesource.vallang.ISourceLocation;
import java.io.PrintWriter;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jline.jansi.Ansi;
import org.jline.terminal.Terminal;
import org.jline.utils.Curses;
import org.jline.utils.InfoCmp;
import org.rascalmpl.debug.IRascalMonitor;

public class TerminalProgressBarMonitor
extends PrintWriter
implements IRascalMonitor {
    private List<ProgressBar> bars = new LinkedList<ProgressBar>();
    private List<UnfinishedLine> unfinishedLines = new ArrayList<UnfinishedLine>(3);
    private int lineWidth;
    private final boolean unicodeEnabled;
    private volatile boolean onNewLine = true;
    private static final boolean DEBUG = false;
    private final Terminal tm;
    private final String hideCursor;
    private final String showCursor;

    public static boolean shouldWorkIn(Terminal tm) {
        Integer cols = tm.getNumericCapability(InfoCmp.Capability.max_colors);
        if (cols == null || cols < 8) {
            return false;
        }
        return "\r".equals(TerminalProgressBarMonitor.interpretCapability(tm.getStringCapability(InfoCmp.Capability.carriage_return))) && tm.getNumericCapability(InfoCmp.Capability.columns) != null && tm.getNumericCapability(InfoCmp.Capability.lines) != null && tm.getStringCapability(InfoCmp.Capability.clear_screen) != null && tm.getStringCapability(InfoCmp.Capability.cursor_up) != null && tm.getStringCapability(InfoCmp.Capability.cursor_down) != null;
    }

    public TerminalProgressBarMonitor(Terminal tm) {
        super(tm.writer());
        this.tm = tm;
        this.lineWidth = tm.getWidth();
        this.unicodeEnabled = tm.encoding().newEncoder().canEncode((TerminalProgressBarMonitor)this.new ProgressBar((String)"", (int)1).clocks[0]);
        this.hideCursor = TerminalProgressBarMonitor.interpretCapability(tm.getStringCapability(InfoCmp.Capability.cursor_invisible));
        this.showCursor = TerminalProgressBarMonitor.interpretCapability(tm.getStringCapability(InfoCmp.Capability.cursor_visible));
    }

    private static String interpretCapability(@Nullable String arg) {
        if (arg == null) {
            return "";
        }
        return Curses.tputs(arg, new Object[0]);
    }

    private void directPrintln(String s2) {
        this.directWrite(s2 + System.lineSeparator());
    }

    private void directWrite(String s2) {
        this.directWrite(s2, 0, s2.length());
    }

    private void directWrite(int c) {
        super.write(c);
    }

    private void directWrite(char[] buf, int offset, int length) {
        super.write(buf, offset, length);
    }

    private void directWrite(String buf, int offset, int length) {
        super.write(buf, offset, length);
    }

    private void directFlush() {
        super.flush();
    }

    private void eraseBars() {
        if (!this.bars.isEmpty()) {
            this.directWrite(Ansi.ansi().cursorUpLine(this.bars.size()).eraseScreen(Ansi.Erase.FORWARD).toString());
        }
        this.directFlush();
    }

    private void printBars() {
        for (ProgressBar pb : this.bars) {
            pb.write();
        }
        this.directFlush();
    }

    private ProgressBar findBarByName(String name) {
        return this.bars.stream().filter(b -> b.threadId == Thread.currentThread().getId()).filter(b -> b.name.equals(name)).findFirst().orElseGet(() -> null);
    }

    private UnfinishedLine findUnfinishedLine() {
        return this.unfinishedLines.stream().filter(l -> l.threadId == Thread.currentThread().getId()).findAny().orElseGet(() -> {
            UnfinishedLine l = new UnfinishedLine();
            this.unfinishedLines.add(l);
            return l;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void jobStart(String name, int workShare, int totalWork) {
        if (totalWork == 0) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.bars.isEmpty()) {
                if (!this.onNewLine) {
                    this.directWrite(System.lineSeparator());
                    this.directFlush();
                }
                this.lineWidth = this.tm.getWidth();
            }
            ProgressBar pb = this.findBarByName(name);
            this.directWrite(this.hideCursor);
            if (pb == null) {
                this.eraseBars();
                this.bars.add(new ProgressBar(name, totalWork));
                this.printBars();
            } else {
                pb.max += totalWork;
                ++pb.nesting;
                pb.update();
            }
            this.directWrite(this.showCursor);
            this.directFlush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void jobStep(String name, String message, int workShare) {
        Object object = this.lock;
        synchronized (object) {
            ProgressBar pb = this.findBarByName(name);
            if (pb != null) {
                pb.worked(workShare, message);
                pb.update();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int jobEnd(String name, boolean succeeded) {
        Object object = this.lock;
        synchronized (object) {
            ProgressBar pb = this.findBarByName(name);
            this.directWrite(this.hideCursor);
            try {
                if (pb != null && --pb.nesting == -1) {
                    this.eraseBars();
                    pb.done();
                    this.bars.remove(pb);
                    this.printBars();
                    if (this.bars.isEmpty()) {
                        this.endAllJobs();
                    }
                    int n = pb.current;
                    return n;
                }
                if (pb == null) return -1;
                pb.done();
                pb.update();
            }
            finally {
                this.directWrite(this.showCursor);
            }
            return -1;
        }
    }

    @Override
    public boolean jobIsCanceled(String name) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void jobTodo(String name, int work) {
        Object object = this.lock;
        synchronized (object) {
            ProgressBar pb = this.findBarByName(name);
            if (pb != null) {
                pb.max += work;
                pb.update();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void warning(String message, ISourceLocation src) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.bars.isEmpty()) {
                this.eraseBars();
            }
            this.directPrintln("[WARNING] " + (String)(src != null ? src + ": " : "") + message);
            this.onNewLine = true;
            if (!this.bars.isEmpty()) {
                this.printBars();
            }
        }
    }

    private static void boundsCheck(int full, int off, int len) {
        if (len < 0 || off < 0 || off > full || off + len > full) {
            throw new IndexOutOfBoundsException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String s2, int off, int len) {
        TerminalProgressBarMonitor.boundsCheck(s2.length(), off, len);
        if (len == 0) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.bars.isEmpty()) {
                this.findUnfinishedLine().write(s2, off, len);
            } else {
                this.directWrite(s2, off, len);
                this.onNewLine = s2.charAt(off + len - 1) == '\n';
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] buf, int off, int len) {
        TerminalProgressBarMonitor.boundsCheck(buf.length, off, len);
        if (len == 0) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.bars.isEmpty()) {
                this.findUnfinishedLine().write(buf, off, len);
            } else {
                this.directWrite(buf, off, len);
                this.onNewLine = buf[off + len - 1] == '\n';
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int c) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.bars.isEmpty()) {
                this.findUnfinishedLine().write(new char[]{(char)c}, 0, 1);
            } else {
                this.directWrite(c);
                this.onNewLine = c == 10;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.bars.isEmpty()) {
                this.write(System.lineSeparator());
            } else {
                super.println();
                this.onNewLine = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endAllJobs() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.bars.isEmpty()) {
                this.eraseBars();
                this.bars.clear();
            }
            for (UnfinishedLine l : this.unfinishedLines) {
                l.flushLastLine();
            }
            this.directWrite(this.showCursor);
            this.directFlush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.endAllJobs();
            }
            finally {
                super.close();
            }
        }
    }

    private class ProgressBar {
        private final long threadId;
        private final String name;
        private int max;
        private int current = 0;
        private int previousWidth = 0;
        private int doneWidth = 0;
        private final int barWidth;
        private final Instant startTime;
        private Duration duration;
        private String message;
        private int stepper;
        private final String[] clocks;
        private final String[] twister;
        public int nesting;
        private static final int BAR_COLOR_BG = 240;

        ProgressBar(String name, int max) {
            this.barWidth = TerminalProgressBarMonitor.this.unicodeEnabled ? TerminalProgressBarMonitor.this.lineWidth - "\u2610 ".length() - " \ud83d\udd50 00:00:00.000 ".length() : TerminalProgressBarMonitor.this.lineWidth - "? ".length() - " - 00:00:00.000 ".length();
            this.message = "";
            this.stepper = 1;
            this.clocks = new String[]{"\ud83d\udd50", "\ud83d\udd51", "\ud83d\udd52", "\ud83d\udd53", "\ud83d\udd54", "\ud83d\udd55", "\ud83d\udd56", "\ud83d\udd57", "\ud83d\udd58", "\ud83d\udd59", "\ud83d\udd5b"};
            this.twister = new String[]{".", ".", "o", "o", "O", "O", "O", "o", "o", ".", "."};
            this.nesting = 0;
            this.threadId = Thread.currentThread().getId();
            this.name = name;
            this.max = Math.max(1, max);
            this.startTime = Instant.now();
            this.duration = Duration.ZERO;
            this.message = "";
        }

        void worked(int amount, String message) {
            if (this.current + amount > this.max) {
                TerminalProgressBarMonitor.this.warning("Monitor of " + this.name + " is over max (" + this.max + ") by " + (this.current + amount - this.max), null);
            }
            this.current = Math.min(this.current + amount, this.max);
            this.duration = Duration.between(this.startTime, Instant.now());
            this.message = message;
        }

        void update() {
            if (this.newWidth() != this.previousWidth) {
                ++this.stepper;
                TerminalProgressBarMonitor.this.directWrite(Ansi.ansi().a(TerminalProgressBarMonitor.this.hideCursor).cursorUpLine(TerminalProgressBarMonitor.this.bars.size() - TerminalProgressBarMonitor.this.bars.indexOf(this)).toString());
                this.write();
                int distance = TerminalProgressBarMonitor.this.bars.size() - TerminalProgressBarMonitor.this.bars.indexOf(this) - 1;
                Ansi ansi = Ansi.ansi();
                if (distance > 0) {
                    ansi = ansi.cursorDownLine(distance);
                }
                TerminalProgressBarMonitor.this.directWrite(ansi.a(TerminalProgressBarMonitor.this.showCursor).toString());
                TerminalProgressBarMonitor.this.directFlush();
            }
        }

        int newWidth() {
            if (this.max != 0) {
                this.current = Math.min(this.max, this.current);
                double partDone = (double)this.current * 1.0 / ((double)this.max * 1.0);
                return (int)Math.floor((double)this.barWidth * partDone);
            }
            return this.barWidth % this.stepper;
        }

        void write() {
            String clock;
            this.previousWidth = this.doneWidth;
            this.doneWidth = this.newWidth();
            String done = TerminalProgressBarMonitor.this.unicodeEnabled ? (this.current >= this.max ? "\u2611 " : "\u2610 ") : (this.current >= this.max ? "X " : "O ");
            Object msg = this.message;
            Object capName = this.name.length() > 0 ? this.name.substring(0, 1).toUpperCase() + this.name.substring(1, this.name.length()) : "";
            capName = this.message.length() > 0 ? (String)capName + ": " : capName;
            msg = (String)capName + (String)msg;
            msg = ((String)msg + " ".repeat(Math.max(0, this.barWidth - ((String)msg).length()))).substring(0, this.barWidth);
            String frontPart = ((String)msg).substring(0, this.doneWidth);
            String backPart = ((String)msg).substring(this.doneWidth, ((String)msg).length());
            String string = clock = TerminalProgressBarMonitor.this.unicodeEnabled ? this.clocks[this.stepper % this.clocks.length] : this.twister[this.stepper % this.twister.length];
            if (this.barWidth < 1) {
                return;
            }
            if (this.barWidth <= 3) {
                TerminalProgressBarMonitor.this.directPrintln(clock);
                return;
            }
            TerminalProgressBarMonitor.this.directWrite(Ansi.ansi().a(done).bg(240).fgBright(Ansi.Color.WHITE).a(frontPart).reset().a(backPart).a(" " + clock).format(" %d:%02d:%02d.%03d ", this.duration.toHoursPart(), this.duration.toMinutesPart(), this.duration.toSecondsPart(), this.duration.toMillisPart()).a(System.lineSeparator()).toString());
        }

        public boolean equals(Object obj) {
            return obj instanceof ProgressBar && ((ProgressBar)obj).name.equals(this.name) && ((ProgressBar)obj).threadId == this.threadId;
        }

        public int hashCode() {
            return this.name.hashCode() + 31 * (int)this.threadId;
        }

        public void done() {
            this.current = Math.min(this.current, this.max);
            this.duration = Duration.between(this.startTime, Instant.now());
            this.message = "";
        }
    }

    private class UnfinishedLine {
        final long threadId;
        private int curCapacity = 512;
        private char[] buffer = new char[this.curCapacity];
        private int curEnd = 0;

        public UnfinishedLine() {
            this.threadId = Thread.currentThread().getId();
        }

        private void store(char[] newInput, int offset, int len) {
            if (len == 0) {
                return;
            }
            if (this.curEnd + len >= this.curCapacity) {
                do {
                    this.curCapacity *= 2;
                } while (this.curEnd + len >= this.curCapacity);
                this.buffer = Arrays.copyOf(this.buffer, this.curCapacity);
            }
            System.arraycopy(newInput, offset, this.buffer, this.curEnd, len);
            this.curEnd += len;
        }

        public void write(char[] n, int offset, int len) {
            if (len == 0) {
                return;
            }
            int lastNL = this.startOfLastLine(n, offset, len);
            if (lastNL == -1) {
                this.store(n, offset, len);
            } else {
                TerminalProgressBarMonitor.this.eraseBars();
                this.flush();
                TerminalProgressBarMonitor.this.directWrite(n, offset, lastNL + 1);
                TerminalProgressBarMonitor.this.directFlush();
                TerminalProgressBarMonitor.this.printBars();
                this.store(n, lastNL + 1, len - (lastNL + 1));
            }
        }

        public void write(String s2, int offset, int len) {
            this.write(s2.toCharArray(), offset, len);
        }

        private void flush() {
            if (this.curEnd != 0) {
                TerminalProgressBarMonitor.this.directWrite(this.buffer, 0, this.curEnd);
                this.curEnd = 0;
            }
        }

        public void flushLastLine() {
            if (this.curEnd != 0) {
                this.flush();
                TerminalProgressBarMonitor.this.directWrite(10);
            }
        }

        private int startOfLastLine(char[] buffer, int offset, int len) {
            for (int i = offset + len - 1; i >= offset; --i) {
                if (buffer[i] != '\n') continue;
                return i;
            }
            return -1;
        }
    }

    private static class AlwaysFlushAlwaysShowCursor
    extends PrintWriter {
        private final String showCursor;

        public AlwaysFlushAlwaysShowCursor(PrintWriter out, Terminal tm) {
            super(out);
            this.showCursor = TerminalProgressBarMonitor.interpretCapability(tm.getStringCapability(InfoCmp.Capability.cursor_visible));
        }

        @Override
        public void write(int c) {
            super.write(c);
            super.write(this.showCursor);
            super.flush();
        }

        @Override
        public void write(char[] cbuf, int off, int len) {
            super.write(cbuf, off, len);
            super.write(this.showCursor);
            super.flush();
        }

        @Override
        public void write(String str, int off, int len) {
            super.write(str, off, len);
            super.write(this.showCursor);
            super.flush();
        }
    }
}

