/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.semantics.dynamic;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import java.util.Set;
import org.rascalmpl.ast.DataTypeSelector;
import org.rascalmpl.ast.Name;
import org.rascalmpl.ast.QualifiedName;
import org.rascalmpl.interpreter.IEvaluator;
import org.rascalmpl.interpreter.env.Environment;
import org.rascalmpl.interpreter.env.GlobalEnvironment;
import org.rascalmpl.interpreter.env.ModuleEnvironment;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.staticErrors.AmbiguousFunctionReference;
import org.rascalmpl.interpreter.staticErrors.UndeclaredModule;
import org.rascalmpl.interpreter.staticErrors.UndeclaredType;
import org.rascalmpl.interpreter.utils.Names;

public abstract class DataTypeSelector
extends org.rascalmpl.ast.DataTypeSelector {
    public DataTypeSelector(ISourceLocation __param1, IConstructor tree) {
        super(__param1, tree);
    }

    public static class Selector
    extends DataTypeSelector.Selector {
        public Selector(ISourceLocation __param1, IConstructor tree, QualifiedName __param2, Name __param3) {
            super(__param1, tree, __param2, __param3);
        }

        @Override
        public Type typeOf(Environment env, IEvaluator<Result<IValue>> eval, boolean instantiateTypeParameters) {
            Type adt;
            QualifiedName sort = this.getSort();
            String name = Names.typeName(sort);
            if (Names.isQualified(sort)) {
                GlobalEnvironment heap = env.getHeap();
                ModuleEnvironment mod = heap.getModule(Names.moduleName(sort));
                if (mod == null) {
                    throw new UndeclaredModule(Names.moduleName(sort), sort);
                }
                adt = mod.lookupAbstractDataType(name);
            } else {
                adt = env.lookupAbstractDataType(name);
            }
            if (adt == null) {
                throw new UndeclaredType(name, this);
            }
            String constructor = Names.name(this.getProduction());
            Set<Type> constructors = env.lookupConstructor(adt, constructor);
            if (constructors.size() == 0) {
                throw new UndeclaredType(name + "." + constructor, this);
            }
            if (constructors.size() > 1) {
                throw new AmbiguousFunctionReference(name + "." + constructor, this);
            }
            return constructors.iterator().next();
        }
    }
}

