/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.semantics.dynamic;

import io.usethesource.vallang.IMapWriter;
import io.usethesource.vallang.IValue;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.Expression;
import org.rascalmpl.exceptions.ImplementationError;
import org.rascalmpl.interpreter.IEvaluator;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.semantics.dynamic.Comprehension;
import org.rascalmpl.semantics.dynamic.ComprehensionWriter;

public class MapComprehensionWriter
extends ComprehensionWriter {
    public MapComprehensionWriter(List<Expression> resultExprs, IEvaluator<Result<IValue>> eval) {
        super(resultExprs, eval);
        if (resultExprs.size() != 2) {
            throw new ImplementationError("Map comprehensions needs two result expressions");
        }
        this.writer = this.VF.mapWriter();
        this.elementType1 = this.TF.voidType();
        this.elementType2 = this.TF.voidType();
    }

    @Override
    public void append() {
        Result<IValue> r1 = ((Expression)this.resultExprs.get(0)).interpret(this.ev);
        Result<IValue> r2 = ((Expression)this.resultExprs.get(1)).interpret(this.ev);
        this.elementType1 = this.elementType1.lub(r1.getStaticType());
        this.elementType2 = this.elementType2.lub(r2.getStaticType());
        ((IMapWriter)this.writer).put(r1.getValue(), r2.getValue());
    }

    @Override
    public Result<IValue> done() {
        return this.writer == null ? Comprehension.makeResult(this.TF.mapType(this.TF.voidType(), this.TF.voidType()), this.VF.mapWriter().done(), this.getContext((AbstractAST)this.resultExprs.get(0))) : Comprehension.makeResult(this.TF.mapType(this.elementType1, this.elementType2), this.writer.done(), this.getContext((AbstractAST)this.resultExprs.get(0)));
    }
}

