/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.unicode;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.rascalmpl.unicode.ByteOrderMarker;

public class UnicodeDetector {
    private static final int maximumBOMLength = 4;
    private static final ByteOrderMarker[] boms = new ByteOrderMarker[]{ByteOrderMarker.UTF8, ByteOrderMarker.UTF32BE, ByteOrderMarker.UTF32LE, ByteOrderMarker.UTF16BE, ByteOrderMarker.UTF16LE};

    public static Charset detectByContent(byte[] buffer, int bufferSize) {
        boolean match = true;
        int i = 0;
        while (match && i + 3 < bufferSize) {
            int c0 = buffer[i] & 0xFF;
            if (1 <= c0 && c0 <= 127) {
                ++i;
                continue;
            }
            int c1 = buffer[i + 1] & 0xFF;
            if (192 <= c0 && c0 < 224 && (c1 & 0xC0) == 128) {
                i += 2;
                continue;
            }
            int c2 = buffer[i + 2] & 0xFF;
            if (224 <= c0 && c0 < 240 && (c1 & 0xC0) == 128 && (c2 & 0xC0) == 128) {
                if (c0 == 237 && 160 <= c1 && c1 <= 191 && 128 <= c2 && c2 <= 191) {
                    match = false;
                    break;
                }
                i += 3;
                continue;
            }
            int c3 = buffer[i + 3] & 0xFF;
            if (240 <= c0 && c0 < 248 && (c1 & 0xC0) == 128 && (c2 & 0xC0) == 128 && (c3 & 0xC0) == 128) {
                i += 4;
                continue;
            }
            match = false;
            break;
        }
        if (match) {
            return Charset.forName("UTF8");
        }
        match = true;
        i = 0;
        while (i + 1 < bufferSize && match) {
            match = (buffer[i] & 0xFF) == 0 && (buffer[i + 1] & 0xFF) == 16;
            i += 2;
        }
        if (match) {
            return Charset.forName("UTF-32BE");
        }
        match = true;
        i = 2;
        while (i + 1 < bufferSize && match) {
            match = (buffer[i] & 0xFF) == 16 && (buffer[i + 1] & 0xFF) == 0;
            i += 2;
        }
        if (match) {
            return Charset.forName("UTF-32LE");
        }
        return null;
    }

    public static ByteOrderMarker detectBom(byte[] detectionBuffer, int bufferSize) {
        for (ByteOrderMarker b : boms) {
            if (!b.matches(detectionBuffer, bufferSize)) continue;
            return b;
        }
        return null;
    }

    public static boolean isAmbigiousBOM(Charset a, Charset b) {
        boolean isUTF32LE = a.name().equals("UTF-32LE") || b.name().equals("UTF-32LE");
        boolean isUTF16LE = a.name().equals("UTF-16LE") || b.name().equals("UTF-16LE");
        boolean isUTF16 = a.name().equals("UTF-16") || b.name().equals("UTF-16");
        return isUTF32LE && (isUTF16 || isUTF16LE);
    }

    public static int getMaximumBOMLength() {
        return 4;
    }

    public static int getSuggestedDetectionSampleSize() {
        return 32;
    }

    public static Charset estimateCharset(InputStream in) throws IOException {
        int totalRead;
        byte[] buffer = new byte[UnicodeDetector.getSuggestedDetectionSampleSize()];
        ByteOrderMarker bom = UnicodeDetector.detectBom(buffer, totalRead = in.read(buffer));
        if (bom != null) {
            return bom.getCharset();
        }
        return UnicodeDetector.detectByContent(buffer, totalRead);
    }
}

