/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.values;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IMap;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.exceptions.ImplementationError;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.exceptions.Throw;
import org.rascalmpl.interpreter.IEvaluator;
import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.NullRascalMonitor;
import org.rascalmpl.interpreter.asserts.Ambiguous;
import org.rascalmpl.interpreter.control_exceptions.MatchFailed;
import org.rascalmpl.interpreter.env.Environment;
import org.rascalmpl.interpreter.result.AbstractFunction;
import org.rascalmpl.interpreter.result.ICallableValue;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.result.ResultFactory;
import org.rascalmpl.interpreter.staticErrors.UndeclaredNonTerminal;
import org.rascalmpl.library.lang.rascal.syntax.RascalParser;
import org.rascalmpl.library.util.ParseErrorRecovery;
import org.rascalmpl.parser.ParserGenerator;
import org.rascalmpl.parser.gtd.IGTD;
import org.rascalmpl.parser.gtd.debug.IDebugListener;
import org.rascalmpl.parser.gtd.exception.ParseError;
import org.rascalmpl.parser.gtd.exception.UndeclaredNonTerminalException;
import org.rascalmpl.parser.gtd.io.InputConverter;
import org.rascalmpl.parser.gtd.result.action.IActionExecutor;
import org.rascalmpl.parser.gtd.result.out.DefaultNodeFlattener;
import org.rascalmpl.parser.gtd.util.StackNodeIdDispenser;
import org.rascalmpl.parser.uptr.UPTRNodeFactory;
import org.rascalmpl.parser.uptr.action.NoActionExecutor;
import org.rascalmpl.parser.uptr.action.RascalFunctionActionExecutor;
import org.rascalmpl.parser.uptr.recovery.ToTokenRecoverer;
import org.rascalmpl.types.NonTerminalType;
import org.rascalmpl.types.RascalTypeFactory;
import org.rascalmpl.types.ReifiedType;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.values.RascalValueFactory;
import org.rascalmpl.values.ValueFactoryFactory;
import org.rascalmpl.values.functions.IFunction;
import org.rascalmpl.values.parsetrees.ITree;
import org.rascalmpl.values.parsetrees.SymbolAdapter;
import org.rascalmpl.values.parsetrees.SymbolFactory;
import org.rascalmpl.values.parsetrees.TreeAdapter;

public class RascalFunctionValueFactory
extends RascalValueFactory {
    private ParserGenerator generator;
    private final LoadingCache<IMap, Class<IGTD<IConstructor, ITree, ISourceLocation>>> parserCache = Caffeine.newBuilder().softValues().maximumSize(100L).expireAfterAccess(30L, TimeUnit.MINUTES).build(grammar -> this.generateParser((IMap)grammar));
    private final IEvaluatorContext ctx;

    public RascalFunctionValueFactory(IEvaluatorContext ctx) {
        this.ctx = ctx;
    }

    private ParserGenerator getParserGenerator() {
        if (this.generator == null) {
            this.generator = this.ctx.getEvaluator().getParserGenerator();
        }
        return this.generator;
    }

    private Class<IGTD<IConstructor, ITree, ISourceLocation>> generateParser(IMap grammar) {
        try {
            return this.getParserGenerator().getNewParser(this.ctx.getEvaluator().getMonitor(), URIUtil.rootLocation("parser-generator"), "$GENERATED_PARSER$" + Math.abs(grammar.hashCode()), grammar);
        }
        catch (ExceptionInInitializerError e) {
            throw new ImplementationError(e.getMessage(), e);
        }
    }

    protected Class<IGTD<IConstructor, ITree, ISourceLocation>> getParserClass(IMap grammar) {
        return this.parserCache.get(grammar);
    }

    protected void writeParserClass(IMap grammar, ISourceLocation target) throws IOException {
        this.getParserGenerator().writeNewParser(this.ctx.getEvaluator().getMonitor(), URIUtil.rootLocation("parser-generator"), "$GENERATED_PARSER$" + Math.abs(grammar.hashCode()), grammar, target);
    }

    @Override
    public IFunction function(Type functionType, BiFunction<IValue[], Map<String, IValue>, IValue> func) {
        return new RascalFunctionValue(functionType, func, this.ctx.getEvaluator());
    }

    @Override
    public IFunction parser(IValue reifiedGrammar, IBool allowAmbiguity, IInteger maxAmbDepth, IBool allowRecovery, IInteger maxRecoveryAttempts, IInteger maxRecoveryTokens, IBool hasSideEffects, IBool firstAmbiguity, ISet filters) {
        TypeFactory tf = TypeFactory.getInstance();
        Type functionType = !firstAmbiguity.getValue() ? tf.functionType(reifiedGrammar.getType().getTypeParameters().getFieldType(0), tf.tupleType(tf.valueType(), tf.sourceLocationType()), tf.tupleEmpty()) : tf.functionType(Tree, tf.tupleType(tf.valueType(), tf.sourceLocationType()), tf.tupleEmpty());
        Class<IGTD<IConstructor, ITree, ISourceLocation>> parser = this.getParserClass((IMap)((IConstructor)reifiedGrammar).get("definitions"));
        IConstructor startSort = (IConstructor)((IConstructor)reifiedGrammar).get("symbol");
        RascalFunctionValueFactory.checkPreconditions(startSort, reifiedGrammar.getType());
        AbstractAST current = this.ctx.getCurrentAST();
        ISourceLocation caller = current != null ? current.getLocation() : URIUtil.rootLocation("unknown");
        String name = RascalFunctionValueFactory.getParserMethodName(startSort);
        if (name == null) {
            name = this.generator.getParserMethodName(startSort);
        }
        return this.function(functionType, new ParseFunction(this.ctx.getValueFactory(), caller, parser, name, allowAmbiguity, maxAmbDepth, allowRecovery, maxRecoveryAttempts, maxRecoveryTokens, hasSideEffects, firstAmbiguity, filters));
    }

    protected static String getParserMethodName(IConstructor symbol) {
        switch (symbol.getName()) {
            case "start": {
                return "start__" + RascalFunctionValueFactory.getParserMethodName(SymbolAdapter.getStart(symbol));
            }
            case "layouts": {
                return "layouts_" + SymbolAdapter.getName(symbol);
            }
            case "sort": 
            case "lex": 
            case "keywords": {
                return SymbolAdapter.getName(symbol);
            }
        }
        return null;
    }

    @Override
    public IFunction parsers(IValue reifiedGrammar, IBool allowAmbiguity, IInteger maxAmbDepth, IBool allowRecovery, IInteger maxRecoveryAttempts, IInteger maxRecoveryTokens, IBool hasSideEffects, IBool firstAmbiguity, ISet filters) {
        RascalTypeFactory rtf = RascalTypeFactory.getInstance();
        TypeFactory tf = TypeFactory.getInstance();
        Type parameterType = tf.parameterType("U", RascalValueFactory.Tree);
        Type functionType = tf.functionType(parameterType, tf.tupleType(rtf.reifiedType(parameterType), tf.valueType(), tf.sourceLocationType()), tf.tupleEmpty());
        Class<IGTD<IConstructor, ITree, ISourceLocation>> parser = this.getParserClass((IMap)((IConstructor)reifiedGrammar).get("definitions"));
        IConstructor startSort = (IConstructor)((IConstructor)reifiedGrammar).get("symbol");
        RascalFunctionValueFactory.checkPreconditions(startSort, reifiedGrammar.getType());
        AbstractAST current = this.ctx.getCurrentAST();
        ISourceLocation caller = current != null ? current.getLocation() : URIUtil.rootLocation("unknown");
        return this.function(functionType, new ParametrizedParseFunction(() -> this.getParserGenerator(), this, caller, parser, allowAmbiguity, maxAmbDepth, allowRecovery, maxRecoveryAttempts, maxRecoveryTokens, hasSideEffects, firstAmbiguity, filters));
    }

    @Override
    public void storeParsers(IValue reifiedGrammar, ISourceLocation saveLocation) throws IOException {
        IMap grammar = (IMap)((IConstructor)reifiedGrammar).get("definitions");
        this.getParserGenerator().writeNewParser(new NullRascalMonitor(), URIUtil.rootLocation("parser-generator"), "$GENERATED_PARSER$" + Math.abs(grammar.hashCode()), grammar, saveLocation);
    }

    @Override
    public IFunction loadParsers(ISourceLocation saveLocation, IBool allowAmbiguity, IInteger maxAmbDepth, IBool allowRecovery, IInteger maxRecoveryAttempts, IInteger maxRecoveryTokens, IBool hasSideEffects, IBool firstAmbiguity, ISet filters) throws IOException, ClassNotFoundException {
        RascalTypeFactory rtf = RascalTypeFactory.getInstance();
        TypeFactory tf = TypeFactory.getInstance();
        Type parameterType = tf.parameterType("U", RascalValueFactory.Tree);
        Type functionType = tf.functionType(parameterType, tf.tupleType(rtf.reifiedType(parameterType), tf.valueType(), tf.sourceLocationType()), tf.tupleEmpty());
        try {
            Class<IGTD<IConstructor, ITree, ISourceLocation>> parser = this.ctx.getEvaluator().__getJavaBridge().loadClass(URIResolverRegistry.getInstance().getInputStream(saveLocation));
            AbstractAST current = this.ctx.getCurrentAST();
            ISourceLocation caller = current != null ? current.getLocation() : URIUtil.rootLocation("unknown");
            return this.function(functionType, new ParametrizedParseFunction(() -> this.getParserGenerator(), this, caller, parser, allowAmbiguity, maxAmbDepth, allowRecovery, maxRecoveryAttempts, maxRecoveryTokens, hasSideEffects, firstAmbiguity, filters));
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    @Override
    public IFunction loadParser(IValue reifiedGrammar, ISourceLocation saveLocation, IBool allowAmbiguity, IInteger maxAmbDepth, IBool allowRecovery, IInteger maxRecoveryAttempts, IInteger maxRecoveryTokens, IBool hasSideEffects, IBool firstAmbiguity, ISet filters) throws IOException, ClassNotFoundException {
        TypeFactory tf = TypeFactory.getInstance();
        Type functionType = tf.functionType(reifiedGrammar.getType().getTypeParameters().getFieldType(0), tf.tupleType(tf.valueType(), tf.sourceLocationType()), tf.tupleEmpty());
        try {
            Class<IGTD<IConstructor, ITree, ISourceLocation>> parser = this.ctx.getEvaluator().__getJavaBridge().loadClass(URIResolverRegistry.getInstance().getInputStream(saveLocation));
            AbstractAST current = this.ctx.getCurrentAST();
            ISourceLocation caller = current != null ? current.getLocation() : URIUtil.rootLocation("unknown");
            IConstructor startSort = (IConstructor)((IConstructor)reifiedGrammar).get("symbol");
            RascalFunctionValueFactory.checkPreconditions(startSort, reifiedGrammar.getType());
            String name = RascalFunctionValueFactory.getParserMethodName(startSort);
            if (name == null) {
                name = this.generator.getParserMethodName(startSort);
            }
            return this.function(functionType, new ParseFunction(this.ctx.getValueFactory(), caller, parser, name, allowAmbiguity, maxAmbDepth, allowRecovery, maxRecoveryAttempts, maxRecoveryTokens, hasSideEffects, firstAmbiguity, filters));
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    public IFunction bootstrapParsers() {
        RascalTypeFactory rtf = RascalTypeFactory.getInstance();
        TypeFactory tf = TypeFactory.getInstance();
        IValueFactory vf = this.ctx.getValueFactory();
        Type parameterType = tf.parameterType("U", RascalValueFactory.Tree);
        Type functionType = tf.functionType(parameterType, tf.tupleType(rtf.reifiedType(parameterType), tf.valueType(), tf.sourceLocationType()), tf.tupleEmpty());
        Class<RascalParser> parser = RascalParser.class;
        AbstractAST current = this.ctx.getCurrentAST();
        ISourceLocation caller = current != null ? current.getLocation() : URIUtil.rootLocation("unknown");
        return this.function(functionType, new ParametrizedParseFunction(() -> this.getParserGenerator(), this, caller, parser, vf.bool(false), vf.integer(Integer.MAX_VALUE), vf.bool(false), vf.integer(0), vf.integer(0), vf.bool(false), vf.bool(false), this.ctx.getValueFactory().set(new IValue[0])));
    }

    public IString createHole(ITree part, IInteger index) {
        ITree hole = TreeAdapter.getArg(part, "hole");
        ITree sym = TreeAdapter.getArg(hole, "symbol");
        IConstructor symbol = SymbolFactory.typeToSymbol(sym, false, null);
        IString result = this.ctx.getValueFactory().string("\u0000" + symbol.toString() + ":" + index + "\u0000");
        return result;
    }

    public IConstructor sym2symbol(ITree parsedSym) {
        if ("nonterminal".equals(TreeAdapter.getConstructorName(parsedSym))) {
            String nonterminalName = TreeAdapter.yield(parsedSym);
            return this.constructor(Symbol_Sort, this.string(nonterminalName));
        }
        return this.getParserGenerator().symbolTreeToSymbol(parsedSym);
    }

    private static IConstructor checkPreconditions(IValue start, Type reified) {
        if (!(reified instanceof ReifiedType)) {
            throw RuntimeExceptionFactory.illegalArgument(start, "A reified type is required instead of " + reified);
        }
        Type nt = reified.getTypeParameters().getFieldType(0);
        if (!(nt instanceof NonTerminalType)) {
            throw RuntimeExceptionFactory.illegalArgument(start, "A non-terminal type is required instead of  " + nt);
        }
        return (IConstructor)start;
    }

    private static class ParametrizedParseFunction
    extends ParseFunction {
        private Supplier<ParserGenerator> generator;

        public ParametrizedParseFunction(Supplier<ParserGenerator> generator, IValueFactory vf, ISourceLocation caller, Class<IGTD<IConstructor, ITree, ISourceLocation>> parser, IBool allowAmbiguity, IInteger maxAmbDepth, IBool allowRecovery, IInteger maxRecoveryAttempts, IInteger maxRecoveryTokens, IBool hasSideEffects, IBool firstAmbiguity, ISet filters) {
            super(vf, caller, parser, null, allowAmbiguity, maxAmbDepth, allowRecovery, maxRecoveryAttempts, maxRecoveryTokens, hasSideEffects, firstAmbiguity, filters);
            this.generator = generator;
        }

        @Override
        public IValue apply(IValue[] parameters, Map<String, IValue> keywordParameters) {
            if (parameters.length != 3) {
                throw this.fail(parameters);
            }
            IConstructor startSort = (IConstructor)((IConstructor)parameters[0]).get("symbol");
            if (!(parameters[0].getType() instanceof ReifiedType)) {
                throw this.fail(parameters);
            }
            String name = RascalFunctionValueFactory.getParserMethodName(startSort);
            if (name == null) {
                name = this.generator.get().getParserMethodName(startSort);
            }
            if (this.firstAmbiguity) {
                if (parameters[1].getType().isString()) {
                    return this.firstAmbiguity(name, (IString)parameters[1]);
                }
                if (parameters[1].getType().isSourceLocation()) {
                    return this.firstAmbiguity(name, (ISourceLocation)parameters[1]);
                }
            } else {
                if (!parameters[2].getType().isSourceLocation()) {
                    throw this.fail(parameters);
                }
                if (parameters[1].getType().isString()) {
                    return this.parse(name, this.filters, (IString)parameters[1], (ISourceLocation)parameters[2], this.allowAmbiguity, this.maxAmbDepth, this.allowRecovery, this.maxRecoveryAttempts, this.maxRecoveryTokens, this.hasSideEffects);
                }
                if (parameters[1].getType().isSourceLocation()) {
                    return this.parse(name, this.filters, (ISourceLocation)parameters[1], (ISourceLocation)parameters[2], this.allowAmbiguity, this.maxAmbDepth, this.allowRecovery, this.maxRecoveryAttempts, this.maxRecoveryTokens, this.hasSideEffects);
                }
            }
            throw this.fail(parameters);
        }
    }

    private static class ParseFunction
    implements BiFunction<IValue[], Map<String, IValue>, IValue> {
        protected final ISet filters;
        protected final IValueFactory vf;
        protected final boolean allowAmbiguity;
        protected final int maxAmbDepth;
        protected final boolean allowRecovery;
        protected final int maxRecoveryAttempts;
        protected final int maxRecoveryTokens;
        protected final boolean hasSideEffects;
        protected final boolean firstAmbiguity;
        protected final Class<IGTD<IConstructor, ITree, ISourceLocation>> parser;
        protected final String methodName;
        protected final ISourceLocation caller;

        public ParseFunction(IValueFactory vf, ISourceLocation caller, Class<IGTD<IConstructor, ITree, ISourceLocation>> parser, String methodName, IBool allowAmbiguity, IInteger maxAmbDepth, IBool allowRecovery, IInteger maxRecoveryAttempts, IInteger maxRecoveryTokens, IBool hasSideEffects, IBool firstAmbiguity, ISet filters) {
            this.vf = vf;
            this.caller = caller;
            this.parser = parser;
            this.methodName = methodName;
            this.filters = filters;
            this.allowAmbiguity = allowAmbiguity.getValue() || firstAmbiguity.getValue();
            this.maxAmbDepth = maxAmbDepth.intValue();
            this.allowRecovery = allowRecovery.getValue();
            this.maxRecoveryAttempts = maxRecoveryAttempts.intValue();
            this.maxRecoveryTokens = maxRecoveryTokens.intValue();
            this.hasSideEffects = hasSideEffects.getValue();
            this.firstAmbiguity = firstAmbiguity.getValue();
        }

        @Override
        public IValue apply(IValue[] parameters, Map<String, IValue> keywordParameters) {
            if (parameters.length != 2) {
                throw this.fail(parameters);
            }
            if (this.firstAmbiguity) {
                if (parameters[0].getType().isString()) {
                    return this.firstAmbiguity(this.methodName, (IString)parameters[0]);
                }
                if (parameters[0].getType().isSourceLocation()) {
                    return this.firstAmbiguity(this.methodName, (ISourceLocation)parameters[0]);
                }
            } else {
                if (!parameters[1].getType().isSourceLocation()) {
                    throw this.fail(parameters);
                }
                if (parameters[0].getType().isString()) {
                    return this.parse(this.methodName, this.filters, (IString)parameters[0], (ISourceLocation)parameters[1], this.allowAmbiguity, this.maxAmbDepth, this.allowRecovery, this.maxRecoveryAttempts, this.maxRecoveryTokens, this.hasSideEffects);
                }
                if (parameters[0].getType().isSourceLocation()) {
                    return this.parse(this.methodName, this.filters, (ISourceLocation)parameters[0], (ISourceLocation)parameters[1], this.allowAmbiguity, this.maxAmbDepth, this.allowRecovery, this.maxRecoveryAttempts, this.maxRecoveryTokens, this.hasSideEffects);
                }
            }
            throw this.fail(parameters);
        }

        protected Throw fail(IValue ... parameters) {
            return RuntimeExceptionFactory.callFailed(this.caller, Arrays.stream(parameters).collect(this.vf.listWriter()));
        }

        private IGTD<IConstructor, ITree, ISourceLocation> getParser() {
            try {
                return this.parser.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new ImplementationError("could not instantiate generated parser", e);
            }
        }

        protected IValue parse(String methodName, ISet filters, IString input, ISourceLocation origin, boolean allowAmbiguity, int maxAmbDepth, boolean allowRecovery, int maxRecoveryAttempts, int maxRecoveryTokens, boolean hasSideEffects) {
            try {
                if (origin == null) {
                    origin = URIUtil.rootLocation("unknown");
                }
                return this.parseObject(methodName, origin, input.getValue().toCharArray(), allowAmbiguity, maxAmbDepth, allowRecovery, maxRecoveryAttempts, maxRecoveryTokens, hasSideEffects, filters);
            }
            catch (ParseError pe) {
                ISourceLocation errorLoc = pe.getLocation();
                throw RuntimeExceptionFactory.parseError(errorLoc);
            }
            catch (Ambiguous e) {
                ITree tree = e.getTree();
                throw RuntimeExceptionFactory.ambiguity(e.getLocation(), this.printSymbol(TreeAdapter.getType(tree)), this.vf.string(TreeAdapter.yield(tree)));
            }
            catch (UndeclaredNonTerminalException e) {
                throw new UndeclaredNonTerminal(e.getName(), e.getClassName(), this.caller);
            }
        }

        protected IValue firstAmbiguity(String methodName, IString input) {
            try {
                return this.parseObject(methodName, URIUtil.invalidLocation(), input.getValue().toCharArray(), false, Integer.MAX_VALUE, false, 0, 0, false, this.vf.set(new IValue[0]));
            }
            catch (ParseError pe) {
                ISourceLocation errorLoc = pe.getLocation();
                throw RuntimeExceptionFactory.parseError(errorLoc);
            }
            catch (Ambiguous e) {
                return e.getTree();
            }
            catch (UndeclaredNonTerminalException e) {
                throw new UndeclaredNonTerminal(e.getName(), e.getClassName(), this.caller);
            }
        }

        protected IValue firstAmbiguity(String methodName, ISourceLocation input) {
            try {
                return this.parseObject(methodName, input, ParseFunction.readAll(input), false, Integer.MAX_VALUE, false, 0, 0, false, this.vf.set(new IValue[0]));
            }
            catch (ParseError pe) {
                ISourceLocation errorLoc = pe.getLocation();
                throw RuntimeExceptionFactory.parseError(errorLoc);
            }
            catch (IOException e) {
                throw RuntimeExceptionFactory.io(e);
            }
            catch (Ambiguous e) {
                return e.getTree();
            }
            catch (UndeclaredNonTerminalException e) {
                throw new UndeclaredNonTerminal(e.getName(), e.getClassName(), this.caller);
            }
        }

        private static char[] readAll(ISourceLocation loc) throws IOException {
            try (Reader chars = URIResolverRegistry.getInstance().getCharacterReader(loc);){
                char[] cArray = InputConverter.toChar(chars);
                return cArray;
            }
        }

        private IString printSymbol(IConstructor symbol) {
            return this.vf.string(SymbolAdapter.toString(symbol, false));
        }

        protected IValue parse(String methodName, ISet filters, ISourceLocation input, ISourceLocation origin, boolean allowAmbiguity, int maxAmbDepth, boolean allowRecovery, int maxRecoveryAttempts, int maxRecoveryTokens, boolean hasSideEffects) {
            if (origin != null && !origin.equals(input)) {
                throw new IllegalArgumentException("input and origin should be equal: <input> != <origin>");
            }
            try {
                return this.parseObject(methodName, input, ParseFunction.readAll(input), allowAmbiguity, maxAmbDepth, allowRecovery, maxRecoveryAttempts, maxRecoveryTokens, hasSideEffects, filters);
            }
            catch (ParseError pe) {
                ISourceLocation errorLoc = pe.getLocation();
                throw RuntimeExceptionFactory.parseError(errorLoc);
            }
            catch (IOException e) {
                throw RuntimeExceptionFactory.io("IO error: " + e);
            }
            catch (Ambiguous e) {
                ITree tree = e.getTree();
                throw RuntimeExceptionFactory.ambiguity(e.getLocation(), this.printSymbol(TreeAdapter.getType(tree)), this.vf.string(TreeAdapter.yield(tree)));
            }
            catch (UndeclaredNonTerminalException e) {
                throw new UndeclaredNonTerminal(e.getName(), e.getClassName(), this.caller);
            }
        }

        private ITree parseObject(String methodName, ISourceLocation location, char[] input, boolean allowAmbiguity, int maxAmbDepth, boolean allowRecovery, int maxRecoveryAttempts, int maxRecoveryTokens, boolean hasSideEffects, ISet filters) {
            IActionExecutor<ITree> exec = filters.isEmpty() ? new NoActionExecutor() : new RascalFunctionActionExecutor(filters, !hasSideEffects);
            IGTD<IConstructor, ITree, ISourceLocation> parserInstance = this.getParser();
            ToTokenRecoverer recoverer = null;
            IDebugListener debugListener = null;
            URI uri = location.getURI();
            if (allowRecovery) {
                recoverer = new ToTokenRecoverer(uri, parserInstance, new StackNodeIdDispenser(parserInstance), maxRecoveryAttempts, maxRecoveryTokens);
            }
            ITree parseForest = (ITree)parserInstance.parse(methodName, uri, input, maxAmbDepth, exec, new DefaultNodeFlattener(), new UPTRNodeFactory(allowRecovery || allowAmbiguity), recoverer, debugListener);
            if (!allowAmbiguity && allowRecovery) {
                RascalValueFactory valueFactory = (RascalValueFactory)ValueFactoryFactory.getValueFactory();
                new ParseErrorRecovery(valueFactory).checkForRegularAmbiguities(parseForest);
            }
            return parseForest;
        }
    }

    private static final class RascalFunctionValue
    extends AbstractFunction
    implements IFunction {
        private final BiFunction<IValue[], Map<String, IValue>, IValue> func;

        public RascalFunctionValue(Type functionType, BiFunction<IValue[], Map<String, IValue>, IValue> func, IEvaluator<Result<IValue>> eval) {
            super(eval.getCurrentAST(), eval, functionType, functionType, Collections.emptyList(), false, eval.getCurrentEnvt());
            this.func = func;
        }

        @Override
        public boolean isStatic() {
            return false;
        }

        @Override
        public ICallableValue cloneInto(Environment env) {
            return null;
        }

        @Override
        public boolean isDefault() {
            return false;
        }

        @Override
        public <T extends IValue> T call(Map<String, IValue> keywordParameters, IValue ... parameters) {
            return (T)this.func.apply(parameters, keywordParameters);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Result<IValue> call(Type[] argTypes, IValue[] argValues, Map<String, IValue> keyArgValues) {
            Environment old = this.ctx.getCurrentEnvt();
            try {
                this.ctx.pushEnv(this.getName());
                Environment env = this.ctx.getCurrentEnvt();
                if (argValues.length != this.getArity()) {
                    throw new MatchFailed();
                }
                HashMap<Type, Type> renamings = new HashMap<Type, Type>();
                HashMap<Type, Type> dynamicRenamings = new HashMap<Type, Type>();
                this.bindTypeParameters(TypeFactory.getInstance().tupleType(argTypes), argValues, this.staticFunctionType.getFieldTypes(), renamings, dynamicRenamings, env);
                IValue returnValue = this.func.apply(argValues, keyArgValues);
                Type resultType = this.getReturnType().instantiate(env.getStaticTypeBindings());
                resultType = RascalFunctionValue.unrenameType(renamings, resultType);
                if (!this.getReturnType().isBottom() && this.getReturnType().instantiate(env.getStaticTypeBindings()).isBottom()) {
                    throw RuntimeExceptionFactory.callFailed(this.ctx.getCurrentAST().getLocation(), Arrays.stream(argValues).collect(this.vf.listWriter()));
                }
                if (this.staticFunctionType.getReturnType().isBottom()) {
                    Result<IValue> result = ResultFactory.nothing();
                    return result;
                }
                if (returnValue == null) {
                    throw RuntimeExceptionFactory.callFailed(this.ctx.getCurrentAST().getLocation(), Arrays.stream(argValues).collect(this.vf.listWriter()));
                }
                Result<IValue> result = ResultFactory.makeResult(resultType, returnValue, this.ctx);
                return result;
            }
            finally {
                this.ctx.unwind(old);
            }
        }
    }
}

