---
title: "module analysis::linearprogramming::LLLinearProgramming"
id: LLLinearProgramming
slug: /Library/analysis/linearprogramming/LLLinearProgramming
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-Not specified</div>

Low level linear programming interface
#### Usage

```rascal
import analysis::linearprogramming::LLLinearProgramming;
```

#### Dependencies
```rascal
import List;
import util::Maybe;
```


## alias LLCoefficients {#analysis-linearprogramming-LLLinearProgramming-LLCoefficients}

```rascal
list[num]
```

## data LLObjectiveFun {#analysis-linearprogramming-LLLinearProgramming-LLObjectiveFun}

```rascal
data LLObjectiveFun  
     = llObjFun(LLCoefficients coefficients, num const)
     ;
```

## function llObjFun {#analysis-linearprogramming-LLLinearProgramming-llObjFun}

```rascal
LLObjectiveFun llObjFun(LLCoefficients coefficients)
```

## data ConstraintType {#analysis-linearprogramming-LLLinearProgramming-ConstraintType}

```rascal
data ConstraintType  
     = leq()
     | eq()
     | geq()
     ;
```

## data LLConstraint {#analysis-linearprogramming-LLLinearProgramming-LLConstraint}

```rascal
data LLConstraint  
     = llConstraint(LLCoefficients coefficients,
			   	ConstraintType ctype, num const)
     ;
```

## alias LLConstraints {#analysis-linearprogramming-LLLinearProgramming-LLConstraints}

```rascal
set[LLConstraint]
```

## alias LLVariableVals {#analysis-linearprogramming-LLLinearProgramming-LLVariableVals}

```rascal
list[num]
```

## data LLSolution {#analysis-linearprogramming-LLLinearProgramming-LLSolution}

```rascal
data LLSolution  
     = llSolution(LLVariableVals varVals, num funVal)
     ;
```

## function llRunObjFul {#analysis-linearprogramming-LLLinearProgramming-llRunObjFul}

```rascal
num llRunObjFul(LLObjectiveFun f, LLVariableVals vals)
```

## function padToSize {#analysis-linearprogramming-LLLinearProgramming-padToSize}

```rascal
list[num] padToSize(list[num] l, int s)
```

## function normalize {#analysis-linearprogramming-LLLinearProgramming-normalize}

```rascal
tuple[LLConstraints constraints, LLObjectiveFun f]
normalize(LLConstraints constraints, LLObjectiveFun f)
```

## function llOptimize {#analysis-linearprogramming-LLLinearProgramming-llOptimize}

```rascal
Maybe[LLSolution] 
llOptimize(bool minimize, bool nonZero, 
		   LLConstraints constraints, LLObjectiveFun f)
```

