---
title: "module lang::html5::DOM"
id: DOM
slug: /Library/lang/html5/DOM
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-Not specified</div>

DOM-based AST model for HTML5 including pretty printer
#### Usage

```rascal
import lang::html5::DOM;
```

#### Dependencies
```rascal
import List;
```


## data HTML5Node {#lang-html5-DOM-HTML5Node}
Generic representation for all HTML tag types.

```rascal
data HTML5Node  
     = html5node(str name, list[value] kids)
     ;
```


Every standard HTML5 node  type has a convenience function in 
this module with a name that is equal to the tag name, modulo renamings
for identifier compatibility in Rascal.

#### Examples



```rascal-shell 
rascal>import lang::html5::DOM;
ok
rascal>title("This is a title node")
HTML5Node: html5node(
  "title",
  ["This is a title node"])
```

## data HTML5Attr {#lang-html5-DOM-HTML5Attr}
Generic representation for all HTML attributes.

```rascal
data HTML5Attr  
     = html5attr(str name, value val)
     ;
```


Every standard HTML5 attribute has a convenience function in 
this module with a name that starts with an "a" for "attribute".
This is to prevent overlaps with node names that are the same.

#### Examples


```rascal-shell
import lang::html5::DOM;
aabbr("Short")

## function a {#lang-html5-DOM-a}

```rascal
HTML5Node a(value kids...)
```

## function abbr {#lang-html5-DOM-abbr}

```rascal
HTML5Node abbr(value kids...)
```

## function address {#lang-html5-DOM-address}

```rascal
HTML5Node address(value kids...)
```

## function area {#lang-html5-DOM-area}

```rascal
HTML5Node area(value kids...)
```

## function article {#lang-html5-DOM-article}

```rascal
HTML5Node article(value kids...)
```

## function aside {#lang-html5-DOM-aside}

```rascal
HTML5Node aside(value kids...)
```

## function audio {#lang-html5-DOM-audio}

```rascal
HTML5Node audio(value kids...)
```

## function b {#lang-html5-DOM-b}

```rascal
HTML5Node b(value kids...)
```

## function base {#lang-html5-DOM-base}

```rascal
HTML5Node base(value kids...)
```

## function bdi {#lang-html5-DOM-bdi}

```rascal
HTML5Node bdi(value kids...)
```

## function bdo {#lang-html5-DOM-bdo}

```rascal
HTML5Node bdo(value kids...)
```

## function blockquote {#lang-html5-DOM-blockquote}

```rascal
HTML5Node blockquote(value kids...)
```

## function body {#lang-html5-DOM-body}

```rascal
HTML5Node body(value kids...)
```

## function br {#lang-html5-DOM-br}

```rascal
HTML5Node br(value kids...)
```

## function button {#lang-html5-DOM-button}

```rascal
HTML5Node button(value kids...)
```

## function canvas {#lang-html5-DOM-canvas}

```rascal
HTML5Node canvas(value kids...)
```

## function caption {#lang-html5-DOM-caption}

```rascal
HTML5Node caption(value kids...)
```

## function cite {#lang-html5-DOM-cite}

```rascal
HTML5Node cite(value kids...)
```

## function code {#lang-html5-DOM-code}

```rascal
HTML5Node code(value kids...)
```

## function col {#lang-html5-DOM-col}

```rascal
HTML5Node col(value kids...)
```

## function colgroup {#lang-html5-DOM-colgroup}

```rascal
HTML5Node colgroup(value kids...)
```

## function \data {#lang-html5-DOM-\data}

```rascal
HTML5Node \data(value kids...)
```

## function datalist {#lang-html5-DOM-datalist}

```rascal
HTML5Node datalist(value kids...)
```

## function dd {#lang-html5-DOM-dd}

```rascal
HTML5Node dd(value kids...)
```

## function del {#lang-html5-DOM-del}

```rascal
HTML5Node del(value kids...)
```

## function details {#lang-html5-DOM-details}

```rascal
HTML5Node details(value kids...)
```

## function dfn {#lang-html5-DOM-dfn}

```rascal
HTML5Node dfn(value kids...)
```

## function dialog {#lang-html5-DOM-dialog}

```rascal
HTML5Node dialog(value kids...)
```

## function div {#lang-html5-DOM-div}

```rascal
HTML5Node div(value kids...)
```

## function dl {#lang-html5-DOM-dl}

```rascal
HTML5Node dl(value kids...)
```

## function dt {#lang-html5-DOM-dt}

```rascal
HTML5Node dt(value kids...)
```

## function em {#lang-html5-DOM-em}

```rascal
HTML5Node em(value kids...)
```

## function embed {#lang-html5-DOM-embed}

```rascal
HTML5Node embed(value kids...)
```

## function fieldset {#lang-html5-DOM-fieldset}

```rascal
HTML5Node fieldset(value kids...)
```

## function figcaption {#lang-html5-DOM-figcaption}

```rascal
HTML5Node figcaption(value kids...)
```

## function figure {#lang-html5-DOM-figure}

```rascal
HTML5Node figure(value kids...)
```

## function footer {#lang-html5-DOM-footer}

```rascal
HTML5Node footer(value kids...)
```

## function form {#lang-html5-DOM-form}

```rascal
HTML5Node form(value kids...)
```

## function h1 {#lang-html5-DOM-h1}

```rascal
HTML5Node h1(value kids...)
```

## function h2 {#lang-html5-DOM-h2}

```rascal
HTML5Node h2(value kids...)
```

## function h3 {#lang-html5-DOM-h3}

```rascal
HTML5Node h3(value kids...)
```

## function h4 {#lang-html5-DOM-h4}

```rascal
HTML5Node h4(value kids...)
```

## function h5 {#lang-html5-DOM-h5}

```rascal
HTML5Node h5(value kids...)
```

## function h6 {#lang-html5-DOM-h6}

```rascal
HTML5Node h6(value kids...)
```

## function head {#lang-html5-DOM-head}

```rascal
HTML5Node head(value kids...)
```

## function header {#lang-html5-DOM-header}

```rascal
HTML5Node header(value kids...)
```

## function hgroup {#lang-html5-DOM-hgroup}

```rascal
HTML5Node hgroup(value kids...)
```

## function hr {#lang-html5-DOM-hr}

```rascal
HTML5Node hr(value kids...)
```

## function html {#lang-html5-DOM-html}

```rascal
HTML5Node html(value kids...)
```

## function i {#lang-html5-DOM-i}

```rascal
HTML5Node i(value kids...)
```

## function iframe {#lang-html5-DOM-iframe}

```rascal
HTML5Node iframe(value kids...)
```

## function img {#lang-html5-DOM-img}

```rascal
HTML5Node img(value kids...)
```

## function input {#lang-html5-DOM-input}

```rascal
HTML5Node input(value kids...)
```

## function ins {#lang-html5-DOM-ins}

```rascal
HTML5Node ins(value kids...)
```

## function kbd {#lang-html5-DOM-kbd}

```rascal
HTML5Node kbd(value kids...)
```

## function keygen {#lang-html5-DOM-keygen}

```rascal
HTML5Node keygen(value kids...)
```

## function label {#lang-html5-DOM-label}

```rascal
HTML5Node label(value kids...)
```

## function legend {#lang-html5-DOM-legend}

```rascal
HTML5Node legend(value kids...)
```

## function li {#lang-html5-DOM-li}

```rascal
HTML5Node li(value kids...)
```

## function link {#lang-html5-DOM-link}

```rascal
HTML5Node link(value kids...)
```

## function main {#lang-html5-DOM-main}

```rascal
HTML5Node main(value kids...)
```

## function \map {#lang-html5-DOM-\map}

```rascal
HTML5Node \map(value kids...)
```

## function mark {#lang-html5-DOM-mark}

```rascal
HTML5Node mark(value kids...)
```

## function menu {#lang-html5-DOM-menu}

```rascal
HTML5Node menu(value kids...)
```

## function menuitem {#lang-html5-DOM-menuitem}

```rascal
HTML5Node menuitem(value kids...)
```

## function meta {#lang-html5-DOM-meta}

```rascal
HTML5Node meta(value kids...)
```

## function meter {#lang-html5-DOM-meter}

```rascal
HTML5Node meter(value kids...)
```

## function nav {#lang-html5-DOM-nav}

```rascal
HTML5Node nav(value kids...)
```

## function noscript {#lang-html5-DOM-noscript}

```rascal
HTML5Node noscript(value kids...)
```

## function object {#lang-html5-DOM-object}

```rascal
HTML5Node object(value kids...)
```

## function ol {#lang-html5-DOM-ol}

```rascal
HTML5Node ol(value kids...)
```

## function optgroup {#lang-html5-DOM-optgroup}

```rascal
HTML5Node optgroup(value kids...)
```

## function option {#lang-html5-DOM-option}

```rascal
HTML5Node option(value kids...)
```

## function output {#lang-html5-DOM-output}

```rascal
HTML5Node output(value kids...)
```

## function p {#lang-html5-DOM-p}

```rascal
HTML5Node p(value kids...)
```

## function param {#lang-html5-DOM-param}

```rascal
HTML5Node param(value kids...)
```

## function pre {#lang-html5-DOM-pre}

```rascal
HTML5Node pre(value kids...)
```

## function progress {#lang-html5-DOM-progress}

```rascal
HTML5Node progress(value kids...)
```

## function q {#lang-html5-DOM-q}

```rascal
HTML5Node q(value kids...)
```

## function rp {#lang-html5-DOM-rp}

```rascal
HTML5Node rp(value kids...)
```

## function rt {#lang-html5-DOM-rt}

```rascal
HTML5Node rt(value kids...)
```

## function ruby {#lang-html5-DOM-ruby}

```rascal
HTML5Node ruby(value kids...)
```

## function s {#lang-html5-DOM-s}

```rascal
HTML5Node s(value kids...)
```

## function samp {#lang-html5-DOM-samp}

```rascal
HTML5Node samp(value kids...)
```

## function script {#lang-html5-DOM-script}

```rascal
HTML5Node script(value kids...)
```

## function section {#lang-html5-DOM-section}

```rascal
HTML5Node section(value kids...)
```

## function select {#lang-html5-DOM-select}

```rascal
HTML5Node select(value kids...)
```

## function small {#lang-html5-DOM-small}

```rascal
HTML5Node small(value kids...)
```

## function source {#lang-html5-DOM-source}

```rascal
HTML5Node source(value kids...)
```

## function span {#lang-html5-DOM-span}

```rascal
HTML5Node span(value kids...)
```

## function strong {#lang-html5-DOM-strong}

```rascal
HTML5Node strong(value kids...)
```

## function style {#lang-html5-DOM-style}

```rascal
HTML5Node style(value kids...)
```

## function sub {#lang-html5-DOM-sub}

```rascal
HTML5Node sub(value kids...)
```

## function summary {#lang-html5-DOM-summary}

```rascal
HTML5Node summary(value kids...)
```

## function sup {#lang-html5-DOM-sup}

```rascal
HTML5Node sup(value kids...)
```

## function table {#lang-html5-DOM-table}

```rascal
HTML5Node table(value kids...)
```

## function tbody {#lang-html5-DOM-tbody}

```rascal
HTML5Node tbody(value kids...)
```

## function td {#lang-html5-DOM-td}

```rascal
HTML5Node td(value kids...)
```

## function template {#lang-html5-DOM-template}

```rascal
HTML5Node template(value kids...)
```

## function textarea {#lang-html5-DOM-textarea}

```rascal
HTML5Node textarea(value kids...)
```

## function tfoot {#lang-html5-DOM-tfoot}

```rascal
HTML5Node tfoot(value kids...)
```

## function th {#lang-html5-DOM-th}

```rascal
HTML5Node th(value kids...)
```

## function thead {#lang-html5-DOM-thead}

```rascal
HTML5Node thead(value kids...)
```

## function time {#lang-html5-DOM-time}

```rascal
HTML5Node time(value kids...)
```

## function title {#lang-html5-DOM-title}

```rascal
HTML5Node title(value kids...)
```

## function tr {#lang-html5-DOM-tr}

```rascal
HTML5Node tr(value kids...)
```

## function track {#lang-html5-DOM-track}

```rascal
HTML5Node track(value kids...)
```

## function u {#lang-html5-DOM-u}

```rascal
HTML5Node u(value kids...)
```

## function ul {#lang-html5-DOM-ul}

```rascal
HTML5Node ul(value kids...)
```

## function var {#lang-html5-DOM-var}

```rascal
HTML5Node var(value kids...)
```

## function video {#lang-html5-DOM-video}

```rascal
HTML5Node video(value kids...)
```

## function wbr {#lang-html5-DOM-wbr}

```rascal
HTML5Node wbr(value kids...)
```

## function aaaliasbbr {#lang-html5-DOM-aaaliasbbr}

```rascal
HTML5Attr aaaliasbbr(value val)
```

## function aabout {#lang-html5-DOM-aabout}

```rascal
HTML5Attr aabout(value val)
```

## function aaccept {#lang-html5-DOM-aaccept}

```rascal
HTML5Attr aaccept(value val)
```

## function aaccesskey {#lang-html5-DOM-aaccesskey}

```rascal
HTML5Attr aaccesskey(value val)
```

## function aaction {#lang-html5-DOM-aaction}

```rascal
HTML5Attr aaction(value val)
```

## function aalign {#lang-html5-DOM-aalign}

```rascal
HTML5Attr aalign(value val)
```

## function aallowfullscreen {#lang-html5-DOM-aallowfullscreen}

```rascal
HTML5Attr aallowfullscreen(value val)
```

## function aalt {#lang-html5-DOM-aalt}

```rascal
HTML5Attr aalt(value val)
```

## function aaria {#lang-html5-DOM-aaria}

```rascal
HTML5Attr aaria(value val)
```

## function aasync {#lang-html5-DOM-aasync}

```rascal
HTML5Attr aasync(value val)
```

## function aautocomplete {#lang-html5-DOM-aautocomplete}

```rascal
HTML5Attr aautocomplete(value val)
```

## function aautofocus {#lang-html5-DOM-aautofocus}

```rascal
HTML5Attr aautofocus(value val)
```

## function aautoplay {#lang-html5-DOM-aautoplay}

```rascal
HTML5Attr aautoplay(value val)
```

## function aborder {#lang-html5-DOM-aborder}

```rascal
HTML5Attr aborder(value val)
```

## function achallenge {#lang-html5-DOM-achallenge}

```rascal
HTML5Attr achallenge(value val)
```

## function achar {#lang-html5-DOM-achar}

```rascal
HTML5Attr achar(value val)
```

## function acharset {#lang-html5-DOM-acharset}

```rascal
HTML5Attr acharset(value val)
```

## function achecked {#lang-html5-DOM-achecked}

```rascal
HTML5Attr achecked(value val)
```

## function aacite {#lang-html5-DOM-aacite}

```rascal
HTML5Attr aacite(value val)
```

## function aclass {#lang-html5-DOM-aclass}

```rascal
HTML5Attr aclass(value val)
```

## function acols {#lang-html5-DOM-acols}

```rascal
HTML5Attr acols(value val)
```

## function acolspan {#lang-html5-DOM-acolspan}

```rascal
HTML5Attr acolspan(value val)
```

## function acommand {#lang-html5-DOM-acommand}

```rascal
HTML5Attr acommand(value val)
```

## function acontent {#lang-html5-DOM-acontent}

```rascal
HTML5Attr acontent(value val)
```

## function acontenteditable {#lang-html5-DOM-acontenteditable}

```rascal
HTML5Attr acontenteditable(value val)
```

## function acontextmenu {#lang-html5-DOM-acontextmenu}

```rascal
HTML5Attr acontextmenu(value val)
```

## function acontrols {#lang-html5-DOM-acontrols}

```rascal
HTML5Attr acontrols(value val)
```

## function acoords {#lang-html5-DOM-acoords}

```rascal
HTML5Attr acoords(value val)
```

## function adata {#lang-html5-DOM-adata}

```rascal
HTML5Attr adata(value val)
```

## function adatatype {#lang-html5-DOM-adatatype}

```rascal
HTML5Attr adatatype(value val)
```

## function adatetime {#lang-html5-DOM-adatetime}

```rascal
HTML5Attr adatetime(value val)
```

## function adefault {#lang-html5-DOM-adefault}

```rascal
HTML5Attr adefault(value val)
```

## function adefer {#lang-html5-DOM-adefer}

```rascal
HTML5Attr adefer(value val)
```

## function adir {#lang-html5-DOM-adir}

```rascal
HTML5Attr adir(value val)
```

## function adirname {#lang-html5-DOM-adirname}

```rascal
HTML5Attr adirname(value val)
```

## function adisabled {#lang-html5-DOM-adisabled}

```rascal
HTML5Attr adisabled(value val)
```

## function adownload {#lang-html5-DOM-adownload}

```rascal
HTML5Attr adownload(value val)
```

## function adraggable {#lang-html5-DOM-adraggable}

```rascal
HTML5Attr adraggable(value val)
```

## function adropzone {#lang-html5-DOM-adropzone}

```rascal
HTML5Attr adropzone(value val)
```

## function aenctype {#lang-html5-DOM-aenctype}

```rascal
HTML5Attr aenctype(value val)
```

## function afor {#lang-html5-DOM-afor}

```rascal
HTML5Attr afor(value val)
```

## function aform {#lang-html5-DOM-aform}

```rascal
HTML5Attr aform(value val)
```

## function aformaction {#lang-html5-DOM-aformaction}

```rascal
HTML5Attr aformaction(value val)
```

## function aformenctype {#lang-html5-DOM-aformenctype}

```rascal
HTML5Attr aformenctype(value val)
```

## function aformmethod {#lang-html5-DOM-aformmethod}

```rascal
HTML5Attr aformmethod(value val)
```

## function aformnovalidate {#lang-html5-DOM-aformnovalidate}

```rascal
HTML5Attr aformnovalidate(value val)
```

## function aformtarget {#lang-html5-DOM-aformtarget}

```rascal
HTML5Attr aformtarget(value val)
```

## function aheaders {#lang-html5-DOM-aheaders}

```rascal
HTML5Attr aheaders(value val)
```

## function aheight {#lang-html5-DOM-aheight}

```rascal
HTML5Attr aheight(value val)
```

## function ahidden {#lang-html5-DOM-ahidden}

```rascal
HTML5Attr ahidden(value val)
```

## function ahigh {#lang-html5-DOM-ahigh}

```rascal
HTML5Attr ahigh(value val)
```

## function ahref {#lang-html5-DOM-ahref}

```rascal
HTML5Attr ahref(value val)
```

## function ahreflang {#lang-html5-DOM-ahreflang}

```rascal
HTML5Attr ahreflang(value val)
```

## function ahttp {#lang-html5-DOM-ahttp}

```rascal
HTML5Attr ahttp(value val)
```

## function aicon {#lang-html5-DOM-aicon}

```rascal
HTML5Attr aicon(value val)
```

## function aid {#lang-html5-DOM-aid}

```rascal
HTML5Attr aid(value val)
```

## function ainlist {#lang-html5-DOM-ainlist}

```rascal
HTML5Attr ainlist(value val)
```

## function aismap {#lang-html5-DOM-aismap}

```rascal
HTML5Attr aismap(value val)
```

## function aitemid {#lang-html5-DOM-aitemid}

```rascal
HTML5Attr aitemid(value val)
```

## function aitemprop {#lang-html5-DOM-aitemprop}

```rascal
HTML5Attr aitemprop(value val)
```

## function aitemref {#lang-html5-DOM-aitemref}

```rascal
HTML5Attr aitemref(value val)
```

## function aitemscope {#lang-html5-DOM-aitemscope}

```rascal
HTML5Attr aitemscope(value val)
```

## function aitemtype {#lang-html5-DOM-aitemtype}

```rascal
HTML5Attr aitemtype(value val)
```

## function akeytype {#lang-html5-DOM-akeytype}

```rascal
HTML5Attr akeytype(value val)
```

## function akind {#lang-html5-DOM-akind}

```rascal
HTML5Attr akind(value val)
```

## function alabel {#lang-html5-DOM-alabel}

```rascal
HTML5Attr alabel(value val)
```

## function alang {#lang-html5-DOM-alang}

```rascal
HTML5Attr alang(value val)
```

## function alanguage {#lang-html5-DOM-alanguage}

```rascal
HTML5Attr alanguage(value val)
```

## function alist {#lang-html5-DOM-alist}

```rascal
HTML5Attr alist(value val)
```

## function alocal_ {#lang-html5-DOM-alocal_}

```rascal
HTML5Attr alocal_(value val)
```

## function aloop {#lang-html5-DOM-aloop}

```rascal
HTML5Attr aloop(value val)
```

## function alow {#lang-html5-DOM-alow}

```rascal
HTML5Attr alow(value val)
```

## function amanifest {#lang-html5-DOM-amanifest}

```rascal
HTML5Attr amanifest(value val)
```

## function amax {#lang-html5-DOM-amax}

```rascal
HTML5Attr amax(value val)
```

## function amaxlength {#lang-html5-DOM-amaxlength}

```rascal
HTML5Attr amaxlength(value val)
```

## function amedia {#lang-html5-DOM-amedia}

```rascal
HTML5Attr amedia(value val)
```

## function amediagroup {#lang-html5-DOM-amediagroup}

```rascal
HTML5Attr amediagroup(value val)
```

## function amethod {#lang-html5-DOM-amethod}

```rascal
HTML5Attr amethod(value val)
```

## function amin {#lang-html5-DOM-amin}

```rascal
HTML5Attr amin(value val)
```

## function amultiple {#lang-html5-DOM-amultiple}

```rascal
HTML5Attr amultiple(value val)
```

## function amuted {#lang-html5-DOM-amuted}

```rascal
HTML5Attr amuted(value val)
```

## function aname {#lang-html5-DOM-aname}

```rascal
HTML5Attr aname(value val)
```

## function anovalidate {#lang-html5-DOM-anovalidate}

```rascal
HTML5Attr anovalidate(value val)
```

## function aonabort {#lang-html5-DOM-aonabort}

```rascal
HTML5Attr aonabort(value val)
```

## function aonafterprint {#lang-html5-DOM-aonafterprint}

```rascal
HTML5Attr aonafterprint(value val)
```

## function aonbeforeprint {#lang-html5-DOM-aonbeforeprint}

```rascal
HTML5Attr aonbeforeprint(value val)
```

## function aonbeforeunload {#lang-html5-DOM-aonbeforeunload}

```rascal
HTML5Attr aonbeforeunload(value val)
```

## function aonblur {#lang-html5-DOM-aonblur}

```rascal
HTML5Attr aonblur(value val)
```

## function aoncanplay {#lang-html5-DOM-aoncanplay}

```rascal
HTML5Attr aoncanplay(value val)
```

## function aoncanplaythrough {#lang-html5-DOM-aoncanplaythrough}

```rascal
HTML5Attr aoncanplaythrough(value val)
```

## function aonchange {#lang-html5-DOM-aonchange}

```rascal
HTML5Attr aonchange(value val)
```

## function aonclick {#lang-html5-DOM-aonclick}

```rascal
HTML5Attr aonclick(value val)
```

## function aoncontextmenu {#lang-html5-DOM-aoncontextmenu}

```rascal
HTML5Attr aoncontextmenu(value val)
```

## function aondblclick {#lang-html5-DOM-aondblclick}

```rascal
HTML5Attr aondblclick(value val)
```

## function aondrag {#lang-html5-DOM-aondrag}

```rascal
HTML5Attr aondrag(value val)
```

## function aondragend {#lang-html5-DOM-aondragend}

```rascal
HTML5Attr aondragend(value val)
```

## function aondragenter {#lang-html5-DOM-aondragenter}

```rascal
HTML5Attr aondragenter(value val)
```

## function aondragleave {#lang-html5-DOM-aondragleave}

```rascal
HTML5Attr aondragleave(value val)
```

## function aondragover {#lang-html5-DOM-aondragover}

```rascal
HTML5Attr aondragover(value val)
```

## function aondragstart {#lang-html5-DOM-aondragstart}

```rascal
HTML5Attr aondragstart(value val)
```

## function aondrop {#lang-html5-DOM-aondrop}

```rascal
HTML5Attr aondrop(value val)
```

## function aondurationchange {#lang-html5-DOM-aondurationchange}

```rascal
HTML5Attr aondurationchange(value val)
```

## function aonemptied {#lang-html5-DOM-aonemptied}

```rascal
HTML5Attr aonemptied(value val)
```

## function aonended {#lang-html5-DOM-aonended}

```rascal
HTML5Attr aonended(value val)
```

## function aonerror {#lang-html5-DOM-aonerror}

```rascal
HTML5Attr aonerror(value val)
```

## function aonfocus {#lang-html5-DOM-aonfocus}

```rascal
HTML5Attr aonfocus(value val)
```

## function aonformchange {#lang-html5-DOM-aonformchange}

```rascal
HTML5Attr aonformchange(value val)
```

## function aonforminput {#lang-html5-DOM-aonforminput}

```rascal
HTML5Attr aonforminput(value val)
```

## function aonhashchange {#lang-html5-DOM-aonhashchange}

```rascal
HTML5Attr aonhashchange(value val)
```

## function aoninput {#lang-html5-DOM-aoninput}

```rascal
HTML5Attr aoninput(value val)
```

## function aoninvalid {#lang-html5-DOM-aoninvalid}

```rascal
HTML5Attr aoninvalid(value val)
```

## function aonkeydown {#lang-html5-DOM-aonkeydown}

```rascal
HTML5Attr aonkeydown(value val)
```

## function aonkeypress {#lang-html5-DOM-aonkeypress}

```rascal
HTML5Attr aonkeypress(value val)
```

## function aonkeyup {#lang-html5-DOM-aonkeyup}

```rascal
HTML5Attr aonkeyup(value val)
```

## function aonload {#lang-html5-DOM-aonload}

```rascal
HTML5Attr aonload(value val)
```

## function aonloadeddata {#lang-html5-DOM-aonloadeddata}

```rascal
HTML5Attr aonloadeddata(value val)
```

## function aonloadedmetadata {#lang-html5-DOM-aonloadedmetadata}

```rascal
HTML5Attr aonloadedmetadata(value val)
```

## function aonloadstart {#lang-html5-DOM-aonloadstart}

```rascal
HTML5Attr aonloadstart(value val)
```

## function aonmessage {#lang-html5-DOM-aonmessage}

```rascal
HTML5Attr aonmessage(value val)
```

## function aonmousedown {#lang-html5-DOM-aonmousedown}

```rascal
HTML5Attr aonmousedown(value val)
```

## function aonmousemove {#lang-html5-DOM-aonmousemove}

```rascal
HTML5Attr aonmousemove(value val)
```

## function aonmouseout {#lang-html5-DOM-aonmouseout}

```rascal
HTML5Attr aonmouseout(value val)
```

## function aonmouseover {#lang-html5-DOM-aonmouseover}

```rascal
HTML5Attr aonmouseover(value val)
```

## function aonmouseup {#lang-html5-DOM-aonmouseup}

```rascal
HTML5Attr aonmouseup(value val)
```

## function aonmousewheel {#lang-html5-DOM-aonmousewheel}

```rascal
HTML5Attr aonmousewheel(value val)
```

## function aonoffline {#lang-html5-DOM-aonoffline}

```rascal
HTML5Attr aonoffline(value val)
```

## function aononline {#lang-html5-DOM-aononline}

```rascal
HTML5Attr aononline(value val)
```

## function aonpagehide {#lang-html5-DOM-aonpagehide}

```rascal
HTML5Attr aonpagehide(value val)
```

## function aonpageshow {#lang-html5-DOM-aonpageshow}

```rascal
HTML5Attr aonpageshow(value val)
```

## function aonpause {#lang-html5-DOM-aonpause}

```rascal
HTML5Attr aonpause(value val)
```

## function aonplay {#lang-html5-DOM-aonplay}

```rascal
HTML5Attr aonplay(value val)
```

## function aonplaying {#lang-html5-DOM-aonplaying}

```rascal
HTML5Attr aonplaying(value val)
```

## function aonpopstate {#lang-html5-DOM-aonpopstate}

```rascal
HTML5Attr aonpopstate(value val)
```

## function aonprogress {#lang-html5-DOM-aonprogress}

```rascal
HTML5Attr aonprogress(value val)
```

## function aonratechange {#lang-html5-DOM-aonratechange}

```rascal
HTML5Attr aonratechange(value val)
```

## function aonredo {#lang-html5-DOM-aonredo}

```rascal
HTML5Attr aonredo(value val)
```

## function aonreset {#lang-html5-DOM-aonreset}

```rascal
HTML5Attr aonreset(value val)
```

## function aonresize {#lang-html5-DOM-aonresize}

```rascal
HTML5Attr aonresize(value val)
```

## function aonscroll {#lang-html5-DOM-aonscroll}

```rascal
HTML5Attr aonscroll(value val)
```

## function aonseeked {#lang-html5-DOM-aonseeked}

```rascal
HTML5Attr aonseeked(value val)
```

## function aonseeking {#lang-html5-DOM-aonseeking}

```rascal
HTML5Attr aonseeking(value val)
```

## function aonselect {#lang-html5-DOM-aonselect}

```rascal
HTML5Attr aonselect(value val)
```

## function aonshow {#lang-html5-DOM-aonshow}

```rascal
HTML5Attr aonshow(value val)
```

## function aonstalled {#lang-html5-DOM-aonstalled}

```rascal
HTML5Attr aonstalled(value val)
```

## function aonstorage {#lang-html5-DOM-aonstorage}

```rascal
HTML5Attr aonstorage(value val)
```

## function aonsubmit {#lang-html5-DOM-aonsubmit}

```rascal
HTML5Attr aonsubmit(value val)
```

## function aonsuspend {#lang-html5-DOM-aonsuspend}

```rascal
HTML5Attr aonsuspend(value val)
```

## function aontimeupdate {#lang-html5-DOM-aontimeupdate}

```rascal
HTML5Attr aontimeupdate(value val)
```

## function aonundo {#lang-html5-DOM-aonundo}

```rascal
HTML5Attr aonundo(value val)
```

## function aonunload {#lang-html5-DOM-aonunload}

```rascal
HTML5Attr aonunload(value val)
```

## function aonvolumechange {#lang-html5-DOM-aonvolumechange}

```rascal
HTML5Attr aonvolumechange(value val)
```

## function aonwaiting {#lang-html5-DOM-aonwaiting}

```rascal
HTML5Attr aonwaiting(value val)
```

## function aopen {#lang-html5-DOM-aopen}

```rascal
HTML5Attr aopen(value val)
```

## function aoptimum {#lang-html5-DOM-aoptimum}

```rascal
HTML5Attr aoptimum(value val)
```

## function apattern {#lang-html5-DOM-apattern}

```rascal
HTML5Attr apattern(value val)
```

## function aping {#lang-html5-DOM-aping}

```rascal
HTML5Attr aping(value val)
```

## function aplaceholder {#lang-html5-DOM-aplaceholder}

```rascal
HTML5Attr aplaceholder(value val)
```

## function aposter {#lang-html5-DOM-aposter}

```rascal
HTML5Attr aposter(value val)
```

## function aprefix {#lang-html5-DOM-aprefix}

```rascal
HTML5Attr aprefix(value val)
```

## function apreload {#lang-html5-DOM-apreload}

```rascal
HTML5Attr apreload(value val)
```

## function aproperty {#lang-html5-DOM-aproperty}

```rascal
HTML5Attr aproperty(value val)
```

## function aradiogroup {#lang-html5-DOM-aradiogroup}

```rascal
HTML5Attr aradiogroup(value val)
```

## function areadonly {#lang-html5-DOM-areadonly}

```rascal
HTML5Attr areadonly(value val)
```

## function arel {#lang-html5-DOM-arel}

```rascal
HTML5Attr arel(value val)
```

## function arequired {#lang-html5-DOM-arequired}

```rascal
HTML5Attr arequired(value val)
```

## function aresource {#lang-html5-DOM-aresource}

```rascal
HTML5Attr aresource(value val)
```

## function arev {#lang-html5-DOM-arev}

```rascal
HTML5Attr arev(value val)
```

## function areversed {#lang-html5-DOM-areversed}

```rascal
HTML5Attr areversed(value val)
```

## function arole {#lang-html5-DOM-arole}

```rascal
HTML5Attr arole(value val)
```

## function arows {#lang-html5-DOM-arows}

```rascal
HTML5Attr arows(value val)
```

## function arowspan {#lang-html5-DOM-arowspan}

```rascal
HTML5Attr arowspan(value val)
```

## function asandbox {#lang-html5-DOM-asandbox}

```rascal
HTML5Attr asandbox(value val)
```

## function ascope {#lang-html5-DOM-ascope}

```rascal
HTML5Attr ascope(value val)
```

## function ascoped {#lang-html5-DOM-ascoped}

```rascal
HTML5Attr ascoped(value val)
```

## function aseamless {#lang-html5-DOM-aseamless}

```rascal
HTML5Attr aseamless(value val)
```

## function aselected {#lang-html5-DOM-aselected}

```rascal
HTML5Attr aselected(value val)
```

## function ashape {#lang-html5-DOM-ashape}

```rascal
HTML5Attr ashape(value val)
```

## function asize {#lang-html5-DOM-asize}

```rascal
HTML5Attr asize(value val)
```

## function asizes {#lang-html5-DOM-asizes}

```rascal
HTML5Attr asizes(value val)
```

## function aspan {#lang-html5-DOM-aspan}

```rascal
HTML5Attr aspan(value val)
```

## function aspellcheck {#lang-html5-DOM-aspellcheck}

```rascal
HTML5Attr aspellcheck(value val)
```

## function asrc {#lang-html5-DOM-asrc}

```rascal
HTML5Attr asrc(value val)
```

## function asrcdoc {#lang-html5-DOM-asrcdoc}

```rascal
HTML5Attr asrcdoc(value val)
```

## function asrclang {#lang-html5-DOM-asrclang}

```rascal
HTML5Attr asrclang(value val)
```

## function astart {#lang-html5-DOM-astart}

```rascal
HTML5Attr astart(value val)
```

## function astep {#lang-html5-DOM-astep}

```rascal
HTML5Attr astep(value val)
```

## function astyle {#lang-html5-DOM-astyle}

```rascal
HTML5Attr astyle(value val)
```

## function atabindex {#lang-html5-DOM-atabindex}

```rascal
HTML5Attr atabindex(value val)
```

## function atarget {#lang-html5-DOM-atarget}

```rascal
HTML5Attr atarget(value val)
```

## function atemplate {#lang-html5-DOM-atemplate}

```rascal
HTML5Attr atemplate(value val)
```

## function atitle {#lang-html5-DOM-atitle}

```rascal
HTML5Attr atitle(value val)
```

## function atranslate {#lang-html5-DOM-atranslate}

```rascal
HTML5Attr atranslate(value val)
```

## function atype {#lang-html5-DOM-atype}

```rascal
HTML5Attr atype(value val)
```

## function atypeof {#lang-html5-DOM-atypeof}

```rascal
HTML5Attr atypeof(value val)
```

## function ausemap {#lang-html5-DOM-ausemap}

```rascal
HTML5Attr ausemap(value val)
```

## function avalign {#lang-html5-DOM-avalign}

```rascal
HTML5Attr avalign(value val)
```

## function avalue {#lang-html5-DOM-avalue}

```rascal
HTML5Attr avalue(value val)
```

## function avocab {#lang-html5-DOM-avocab}

```rascal
HTML5Attr avocab(value val)
```

## function awidth {#lang-html5-DOM-awidth}

```rascal
HTML5Attr awidth(value val)
```

## function awrap {#lang-html5-DOM-awrap}

```rascal
HTML5Attr awrap(value val)
```

## function axml_base {#lang-html5-DOM-axml_base}

```rascal
HTML5Attr axml_base(value val)
```

## function axml_id {#lang-html5-DOM-axml_id}

```rascal
HTML5Attr axml_id(value val)
```

## function axml_lang {#lang-html5-DOM-axml_lang}

```rascal
HTML5Attr axml_lang(value val)
```

## function axml_space {#lang-html5-DOM-axml_space}

```rascal
HTML5Attr axml_space(value val)
```

## function isVoid {#lang-html5-DOM-isVoid}

```rascal
bool isVoid(str x)
```

## function isRawText {#lang-html5-DOM-isRawText}

```rascal
bool isRawText(str x)
```

## function isEscapableRawText {#lang-html5-DOM-isEscapableRawText}

```rascal
bool isEscapableRawText(str x)
```

## function isBlockLevel {#lang-html5-DOM-isBlockLevel}

```rascal
bool isBlockLevel(str x)
```

## function startTag {#lang-html5-DOM-startTag}

```rascal
str startTag(str n, str attrs)
```

## function endTag {#lang-html5-DOM-endTag}

```rascal
str endTag(str n)
```

## function startTag {#lang-html5-DOM-startTag}

```rascal
str startTag(str n, {})

default str startTag(str n, set[HTML5Attr] attrs)
```

## function attrsToString {#lang-html5-DOM-attrsToString}

```rascal
str attrsToString(set[HTML5Attr] attrs)
```

## function attrToString {#lang-html5-DOM-attrToString}

```rascal
str attrToString(html5attr(str x, value v))
```

## function rawText {#lang-html5-DOM-rawText}

```rascal
str rawText(list[value] xs)
```

## function escapableRawText {#lang-html5-DOM-escapableRawText}

```rascal
str escapableRawText(list[value] xs)
```

## function kidsToString {#lang-html5-DOM-kidsToString}

```rascal
str kidsToString(list[value] kids)
```

## function kidToString {#lang-html5-DOM-kidToString}

```rascal
str kidToString(HTML5Node elt)

str kidToString(HTML5Attr x)

default str kidToString(value x)
```

## function nodeToString {#lang-html5-DOM-nodeToString}

```rascal
str nodeToString(str n, set[HTML5Attr] attrs, list[value] kids)
```

## function toString {#lang-html5-DOM-toString}

pretty print HTML5Node DOM to a string

```rascal
str toString(HTML5Node x)
```

