/*
 * Decompiled with CFR 0.152.
 */
package engineering.swat.watch.impl.mac;

import engineering.swat.watch.impl.mac.Kind;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import org.checkerframework.checker.nullness.qual.Nullable;

@FunctionalInterface
interface NativeEventHandler {
    public <T> void handle(WatchEvent.Kind<T> var1, @Nullable T var2);

    default public void handle(int kindOrdinal, String rootPath, String relativePath) {
        if (kindOrdinal < Kind.values().length) {
            Kind kind = Kind.values()[kindOrdinal];
            switch (kind) {
                case CREATE: {
                    this.handle(StandardWatchEventKinds.ENTRY_CREATE, NativeEventHandler.toContext(rootPath, relativePath));
                    break;
                }
                case MODIFY: {
                    this.handle(StandardWatchEventKinds.ENTRY_MODIFY, NativeEventHandler.toContext(rootPath, relativePath));
                    break;
                }
                case DELETE: {
                    this.handle(StandardWatchEventKinds.ENTRY_DELETE, NativeEventHandler.toContext(rootPath, relativePath));
                    break;
                }
                case OVERFLOW: {
                    this.handle(StandardWatchEventKinds.OVERFLOW, null);
                }
            }
        }
    }

    public static Path toContext(String rootPath, String relativePath) {
        return Path.of(rootPath, new String[0]).relativize(Path.of(relativePath, new String[0]));
    }
}

