/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.impl.primitive;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.INumber;
import io.usethesource.vallang.IReal;
import io.usethesource.vallang.exceptions.UnexpectedTypeException;
import io.usethesource.vallang.type.TypeFactory;

abstract class AbstractNumberValue
implements INumber {
    private static final TypeFactory typeFactory = TypeFactory.getInstance();

    AbstractNumberValue() {
    }

    @Override
    public String toString() {
        return this.defaultToString();
    }

    @Override
    public INumber add(INumber other) {
        if (this.isIntegerType(other)) {
            return this.add(other.toInteger());
        }
        if (this.isRealType(other)) {
            return this.add(other.toReal(((IReal)other).precision()));
        }
        if (this.isRationalType(other)) {
            return this.add(other.toRational());
        }
        throw new UnexpectedTypeException(typeFactory.numberType(), other.getType());
    }

    @Override
    public INumber divide(INumber other, int precision) {
        if (this.isIntegerType(other)) {
            return this.divide(other.toInteger(), precision);
        }
        if (this.isRealType(other)) {
            return this.divide(other.toReal(precision), precision);
        }
        if (this.isRationalType(other)) {
            return this.divide(other.toRational(), precision);
        }
        throw new UnexpectedTypeException(typeFactory.numberType(), other.getType());
    }

    @Override
    public IBool greater(INumber other) {
        if (this.isIntegerType(other)) {
            return this.greater(other.toInteger());
        }
        if (this.isRealType(other)) {
            return this.greater(other.toReal(((IReal)other).precision()));
        }
        if (this.isRationalType(other)) {
            return this.greater(other.toRational());
        }
        throw new UnexpectedTypeException(typeFactory.numberType(), other.getType());
    }

    @Override
    public IBool equal(INumber other) {
        if (this.isIntegerType(other)) {
            return this.equal(other.toInteger());
        }
        if (this.isRealType(other)) {
            return this.equal(other.toReal(((IReal)other).precision()));
        }
        if (this.isRationalType(other)) {
            return this.equal(other.toRational());
        }
        throw new UnexpectedTypeException(typeFactory.numberType(), other.getType());
    }

    @Override
    public IBool greaterEqual(INumber other) {
        if (this.isIntegerType(other)) {
            return this.greaterEqual(other.toInteger());
        }
        if (this.isRealType(other)) {
            return this.greaterEqual(other.toReal(((IReal)other).precision()));
        }
        if (this.isRationalType(other)) {
            return this.greaterEqual(other.toRational());
        }
        throw new UnexpectedTypeException(typeFactory.numberType(), other.getType());
    }

    @Override
    public IBool less(INumber other) {
        if (this.isIntegerType(other)) {
            return this.less(other.toInteger());
        }
        if (this.isRealType(other)) {
            return this.less(other.toReal(((IReal)other).precision()));
        }
        if (this.isRationalType(other)) {
            return this.less(other.toRational());
        }
        throw new UnexpectedTypeException(typeFactory.numberType(), other.getType());
    }

    @Override
    public IBool lessEqual(INumber other) {
        if (this.isIntegerType(other)) {
            return this.lessEqual(other.toInteger());
        }
        if (this.isRealType(other)) {
            return this.lessEqual(other.toReal(((IReal)other).precision()));
        }
        if (this.isRationalType(other)) {
            return this.lessEqual(other.toRational());
        }
        throw new UnexpectedTypeException(typeFactory.numberType(), other.getType());
    }

    @Override
    public INumber multiply(INumber other) {
        if (this.isIntegerType(other)) {
            return this.multiply(other.toInteger());
        }
        if (this.isRealType(other)) {
            return this.multiply(other.toReal(((IReal)other).precision()));
        }
        if (this.isRationalType(other)) {
            return this.multiply(other.toRational());
        }
        throw new UnexpectedTypeException(typeFactory.numberType(), other.getType());
    }

    @Override
    public INumber subtract(INumber other) {
        if (this.isIntegerType(other)) {
            return this.subtract(other.toInteger());
        }
        if (this.isRealType(other)) {
            return this.subtract(other.toReal(((IReal)other).precision()));
        }
        if (this.isRationalType(other)) {
            return this.subtract(other.toRational());
        }
        throw new UnexpectedTypeException(typeFactory.numberType(), other.getType());
    }

    protected boolean isRationalType(INumber other) {
        return other.getType().equivalent(TypeFactory.getInstance().rationalType());
    }

    protected boolean isRealType(INumber other) {
        return other.getType().equivalent(TypeFactory.getInstance().realType());
    }

    protected boolean isIntegerType(INumber other) {
        return other.getType().equivalent(TypeFactory.getInstance().integerType());
    }
}

