/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.IASTVisitor;
import org.rascalmpl.ast.Name;
import org.rascalmpl.ast.Sym;

public abstract class ConcreteHole
extends AbstractAST {
    public ConcreteHole(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasName() {
        return false;
    }

    public Name getName() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasSymbol() {
        return false;
    }

    public Sym getSymbol() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean isOne() {
        return false;
    }

    public static class One
    extends ConcreteHole {
        private final Sym symbol;
        private final Name name;

        public One(ISourceLocation src, IConstructor node, Sym symbol, Name name) {
            super(src, node);
            this.symbol = symbol;
            this.name = name;
        }

        @Override
        public boolean isOne() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitConcreteHoleOne(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.symbol.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.symbol.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.name.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.name.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof One)) {
                return false;
            }
            One tmp = (One)o;
            return tmp.symbol.equals(this.symbol) && tmp.name.equals(this.name);
        }

        @Override
        public int hashCode() {
            return 257 + 83 * this.symbol.hashCode() + 71 * this.name.hashCode();
        }

        @Override
        public Sym getSymbol() {
            return this.symbol;
        }

        @Override
        public boolean hasSymbol() {
            return true;
        }

        @Override
        public Name getName() {
            return this.name;
        }

        @Override
        public boolean hasName() {
            return true;
        }

        @Override
        public Object clone() {
            return One.newInstance(this.getClass(), this.src, null, this.clone(this.symbol), this.clone(this.name));
        }
    }
}

