/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.Declarator;
import org.rascalmpl.ast.IASTVisitor;

public abstract class LocalVariableDeclaration
extends AbstractAST {
    public LocalVariableDeclaration(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasDeclarator() {
        return false;
    }

    public Declarator getDeclarator() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean isDefault() {
        return false;
    }

    public boolean isDynamic() {
        return false;
    }

    public static class Dynamic
    extends LocalVariableDeclaration {
        private final Declarator declarator;

        public Dynamic(ISourceLocation src, IConstructor node, Declarator declarator) {
            super(src, node);
            this.declarator = declarator;
        }

        @Override
        public boolean isDynamic() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitLocalVariableDeclarationDynamic(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.declarator.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.declarator.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Dynamic)) {
                return false;
            }
            Dynamic tmp = (Dynamic)o;
            return tmp.declarator.equals(this.declarator);
        }

        @Override
        public int hashCode() {
            return 463 + 691 * this.declarator.hashCode();
        }

        @Override
        public Declarator getDeclarator() {
            return this.declarator;
        }

        @Override
        public boolean hasDeclarator() {
            return true;
        }

        @Override
        public Object clone() {
            return Dynamic.newInstance(this.getClass(), this.src, null, this.clone(this.declarator));
        }
    }

    public static class Default
    extends LocalVariableDeclaration {
        private final Declarator declarator;

        public Default(ISourceLocation src, IConstructor node, Declarator declarator) {
            super(src, node);
            this.declarator = declarator;
        }

        @Override
        public boolean isDefault() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitLocalVariableDeclarationDefault(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.declarator.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.declarator.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Default)) {
                return false;
            }
            Default tmp = (Default)o;
            return tmp.declarator.equals(this.declarator);
        }

        @Override
        public int hashCode() {
            return 461 + 7 * this.declarator.hashCode();
        }

        @Override
        public Declarator getDeclarator() {
            return this.declarator;
        }

        @Override
        public boolean hasDeclarator() {
            return true;
        }

        @Override
        public Object clone() {
            return Default.newInstance(this.getClass(), this.src, null, this.clone(this.declarator));
        }
    }
}

