/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.IASTVisitor;
import org.rascalmpl.ast.Name;

public abstract class Renaming
extends AbstractAST {
    public Renaming(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasFrom() {
        return false;
    }

    public Name getFrom() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasTo() {
        return false;
    }

    public Name getTo() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean isDefault() {
        return false;
    }

    public static class Default
    extends Renaming {
        private final Name from;
        private final Name to;

        public Default(ISourceLocation src, IConstructor node, Name from, Name to) {
            super(src, node);
            this.from = from;
            this.to = to;
        }

        @Override
        public boolean isDefault() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitRenamingDefault(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.from.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.from.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.to.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.to.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Default)) {
                return false;
            }
            Default tmp = (Default)o;
            return tmp.from.equals(this.from) && tmp.to.equals(this.to);
        }

        @Override
        public int hashCode() {
            return 233 + 419 * this.from.hashCode() + 599 * this.to.hashCode();
        }

        @Override
        public Name getFrom() {
            return this.from;
        }

        @Override
        public boolean hasFrom() {
            return true;
        }

        @Override
        public Name getTo() {
            return this.to;
        }

        @Override
        public boolean hasTo() {
            return true;
        }

        @Override
        public Object clone() {
            return Default.newInstance(this.getClass(), this.src, null, this.clone(this.from), this.clone(this.to));
        }
    }
}

