/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.dap.breakpoint;

import io.usethesource.vallang.ISourceLocation;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.lsp4j.debug.Source;
import org.rascalmpl.dap.breakpoint.BreakpointInfo;
import org.rascalmpl.debug.DebugHandler;
import org.rascalmpl.debug.DebugMessageFactory;

public class BreakpointsCollection {
    private final Map<String, Map<ISourceLocation, BreakpointInfo>> breakpoints;
    private final DebugHandler debugHandler;
    private final AtomicInteger breakpointIDCounter = new AtomicInteger(0);

    public BreakpointsCollection(DebugHandler debugHandler) {
        this.breakpoints = new ConcurrentHashMap<String, Map<ISourceLocation, BreakpointInfo>>();
        this.debugHandler = debugHandler;
    }

    public void clearBreakpointsOfFile(String filePath) {
        Map<ISourceLocation, BreakpointInfo> fileBreakpoints = this.breakpoints.get(filePath);
        if (fileBreakpoints == null) {
            return;
        }
        for (ISourceLocation breakpointLocation : fileBreakpoints.keySet()) {
            this.debugHandler.processMessage(DebugMessageFactory.requestDeleteBreakpoint(breakpointLocation));
        }
        this.breakpoints.get(filePath).clear();
    }

    public void addBreakpoint(ISourceLocation location, Source source) {
        String path = location.getPath();
        BreakpointInfo breakpoint = new BreakpointInfo(this.breakpointIDCounter.incrementAndGet(), source);
        this.breakpoints.computeIfAbsent(path, k -> new HashMap()).put(location, breakpoint);
        this.debugHandler.processMessage(DebugMessageFactory.requestSetBreakpoint(location));
    }

    public int getBreakpointID(ISourceLocation location) {
        String path = location.getPath();
        Map<ISourceLocation, BreakpointInfo> fileBreakpoints = this.breakpoints.get(path);
        if (fileBreakpoints == null) {
            return -1;
        }
        BreakpointInfo breakpointInfo = fileBreakpoints.get(location);
        if (breakpointInfo == null) {
            return -1;
        }
        return breakpointInfo.getId();
    }
}

