/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.debug;

import io.usethesource.vallang.ISourceLocation;
import java.util.HashSet;
import java.util.Set;
import java.util.function.IntSupplier;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.debug.AbstractInterpreterEventTrigger;
import org.rascalmpl.debug.IDebugHandler;
import org.rascalmpl.debug.IDebugMessage;

public final class DebugHandler
implements IDebugHandler {
    private AbstractInterpreterEventTrigger eventTrigger;
    private final Set<ISourceLocation> breakpoints = new HashSet<ISourceLocation>();
    private boolean suspendRequested;
    private boolean suspended;
    private DebugStepMode stepMode = DebugStepMode.NO_STEP;
    private AbstractAST referenceAST = null;
    private Integer referenceEnvironmentStackSize = null;
    private Runnable terminateAction = null;

    public DebugHandler() {
        this.setEventTrigger(AbstractInterpreterEventTrigger.newNullEventTrigger());
    }

    private boolean hasBreakpoint(ISourceLocation b) {
        return this.breakpoints.contains(b);
    }

    private void addBreakpoint(ISourceLocation breakpointLocation) {
        this.breakpoints.add(breakpointLocation);
    }

    private void removeBreakpoint(ISourceLocation breakpointLocation) {
        this.breakpoints.remove(breakpointLocation);
    }

    protected void clearSuspensionState() {
        this.setReferenceAST(null);
        this.setReferenceEnvironmentStackSize(null);
        this.setSuspended(false);
    }

    protected void updateSuspensionState(int callStackSize, AbstractAST currentAST) {
        this.setReferenceAST(currentAST);
        this.setReferenceEnvironmentStackSize(callStackSize);
        this.setSuspended(true);
    }

    @Override
    public void suspended(Object runtime, IntSupplier getCallStackSize, AbstractAST currentAST) {
        if (this.isSuspendRequested()) {
            this.updateSuspensionState(getCallStackSize.getAsInt(), currentAST);
            this.getEventTrigger().fireSuspendByClientRequestEvent();
            this.setSuspendRequested(false);
        } else {
            AbstractAST location = currentAST;
            if (this.hasBreakpoint(location.getLocation())) {
                this.updateSuspensionState(getCallStackSize.getAsInt(), currentAST);
                this.getEventTrigger().fireSuspendByBreakpointEvent(location.getLocation());
            }
            block1 : switch (this.getStepMode()) {
                case STEP_INTO: {
                    this.updateSuspensionState(getCallStackSize.getAsInt(), currentAST);
                    this.getEventTrigger().fireSuspendByStepEndEvent();
                    break;
                }
                case STEP_OVER: {
                    Integer currentEnvironmentStackSize = getCallStackSize.getAsInt();
                    switch (currentEnvironmentStackSize.compareTo(this.getReferenceEnvironmentStackSize())) {
                        case 0: {
                            ISourceLocation stepScope = this.getReferenceAST().getDebugStepScope();
                            int referenceStart = stepScope.getOffset();
                            int referenceAfter = stepScope.getOffset() + stepScope.getLength();
                            int currentStart = location.getLocation().getOffset();
                            int currentAfter = location.getLocation().getOffset() + location.getLocation().getLength();
                            if (currentStart >= referenceStart && currentStart < referenceAfter && (currentStart != referenceStart || currentAfter != referenceAfter)) break block1;
                            this.updateSuspensionState(currentEnvironmentStackSize, currentAST);
                            this.getEventTrigger().fireSuspendByStepEndEvent();
                            break block1;
                        }
                        case -1: {
                            this.updateSuspensionState(currentEnvironmentStackSize, currentAST);
                            this.getEventTrigger().fireSuspendByStepEndEvent();
                            break block1;
                        }
                        case 1: {
                            break block1;
                        }
                    }
                    throw new RuntimeException("Requires compareTo() to return exactly either -1, 0, or +1.");
                }
                case STEP_OUT: {
                    Integer currentEnvStackSize = getCallStackSize.getAsInt();
                    if (currentEnvStackSize.compareTo(this.getReferenceEnvironmentStackSize()) >= 0) break;
                    this.updateSuspensionState(currentEnvStackSize, currentAST);
                    this.getEventTrigger().fireSuspendByStepEndEvent();
                    break;
                }
            }
        }
        while (this.isSuspended()) {
            try {
                runtime.wait(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected AbstractAST getReferenceAST() {
        return this.referenceAST;
    }

    protected void setReferenceAST(AbstractAST referenceAST) {
        this.referenceAST = referenceAST;
    }

    protected Integer getReferenceEnvironmentStackSize() {
        return this.referenceEnvironmentStackSize;
    }

    protected void setReferenceEnvironmentStackSize(Integer referenceEnvironmentStackSize) {
        this.referenceEnvironmentStackSize = referenceEnvironmentStackSize;
    }

    protected boolean isSuspendRequested() {
        return this.suspendRequested;
    }

    protected void setSuspendRequested(boolean suspendRequested) {
        this.suspendRequested = suspendRequested;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void processMessage(IDebugMessage message) {
        block21: {
            block0 : switch (message.getSubject()) {
                case BREAKPOINT: {
                    ISourceLocation breakpointLocation = (ISourceLocation)message.getPayload();
                    switch (message.getAction()) {
                        case SET: {
                            this.addBreakpoint(breakpointLocation);
                            return;
                        }
                        case DELETE: {
                            this.removeBreakpoint(breakpointLocation);
                        }
                    }
                    return;
                }
                case INTERPRETER: {
                    switch (message.getAction()) {
                        case SUSPEND: {
                            if (message.getDetail() != IDebugMessage.Detail.CLIENT_REQUEST) return;
                            this.setSuspendRequested(true);
                            break block21;
                        }
                        case RESUME: {
                            this.setSuspended(false);
                            switch (message.getDetail()) {
                                case STEP_INTO: {
                                    this.setStepMode(DebugStepMode.STEP_INTO);
                                    this.getEventTrigger().fireResumeByStepIntoEvent();
                                    break block0;
                                }
                                case STEP_OVER: {
                                    this.setStepMode(DebugStepMode.STEP_OVER);
                                    this.getEventTrigger().fireResumeByStepOverEvent();
                                    break block0;
                                }
                                case STEP_OUT: {
                                    this.setStepMode(DebugStepMode.STEP_OUT);
                                    this.getEventTrigger().fireResumeByStepOutEvent();
                                    break block0;
                                }
                                case CLIENT_REQUEST: {
                                    this.setStepMode(DebugStepMode.NO_STEP);
                                    this.getEventTrigger().fireResumeByClientRequestEvent();
                                }
                            }
                            break block0;
                        }
                        case TERMINATE: {
                            if (this.terminateAction == null) return;
                            this.terminateAction.run();
                        }
                    }
                }
            }
        }
    }

    public void setTerminateAction(Runnable terminateAction) {
        this.terminateAction = terminateAction;
    }

    protected synchronized boolean isSuspended() {
        return this.suspended;
    }

    protected synchronized void setSuspended(boolean suspended) {
        this.suspended = suspended;
    }

    protected DebugStepMode getStepMode() {
        return this.stepMode;
    }

    protected void setStepMode(DebugStepMode stepMode) {
        this.stepMode = stepMode;
    }

    public AbstractInterpreterEventTrigger getEventTrigger() {
        return this.eventTrigger;
    }

    public void setEventTrigger(AbstractInterpreterEventTrigger eventTrigger) {
        this.eventTrigger = eventTrigger;
    }

    private static enum DebugStepMode {
        NO_STEP,
        STEP_INTO,
        STEP_OVER,
        STEP_OUT;

    }
}

