/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.matching;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import java.util.HashMap;
import java.util.List;
import org.rascalmpl.ast.Expression;
import org.rascalmpl.exceptions.ImplementationError;
import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.env.Environment;
import org.rascalmpl.interpreter.matching.AbstractMatchingResult;
import org.rascalmpl.interpreter.matching.IMatchingResult;
import org.rascalmpl.interpreter.matching.IVarPattern;
import org.rascalmpl.interpreter.matching.ListPattern;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.result.ResultFactory;
import org.rascalmpl.types.NonTerminalType;
import org.rascalmpl.values.RascalValueFactory;
import org.rascalmpl.values.parsetrees.ITree;
import org.rascalmpl.values.parsetrees.SymbolAdapter;
import org.rascalmpl.values.parsetrees.TreeAdapter;

public class ConcreteListPattern
extends AbstractMatchingResult {
    private ListPattern pat;
    private Expression callOrTree;
    private final boolean bindTypeParameters;

    public ConcreteListPattern(IEvaluatorContext ctx, Expression x, List<IMatchingResult> list, boolean bindTypeParameters) {
        super(ctx, x);
        this.bindTypeParameters = bindTypeParameters;
        this.callOrTree = x;
        this.initListPatternDelegate(list);
    }

    private void initListPatternDelegate(List<IMatchingResult> list) {
        Type type = this.getType(null, null);
        if (type instanceof NonTerminalType) {
            IConstructor rhs = ((NonTerminalType)type).getSymbol();
            if (SymbolAdapter.isIterPlus(rhs) || SymbolAdapter.isIterStar(rhs)) {
                this.pat = new ListPattern(this.ctx, this.callOrTree, list, 1, this.bindTypeParameters);
            } else if (SymbolAdapter.isIterPlusSeps(rhs) || SymbolAdapter.isIterStarSeps(rhs)) {
                this.pat = new ListPattern(this.ctx, this.callOrTree, list, SymbolAdapter.getSeparators(rhs).length() + 1, this.bindTypeParameters);
            } else {
                throw new ImplementationError("crooked production: non (cf or lex) list symbol: " + rhs);
            }
            return;
        }
        throw new ImplementationError("should not get here if we don't know that its a proper list");
    }

    @Override
    public void initMatch(Result<IValue> subject) {
        super.initMatch(subject);
        if (!subject.getStaticType().isSubtypeOf(RascalValueFactory.Tree)) {
            this.hasNext = false;
            return;
        }
        ITree tree = (ITree)subject.getValue();
        if (!tree.isAppl()) {
            this.hasNext = false;
            return;
        }
        this.pat.initMatch(ResultFactory.makeResult(RascalValueFactory.Args, TreeAdapter.getArgs(tree), this.ctx));
        this.hasNext = true;
    }

    @Override
    public Type getType(Environment env, HashMap<String, IVarPattern> patternVars) {
        return this.callOrTree.getConcreteSyntaxType();
    }

    @Override
    public boolean hasNext() {
        if (!this.hasNext) {
            return false;
        }
        return this.pat.hasNext();
    }

    @Override
    public boolean next() {
        if (!this.hasNext()) {
            return false;
        }
        return this.pat.next();
    }

    @Override
    public List<IVarPattern> getVariables() {
        return this.pat.getVariables();
    }

    public String toString() {
        return "concrete: " + this.pat.toString();
    }
}

