/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.result;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IExternalValue;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.visitors.IValueVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.rascalmpl.debug.IRascalMonitor;
import org.rascalmpl.exceptions.ImplementationError;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.interpreter.Evaluator;
import org.rascalmpl.interpreter.IEvaluator;
import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.control_exceptions.Failure;
import org.rascalmpl.interpreter.control_exceptions.MatchFailed;
import org.rascalmpl.interpreter.env.Environment;
import org.rascalmpl.interpreter.result.AbstractFunction;
import org.rascalmpl.interpreter.result.AbstractPatternDispatchedFunction;
import org.rascalmpl.interpreter.result.ComposedFunctionResult;
import org.rascalmpl.interpreter.result.ConcretePatternDispatchedFunction;
import org.rascalmpl.interpreter.result.ICallableValue;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.result.ResultFactory;
import org.rascalmpl.interpreter.staticErrors.UnguardedFail;
import org.rascalmpl.values.RascalValueFactory;

public class OverloadedFunction
extends Result<IValue>
implements IExternalValue,
ICallableValue {
    private static final TypeFactory TF = TypeFactory.getInstance();
    private final List<AbstractFunction> primaryCandidates;
    private final List<AbstractFunction> defaultCandidates;
    private final String name;
    private final boolean isStatic;

    public OverloadedFunction(String name, Type type, List<AbstractFunction> candidates, List<AbstractFunction> defaults, IEvaluatorContext ctx) {
        super(type, null, ctx);
        if (candidates.size() + defaults.size() <= 0) {
            throw new ImplementationError("at least need one function");
        }
        this.name = name;
        this.primaryCandidates = new ArrayList<AbstractFunction>(candidates.size());
        this.defaultCandidates = new ArrayList<AbstractFunction>(candidates.size());
        this.addAll(this.primaryCandidates, candidates, true);
        this.addAll(this.defaultCandidates, defaults, false);
        this.isStatic = OverloadedFunction.checkStatic(this.primaryCandidates) && OverloadedFunction.checkStatic(this.defaultCandidates);
    }

    public OverloadedFunction(String name, List<AbstractFunction> funcs) {
        super(OverloadedFunction.lub(funcs), null, funcs.iterator().next().getEval());
        this.name = name;
        this.primaryCandidates = new ArrayList<AbstractFunction>(1);
        this.defaultCandidates = new ArrayList<AbstractFunction>(1);
        this.addAll(this.primaryCandidates, funcs, true);
        this.addAll(this.defaultCandidates, funcs, false);
        this.isStatic = OverloadedFunction.checkStatic(funcs);
    }

    private OverloadedFunction(String name, Type type, List<AbstractFunction> candidates, List<AbstractFunction> defaults, boolean isStatic, IEvaluatorContext ctx) {
        super(type, null, ctx);
        this.name = name;
        this.primaryCandidates = candidates;
        this.defaultCandidates = defaults;
        this.isStatic = isStatic;
    }

    public OverloadedFunction(AbstractFunction function) {
        super(function.getStaticType(), null, function.getEval());
        this.name = function.getName();
        this.primaryCandidates = new ArrayList<AbstractFunction>(1);
        this.defaultCandidates = new ArrayList<AbstractFunction>(1);
        if (function.isDefault()) {
            this.defaultCandidates.add(function);
        } else {
            this.primaryCandidates.add(function);
        }
        this.isStatic = function.isStatic();
    }

    @Override
    public IConstructor encodeAsConstructor() {
        IListWriter alternatives = this.getValueFactory().listWriter();
        for (AbstractFunction f : this.primaryCandidates) {
            alternatives.append(f.encodeAsConstructor());
        }
        IListWriter otherwise = this.getValueFactory().listWriter();
        for (AbstractFunction f : this.defaultCandidates) {
            otherwise.append(f.encodeAsConstructor());
        }
        return this.getValueFactory().constructor(RascalValueFactory.Function_Choice, new IValue[]{alternatives.done(), otherwise.done()});
    }

    @Override
    public Type getType() {
        return this.getStaticType();
    }

    public List<AbstractFunction> getPrimaryCandidates() {
        return this.primaryCandidates;
    }

    public List<AbstractFunction> getDefaultCandidates() {
        return this.defaultCandidates;
    }

    @Override
    public Type getKeywordArgumentTypes(Environment scope) {
        Type args;
        ArrayList<String> labels = new ArrayList<String>();
        ArrayList<Type> types = new ArrayList<Type>();
        for (AbstractFunction c : this.primaryCandidates) {
            args = c.getKeywordArgumentTypes(scope);
            if (args == null || !args.hasFieldNames()) continue;
            for (String label : args.getFieldNames()) {
                labels.add(label);
                types.add(args.getFieldType(label));
            }
        }
        for (AbstractFunction c : this.defaultCandidates) {
            args = c.getKeywordArgumentTypes(scope);
            if (args == null || !args.hasFieldNames()) continue;
            for (String label : args.getFieldNames()) {
                labels.add(label);
                types.add(args.getFieldType(label));
            }
        }
        return TF.tupleType(types.toArray(new Type[types.size()]), labels.toArray(new String[labels.size()]));
    }

    @Override
    public OverloadedFunction cloneInto(Environment env) {
        ArrayList<AbstractFunction> newCandidates = new ArrayList<AbstractFunction>();
        for (AbstractFunction f : this.primaryCandidates) {
            newCandidates.add((AbstractFunction)f.cloneInto(env));
        }
        ArrayList<AbstractFunction> newDefaultCandidates = new ArrayList<AbstractFunction>();
        for (AbstractFunction f : this.defaultCandidates) {
            newDefaultCandidates.add((AbstractFunction)f.cloneInto(env));
        }
        return new OverloadedFunction(this.name, this.getStaticType(), newCandidates, newDefaultCandidates, this.isStatic, this.ctx);
    }

    private void addAll(List<AbstractFunction> container, List<AbstractFunction> candidates, boolean nonDefault) {
        int i;
        Map[] constructors = new Map[10];
        Map[] productions = new Map[10];
        LinkedList<AbstractFunction> other = new LinkedList<AbstractFunction>();
        for (AbstractFunction func : candidates) {
            int pos;
            if (nonDefault && func.isDefault() || !nonDefault && !func.isDefault()) continue;
            String label = null;
            IConstructor prod = null;
            if (func.isPatternDispatched()) {
                Map<String, List<AbstractFunction>> funcMap = ((AbstractPatternDispatchedFunction)func).getMap();
                pos = func.getIndexedArgumentPosition();
                for (String string : funcMap.keySet()) {
                    this.addFuncsToMap(pos, constructors, funcMap.get(string), string);
                }
                continue;
            }
            if (func.isConcretePatternDispatched()) {
                Map<IConstructor, List<AbstractFunction>> funcMap = ((ConcretePatternDispatchedFunction)func).getMap();
                pos = func.getIndexedArgumentPosition();
                for (IConstructor iConstructor : funcMap.keySet()) {
                    this.addProdsToMap(pos, productions, funcMap.get(iConstructor), iConstructor);
                }
                continue;
            }
            int pos2 = func.getIndexedArgumentPosition();
            label = func.getIndexedLabel();
            prod = func.getIndexedProduction();
            if (label != null) {
                this.addFuncToMap(pos2, constructors, func, label);
                continue;
            }
            if (prod != null) {
                this.addProdToMap(pos2, productions, func, prod);
                continue;
            }
            other.add(func);
        }
        for (i = 0; i < constructors.length; ++i) {
            if (constructors[i] == null || constructors[i].isEmpty()) continue;
            container.add(new AbstractPatternDispatchedFunction(this.ctx.getEvaluator(), i, this.name, constructors[i]));
        }
        for (i = 0; i < productions.length; ++i) {
            if (productions[i] == null || productions[i].isEmpty()) continue;
            container.add(new ConcretePatternDispatchedFunction(this.ctx.getEvaluator(), i, this.name, productions[i]));
        }
        container.addAll(other);
    }

    private void addFuncToMap(int pos, Map<String, List<AbstractFunction>>[] map, AbstractFunction func, String label) {
        List<AbstractFunction> l;
        if (map[pos] == null) {
            map[pos] = new HashMap<String, List<AbstractFunction>>();
        }
        if ((l = map[pos].get(label)) == null) {
            l = new LinkedList<AbstractFunction>();
            map[pos].put(label, l);
        }
        l.add(func);
    }

    private void addProdToMap(int pos, Map<IConstructor, List<AbstractFunction>>[] map, AbstractFunction func, IConstructor label) {
        List<AbstractFunction> l;
        if (map[pos] == null) {
            map[pos] = new HashMap<IConstructor, List<AbstractFunction>>();
        }
        if ((l = map[pos].get(label)) == null) {
            l = new LinkedList<AbstractFunction>();
            map[pos].put(label, l);
        }
        l.add(func);
    }

    private void addFuncsToMap(int pos, Map<String, List<AbstractFunction>>[] map, List<AbstractFunction> funcs, String label) {
        List<AbstractFunction> l;
        if (map[pos] == null) {
            map[pos] = new HashMap<String, List<AbstractFunction>>();
        }
        if ((l = map[pos].get(label)) == null) {
            l = new LinkedList<AbstractFunction>();
            map[pos].put(label, l);
        }
        l.addAll(funcs);
    }

    private void addProdsToMap(int pos, Map<IConstructor, List<AbstractFunction>>[] map, List<AbstractFunction> funcs, IConstructor label) {
        List<AbstractFunction> l;
        if (map[pos] == null) {
            map[pos] = new HashMap<IConstructor, List<AbstractFunction>>();
        }
        if ((l = map[pos].get(label)) == null) {
            l = new LinkedList<AbstractFunction>();
            map[pos].put(label, l);
        }
        l.addAll(funcs);
    }

    @Override
    public int getArity() {
        return this.getStaticType().getArity();
    }

    @Override
    public boolean hasVarArgs() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasKeywordArguments() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isStatic() {
        return this.isStatic;
    }

    private static boolean checkStatic(List<AbstractFunction> l) {
        for (ICallableValue iCallableValue : l) {
            if (iCallableValue.isStatic()) continue;
            return false;
        }
        return true;
    }

    @Override
    public IValue getValue() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result<IValue> call(IRascalMonitor monitor, Type[] argTypes, IValue[] argValues, Map<String, IValue> keyArgValues) {
        IRascalMonitor old = this.ctx.getEvaluator().setMonitor(monitor);
        try {
            Result<IValue> result = this.call(argTypes, argValues, keyArgValues);
            return result;
        }
        finally {
            this.ctx.getEvaluator().setMonitor(old);
        }
    }

    @Override
    public Result<IValue> call(Type[] argTypes, IValue[] argValues, Map<String, IValue> keyArgValues) {
        Result<IValue> result = OverloadedFunction.callWith(this.primaryCandidates, argTypes, argValues, keyArgValues, this.defaultCandidates.size() <= 0);
        if (result == null && this.defaultCandidates.size() > 0) {
            result = OverloadedFunction.callWith(this.defaultCandidates, argTypes, argValues, keyArgValues, true);
        }
        if (result == null) {
            throw new MatchFailed();
        }
        return result;
    }

    @Override
    public <T extends IValue> T call(Map<String, IValue> keywordParameters, IValue ... parameters) {
        IEvaluator<Result<IValue>> iEvaluator = this.ctx.getEvaluator();
        synchronized (iEvaluator) {
            if (parameters.length != this.getArity()) {
                throw RuntimeExceptionFactory.callFailed(this.ctx.getCurrentAST().getLocation(), Arrays.stream(parameters).collect(this.getValueFactory().listWriter()));
            }
            try {
                return ICallableValue.super.call(keywordParameters, parameters);
            }
            catch (MatchFailed e) {
                throw RuntimeExceptionFactory.callFailed(this.ctx.getCurrentAST().getLocation(), Arrays.stream(parameters).collect(this.getValueFactory().listWriter()));
            }
        }
    }

    private static Result<IValue> callWith(List<AbstractFunction> candidates, Type[] argTypes, IValue[] argValues, Map<String, IValue> keyArgValues, boolean mustSucceed) {
        AbstractFunction failed = null;
        Failure failure = null;
        for (AbstractFunction candidate : candidates) {
            if ((!candidate.hasVarArgs() || argValues.length < candidate.getArity() - 1) && candidate.getArity() != argValues.length && !candidate.hasKeywordArguments()) continue;
            try {
                return candidate.call(argTypes, argValues, keyArgValues);
            }
            catch (MatchFailed matchFailed) {
            }
            catch (Failure e) {
                failed = candidate;
                failure = e;
            }
        }
        if (failed != null && mustSucceed) {
            throw new UnguardedFail(failed.ast, failure);
        }
        return null;
    }

    public OverloadedFunction join(OverloadedFunction other) {
        if (other == null) {
            return this;
        }
        ArrayList<AbstractFunction> joined = new ArrayList<AbstractFunction>(other.primaryCandidates.size() + this.primaryCandidates.size());
        ArrayList<AbstractFunction> defJoined = new ArrayList<AbstractFunction>(other.defaultCandidates.size() + this.defaultCandidates.size());
        joined.addAll(this.primaryCandidates);
        defJoined.addAll(this.defaultCandidates);
        for (AbstractFunction cand : other.primaryCandidates) {
            if (joined.contains(cand)) continue;
            joined.add(cand);
        }
        for (AbstractFunction cand : other.defaultCandidates) {
            if (defJoined.contains(cand)) continue;
            defJoined.add(cand);
        }
        return new OverloadedFunction("(" + this.name + "+" + other.getName() + ")", OverloadedFunction.lub(joined).lub(OverloadedFunction.lub(defJoined)), joined, defJoined, this.ctx);
    }

    private static Type lub(List<AbstractFunction> joined) {
        Type t2 = TF.voidType();
        for (AbstractFunction f : joined) {
            t2 = t2.lub(f.getStaticType());
        }
        return t2;
    }

    public OverloadedFunction add(AbstractFunction candidate) {
        ArrayList<AbstractFunction> joined = new ArrayList<AbstractFunction>(this.primaryCandidates.size() + 1);
        joined.addAll(this.primaryCandidates);
        ArrayList<AbstractFunction> defJoined = new ArrayList<AbstractFunction>(this.defaultCandidates.size() + 1);
        defJoined.addAll(this.defaultCandidates);
        if (candidate.isDefault() && !defJoined.contains(candidate)) {
            defJoined.add(candidate);
        } else if (!candidate.isDefault() && !joined.contains(candidate)) {
            joined.add(candidate);
        }
        return new OverloadedFunction("(" + this.name + "+" + candidate.getName() + ")", OverloadedFunction.lub(joined).lub(OverloadedFunction.lub(defJoined)), joined, defJoined, this.ctx);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof OverloadedFunction) {
            OverloadedFunction other = (OverloadedFunction)obj;
            return this.primaryCandidates.containsAll(other.primaryCandidates) && other.primaryCandidates.containsAll(this.primaryCandidates) && this.defaultCandidates.containsAll(other.defaultCandidates) && other.defaultCandidates.containsAll(this.defaultCandidates);
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        for (AbstractFunction l : this.primaryCandidates) {
            b.append(l.toString());
            b.append(' ');
        }
        for (AbstractFunction l : this.defaultCandidates) {
            b.append(l.toString());
            b.append(' ');
        }
        return b.toString();
    }

    @Override
    public <T, E extends Throwable> T accept(IValueVisitor<T, E> v) throws E {
        return v.visitExternal(this);
    }

    @Override
    public <V extends IValue> Result<IBool> equals(Result<V> that) {
        return that.equalToOverloadedFunction(this);
    }

    @Override
    public Result<IBool> equalToOverloadedFunction(OverloadedFunction that) {
        return ResultFactory.bool(this.primaryCandidates.equals(that.primaryCandidates) && this.defaultCandidates.equals(that.defaultCandidates), this.ctx);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> add(Result<V> that) {
        return that.addFunctionNonDeterministic(this);
    }

    public OverloadedFunction addFunctionNonDeterministic(AbstractFunction that) {
        return this.add(that);
    }

    public OverloadedFunction addFunctionNonDeterministic(OverloadedFunction that) {
        return this.join(that);
    }

    public ComposedFunctionResult addFunctionNonDeterministic(ComposedFunctionResult that) {
        return new ComposedFunctionResult.NonDeterministic(that, this, this.ctx);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> compose(Result<V> right) {
        return right.composeFunction(this);
    }

    public ComposedFunctionResult composeFunction(AbstractFunction that) {
        return new ComposedFunctionResult(that, this, this.ctx);
    }

    public ComposedFunctionResult composeFunction(OverloadedFunction that) {
        return new ComposedFunctionResult(that, this, this.ctx);
    }

    public ComposedFunctionResult composeFunction(ComposedFunctionResult that) {
        return new ComposedFunctionResult(that, this, this.ctx);
    }

    public List<AbstractFunction> getFunctions() {
        LinkedList<AbstractFunction> result = new LinkedList<AbstractFunction>();
        for (AbstractFunction f : this.primaryCandidates) {
            result.add(f);
        }
        for (AbstractFunction f : this.defaultCandidates) {
            result.add(f);
        }
        return result;
    }

    public List<AbstractFunction> getTests() {
        LinkedList<AbstractFunction> result = new LinkedList<AbstractFunction>();
        for (AbstractFunction f : this.getFunctions()) {
            if (!f.isTest()) continue;
            result.add(f);
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public Evaluator getEval() {
        return (Evaluator)this.ctx;
    }
}

