/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.result;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISetWriter;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.result.LessThanOrEqualResult;
import org.rascalmpl.interpreter.result.RelationResult;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.result.ResultFactory;
import org.rascalmpl.interpreter.result.SetOrRelationResult;

public class SetResult
extends SetOrRelationResult<ISet> {
    public SetResult(Type type, ISet set, IEvaluatorContext ctx) {
        super(type, set, ctx);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> add(Result<V> result) {
        return result.addSet(this);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> subtract(Result<V> result) {
        return result.subtractSet(this);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> multiply(Result<V> result) {
        return result.multiplySet(this);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> join(Result<V> that) {
        return that.joinSet(this);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> intersect(Result<V> result) {
        return result.intersectSet(this);
    }

    @Override
    public <V extends IValue> Result<IBool> in(Result<V> result) {
        return result.inSet(this);
    }

    @Override
    public <V extends IValue> Result<IBool> notIn(Result<V> result) {
        return result.notInSet(this);
    }

    @Override
    public <V extends IValue> Result<IBool> equals(Result<V> that) {
        return that.equalToSet(this);
    }

    @Override
    public <V extends IValue> Result<IBool> nonEquals(Result<V> that) {
        return that.nonEqualToSet(this);
    }

    @Override
    public <V extends IValue> Result<IBool> lessThan(Result<V> that) {
        return that.lessThanSet(this);
    }

    @Override
    public <V extends IValue> LessThanOrEqualResult lessThanOrEqual(Result<V> that) {
        return that.lessThanOrEqualSet(this);
    }

    @Override
    public <V extends IValue> Result<IBool> greaterThan(Result<V> that) {
        return that.greaterThanSet(this);
    }

    @Override
    public <V extends IValue> Result<IBool> greaterThanOrEqual(Result<V> that) {
        return that.greaterThanOrEqualSet(this);
    }

    @Override
    protected LessThanOrEqualResult lessThanOrEqualSet(SetResult that) {
        boolean isSubset = ((ISet)that.getValue()).isSubsetOf((ISet)this.getValue());
        boolean equals = ((ISet)that.getValue()).equals(this.getValue());
        return new LessThanOrEqualResult(isSubset && !equals, equals, this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> joinRelation(RelationResult that) {
        int arity1 = ((ISet)that.getValue()).asRelation().arity();
        Type eltType = this.getStaticType().getElementType();
        Type tupleType = that.getStaticType().getElementType();
        Type[] fieldTypes = new Type[arity1 + 1];
        for (int i = 0; i < arity1; ++i) {
            fieldTypes[i] = tupleType.getFieldType(i);
        }
        fieldTypes[arity1] = eltType;
        Type resultTupleType = this.getTypeFactory().tupleType(fieldTypes);
        ISetWriter writer = this.getValueFactory().setWriter();
        IValue[] fieldValues = new IValue[arity1 + 1];
        for (IValue relValue : (ISet)that.getValue()) {
            for (IValue setValue : (ISet)this.getValue()) {
                for (int i = 0; i < arity1; ++i) {
                    fieldValues[i] = ((ITuple)relValue).get(i);
                }
                fieldValues[arity1] = setValue;
                writer.insert(this.getValueFactory().tuple(fieldValues));
            }
        }
        Type resultType = this.getTypeFactory().relTypeFromTuple(resultTupleType);
        return ResultFactory.makeResult(resultType, writer.done(), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> joinSet(SetResult that) {
        Type tupleType = this.getTypeFactory().tupleType(that.getStaticType().getElementType(), this.getStaticType().getElementType());
        return ResultFactory.makeResult(this.getTypeFactory().relTypeFromTuple(tupleType), ((ISet)that.getValue()).product((ISet)this.getValue()), this.ctx);
    }
}

