/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.library.lang.json.internal;

import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.MalformedJsonException;
import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.IMapWriter;
import io.usethesource.vallang.ISetWriter;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.io.StandardTextReader;
import io.usethesource.vallang.type.ITypeVisitor;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.io.EOFException;
import java.io.IOException;
import java.io.StringReader;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.rascalmpl.debug.IRascalMonitor;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.exceptions.Throw;
import org.rascalmpl.types.ReifiedType;
import org.rascalmpl.types.TypeReifier;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.values.IRascalValueFactory;
import org.rascalmpl.values.functions.IFunction;
import org.rascalmpl.values.maybe.UtilMaybe;

public class JsonValueReader {
    private static final TypeFactory TF = TypeFactory.getInstance();
    private final TypeStore store;
    private final IValueFactory vf;
    private ThreadLocal<SimpleDateFormat> format;
    private final IRascalMonitor monitor;
    private ISourceLocation src;
    private boolean originTracking;
    private VarHandle posHandler;
    private VarHandle lineHandler;
    private VarHandle lineStartHandler;
    private boolean explicitConstructorNames;
    private boolean explicitDataTypes;
    private IFunction parsers;
    private Map<Type, IValue> nulls = Collections.emptyMap();

    public JsonValueReader(IValueFactory vf, TypeStore store, IRascalMonitor monitor, ISourceLocation src) {
        this.vf = vf;
        this.store = store;
        this.monitor = monitor;
        this.src = src;
        this.setCalendarFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        if (src != null) {
            try {
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                MethodHandles.Lookup privateLookup = MethodHandles.privateLookupIn(JsonReader.class, lookup);
                this.posHandler = privateLookup.findVarHandle(JsonReader.class, "pos", Integer.TYPE);
                this.lineHandler = privateLookup.findVarHandle(JsonReader.class, "lineNumber", Integer.TYPE);
                this.lineStartHandler = privateLookup.findVarHandle(JsonReader.class, "lineStart", Integer.TYPE);
                this.originTracking = src != null;
            }
            catch (IllegalAccessException | NoSuchFieldException | SecurityException e) {
                src = null;
                this.originTracking = false;
                monitor.warning("Unable to retrieve origin information due to: " + e.getMessage(), src);
            }
        }
    }

    public JsonValueReader(IValueFactory vf, IRascalMonitor monitor, ISourceLocation src) {
        this(vf, new TypeStore(new TypeStore[0]), monitor, src);
    }

    public JsonValueReader setExplicitConstructorNames(boolean value) {
        this.explicitConstructorNames = value;
        return this;
    }

    public JsonValueReader setExplicitDataTypes(boolean value) {
        this.explicitDataTypes = value;
        if (value) {
            this.explicitConstructorNames = true;
        }
        return this;
    }

    public JsonValueReader(IRascalValueFactory vf, TypeStore store, IRascalMonitor monitor, ISourceLocation src) {
        this.vf = vf;
        this.store = store;
        this.monitor = monitor;
        this.src = src == null ? URIUtil.rootLocation("unknown") : src;
        this.setCalendarFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodHandles.Lookup privateLookup = MethodHandles.privateLookupIn(JsonReader.class, lookup);
            this.posHandler = privateLookup.findVarHandle(JsonReader.class, "pos", Integer.TYPE);
            this.lineHandler = privateLookup.findVarHandle(JsonReader.class, "lineNumber", Integer.TYPE);
            this.lineStartHandler = privateLookup.findVarHandle(JsonReader.class, "lineStart", Integer.TYPE);
            this.originTracking = src != null;
        }
        catch (IllegalAccessException | NoSuchFieldException | SecurityException e) {
            this.originTracking = false;
            src = null;
            monitor.warning("Unable to retrieve origin information due to: " + e.getMessage(), src);
        }
    }

    public JsonValueReader(IRascalValueFactory vf, IRascalMonitor monitor, ISourceLocation src) {
        this(vf, new TypeStore(new TypeStore[0]), monitor, src);
    }

    public JsonValueReader setNulls(Map<Type, IValue> nulls) {
        this.nulls = nulls;
        return this;
    }

    public JsonValueReader setCalendarFormat(final String format) {
        this.format = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                return new SimpleDateFormat(format);
            }
        };
        return this;
    }

    public JsonValueReader setParsers(IFunction parsers) {
        if (parsers.getType() instanceof ReifiedType && parsers.getType().getTypeParameters().getFieldType(0).isTop()) {
            parsers = null;
        }
        this.parsers = parsers;
        return this;
    }

    public IValue read(JsonReader in, Type expected) throws IOException {
        ExpectedTypeDispatcher dispatch = new ExpectedTypeDispatcher(in);
        try {
            IValue result = expected.accept(dispatch);
            if (result == null) {
                throw new JsonParseException("null occurred outside an optionality context and without a registered representation.");
            }
            return result;
        }
        catch (JsonParseException | MalformedJsonException | EOFException | IllegalStateException | NullPointerException | NumberFormatException e) {
            throw dispatch.parseErrorHere(e.getMessage());
        }
    }

    private final class ExpectedTypeDispatcher
    implements ITypeVisitor<IValue, IOException> {
        private final JsonReader in;
        private int lastPos;

        private ExpectedTypeDispatcher(JsonReader in) {
            this.in = in;
        }

        private String nextString() throws IOException {
            this.lastPos = this.getPos();
            return this.in.nextString();
        }

        private String nextName() throws IOException {
            this.lastPos = this.getPos();
            return this.in.nextName();
        }

        @Override
        public IValue visitInteger(Type type) throws IOException {
            try {
                switch (this.in.peek()) {
                    case NUMBER: 
                    case STRING: {
                        return JsonValueReader.this.vf.integer(this.nextString());
                    }
                    case NULL: {
                        this.in.nextNull();
                        return this.inferNullValue(JsonValueReader.this.nulls, type);
                    }
                }
                throw this.parseErrorHere("Expected integer but got " + this.in.peek());
            }
            catch (NumberFormatException e) {
                throw this.parseErrorHere("Expected integer but got " + e.getMessage());
            }
        }

        @Override
        public IValue visitReal(Type type) throws IOException {
            try {
                switch (this.in.peek()) {
                    case NUMBER: 
                    case STRING: {
                        return JsonValueReader.this.vf.real(this.nextString());
                    }
                    case NULL: {
                        this.in.nextNull();
                        return this.inferNullValue(JsonValueReader.this.nulls, type);
                    }
                }
                throw this.parseErrorHere("Expected real but got " + this.in.peek());
            }
            catch (NumberFormatException e) {
                throw this.parseErrorHere("Expected real but got " + e.getMessage());
            }
        }

        private IValue inferNullValue(Map<Type, IValue> nulls, Type expected) {
            return nulls.entrySet().stream().map(Map.Entry::getKey).sorted(Type::compareTo).filter(superType -> expected.isSubtypeOf((Type)superType)).findFirst().map(t2 -> (IValue)nulls.get(t2)).filter(r -> r.getType().isSubtypeOf(expected)).orElse(null);
        }

        @Override
        public IValue visitExternal(Type type) throws IOException {
            throw this.parseErrorHere("External type " + type + "is not implemented yet by the json reader:" + this.in.getPath());
        }

        @Override
        public IValue visitString(Type type) throws IOException {
            if (this.isNull()) {
                return this.inferNullValue(JsonValueReader.this.nulls, type);
            }
            return JsonValueReader.this.vf.string(this.nextString());
        }

        @Override
        public IValue visitTuple(Type type) throws IOException {
            if (this.isNull()) {
                return null;
            }
            ArrayList<IValue> l = new ArrayList<IValue>();
            this.in.beginArray();
            if (type.hasFieldNames()) {
                for (int i = 0; i < type.getArity(); ++i) {
                    l.add(type.getFieldType(i).accept(this));
                }
            } else {
                for (int i = 0; i < type.getArity(); ++i) {
                    l.add(type.getFieldType(i).accept(this));
                }
            }
            this.in.endArray();
            l.forEach(e -> {
                if (e == null) {
                    throw this.parseErrorHere("Tuples can not have null elements.");
                }
            });
            assert (type.getArity() == l.size());
            return JsonValueReader.this.vf.tuple(l.toArray(new IValue[l.size()]));
        }

        @Override
        public IValue visitVoid(Type type) throws IOException {
            throw this.parseErrorHere("Can not read json values of type void: " + this.in.getPath());
        }

        @Override
        public IValue visitFunction(Type type) throws IOException {
            throw this.parseErrorHere("Can not read json values of function types: " + this.in.getPath());
        }

        @Override
        public IValue visitSourceLocation(Type type) throws IOException {
            if (this.isNull()) {
                return this.inferNullValue(JsonValueReader.this.nulls, type);
            }
            switch (this.in.peek()) {
                case STRING: {
                    return this.sourceLocationString();
                }
                case BEGIN_OBJECT: {
                    return this.sourceLocationObject();
                }
            }
            throw this.parseErrorHere("Could not find string or source location object here: " + this.in.getPath());
        }

        private IValue sourceLocationObject() throws IOException {
            String scheme = null;
            String authority = null;
            String path = null;
            String fragment = "";
            String query = "";
            int offset = -1;
            int length = -1;
            int beginLine = -1;
            int endLine = -1;
            int beginColumn = -1;
            int endColumn = -1;
            this.in.beginObject();
            block25: while (this.in.hasNext()) {
                String name;
                switch (name = this.nextName()) {
                    case "scheme": {
                        scheme = this.nextString();
                        continue block25;
                    }
                    case "authority": {
                        authority = this.nextString();
                        continue block25;
                    }
                    case "path": {
                        path = this.nextString();
                        continue block25;
                    }
                    case "fragment": {
                        fragment = this.nextString();
                        continue block25;
                    }
                    case "query": {
                        query = this.nextString();
                        continue block25;
                    }
                    case "offset": {
                        offset = this.in.nextInt();
                        continue block25;
                    }
                    case "length": {
                        length = this.in.nextInt();
                        continue block25;
                    }
                    case "start": 
                    case "begin": {
                        this.in.beginArray();
                        beginLine = this.in.nextInt();
                        beginColumn = this.in.nextInt();
                        this.in.endArray();
                        continue block25;
                    }
                    case "end": {
                        this.in.beginArray();
                        endLine = this.in.nextInt();
                        endColumn = this.in.nextInt();
                        this.in.endArray();
                        continue block25;
                    }
                }
                throw this.parseErrorHere("unexpected property name " + name + " :" + this.in.getPath());
            }
            this.in.endObject();
            try {
                ISourceLocation root;
                if (scheme != null && authority != null && query != null && fragment != null) {
                    root = JsonValueReader.this.vf.sourceLocation(scheme, authority, path, query, fragment);
                } else if (scheme != null) {
                    root = JsonValueReader.this.vf.sourceLocation(scheme, authority == null ? "" : authority, path);
                } else if (path != null) {
                    root = URIUtil.createFileLocation(path);
                } else {
                    throw this.parseErrorHere("Could not parse complete source location: " + this.in.getPath());
                }
                if (offset != -1 && length != -1 && beginLine != -1 && endLine != -1 && beginColumn != -1 && endColumn != -1) {
                    return JsonValueReader.this.vf.sourceLocation(root, offset, length, beginLine, endLine, beginColumn, endColumn);
                }
                if (offset != -1 && length != -1) {
                    return JsonValueReader.this.vf.sourceLocation(root, offset, length);
                }
                return root;
            }
            catch (URISyntaxException e) {
                throw this.parseErrorHere(e.getMessage());
            }
        }

        @Override
        public IValue visitValue(Type type) throws IOException {
            switch (this.in.peek()) {
                case NUMBER: {
                    return this.visitNumber(TF.numberType());
                }
                case STRING: {
                    return this.visitString(TF.stringType());
                }
                case BEGIN_ARRAY: {
                    return this.visitList(TF.listType(TF.valueType()));
                }
                case BEGIN_OBJECT: {
                    return this.visitNode(TF.nodeType());
                }
                case BOOLEAN: {
                    return this.visitBool(TF.boolType());
                }
                case NAME: {
                    return JsonValueReader.this.vf.string(this.nextName());
                }
                case NULL: {
                    this.in.nextNull();
                    return this.inferNullValue(JsonValueReader.this.nulls, type);
                }
            }
            throw this.parseErrorHere("Did not expect end of Json value here, while looking for " + type + " + at " + this.in.getPath());
        }

        private IValue sourceLocationString() throws IOException {
            try {
                String val = this.nextString().trim();
                if (val.startsWith("|") && (val.endsWith("|") || val.endsWith(")"))) {
                    return new StandardTextReader().read(JsonValueReader.this.vf, new StringReader(val));
                }
                if (val.contains("://")) {
                    return JsonValueReader.this.vf.sourceLocation(URIUtil.createFromEncoded(val));
                }
                return URIUtil.createFileLocation(val);
            }
            catch (URISyntaxException e) {
                throw this.parseErrorHere(e.getMessage());
            }
        }

        @Override
        public IValue visitRational(Type type) throws IOException {
            if (this.isNull()) {
                return this.inferNullValue(JsonValueReader.this.nulls, type);
            }
            switch (this.in.peek()) {
                case BEGIN_ARRAY: {
                    this.in.beginArray();
                    IInteger numA = (IInteger)TF.integerType().accept(this);
                    IInteger denomA = (IInteger)TF.integerType().accept(this);
                    this.in.endArray();
                    return JsonValueReader.this.vf.rational(numA, denomA);
                }
                case STRING: {
                    return JsonValueReader.this.vf.rational(this.nextString());
                }
            }
            throw this.parseErrorHere("Expected integer but got " + this.in.peek());
        }

        @Override
        public IValue visitMap(Type type) throws IOException {
            if (this.isNull()) {
                return this.inferNullValue(JsonValueReader.this.nulls, type);
            }
            IMapWriter w = JsonValueReader.this.vf.mapWriter();
            switch (this.in.peek()) {
                case BEGIN_OBJECT: {
                    this.in.beginObject();
                    if (!type.getKeyType().isString() && this.in.peek() != JsonToken.END_OBJECT) {
                        throw this.parseErrorHere("Can not read JSon object as a map if the key type of the map (" + type + ") is not a string at " + this.in.getPath());
                    }
                    while (this.in.hasNext()) {
                        IString label = JsonValueReader.this.vf.string(this.nextName());
                        IValue value = type.getValueType().accept(this);
                        if (value == null) continue;
                        w.put(label, value);
                    }
                    this.in.endObject();
                    return w.done();
                }
                case BEGIN_ARRAY: {
                    this.in.beginArray();
                    while (this.in.hasNext()) {
                        this.in.beginArray();
                        IValue key = type.getKeyType().accept(this);
                        IValue value = type.getValueType().accept(this);
                        if (key != null && value != null) {
                            w.put(key, value);
                        }
                        this.in.endArray();
                    }
                    this.in.endArray();
                    return w.done();
                }
            }
            throw this.parseErrorHere("Expected a map encoded as an object or an nested array to match " + type);
        }

        @Override
        public IValue visitAlias(Type type) throws IOException {
            while (type.isAliased()) {
                type = type.getAliased();
            }
            return type.accept(this);
        }

        @Override
        public IValue visitBool(Type type) throws IOException {
            if (this.isNull()) {
                return this.inferNullValue(JsonValueReader.this.nulls, type);
            }
            return JsonValueReader.this.vf.bool(this.in.nextBoolean());
        }

        private int getPos() {
            if (JsonValueReader.this.src == null) {
                return 0;
            }
            try {
                return Math.max(0, JsonValueReader.this.posHandler.get(this.in) - 1);
            }
            catch (IllegalArgumentException | SecurityException e) {
                JsonValueReader.this.src = null;
                return 0;
            }
        }

        private int getLine() {
            if (JsonValueReader.this.src == null) {
                return 0;
            }
            try {
                return JsonValueReader.this.lineHandler.get(this.in) + 1;
            }
            catch (IllegalArgumentException | SecurityException e) {
                JsonValueReader.this.src = null;
                return 0;
            }
        }

        private int getCol() {
            if (JsonValueReader.this.src == null) {
                return 0;
            }
            try {
                return this.getPos() - JsonValueReader.this.lineStartHandler.get(this.in);
            }
            catch (IllegalArgumentException | SecurityException e) {
                JsonValueReader.this.src = null;
                return 0;
            }
        }

        protected Throw parseErrorHere(String cause) {
            ISourceLocation location = JsonValueReader.this.src == null ? URIUtil.rootLocation("unknown") : JsonValueReader.this.src;
            int offset = Math.max(this.getPos(), this.lastPos);
            int line = this.getLine();
            int col = this.getCol();
            return RuntimeExceptionFactory.jsonParseError(JsonValueReader.this.vf.sourceLocation(location, offset, 1, line, line, col, col + 1), cause, this.in.getPath());
        }

        private IValue visitNullAsAbstractData(Type type) {
            return this.inferNullValue(JsonValueReader.this.nulls, type);
        }

        private IValue visitStringAsAbstractData(Type type) throws IOException {
            String stringInput;
            block5: {
                stringInput = this.nextString();
                if (JsonValueReader.this.parsers != null) {
                    IConstructor reified = new TypeReifier(JsonValueReader.this.vf).typeToValue(type, new TypeStore(new TypeStore[0]), JsonValueReader.this.vf.map());
                    try {
                        return JsonValueReader.this.parsers.call(Collections.emptyMap(), reified, JsonValueReader.this.vf.string(stringInput));
                    }
                    catch (Throw t2) {
                        Type excType = t2.getException().getType();
                        if (!excType.isAbstractData() || !((IConstructor)t2.getException()).getConstructorType().getName().equals("ParseError")) break block5;
                        throw t2;
                    }
                }
            }
            Set<Type> enumCons = JsonValueReader.this.store.lookupConstructor(type, stringInput);
            for (Type candidate : enumCons) {
                if (candidate.getArity() != 0) continue;
                return JsonValueReader.this.vf.constructor(candidate);
            }
            if (JsonValueReader.this.parsers != null) {
                throw this.parseErrorHere("parser failed to recognize \"" + stringInput + "\" and no nullary constructor found for " + type + "either");
            }
            throw this.parseErrorHere("no nullary constructor found for " + type + ", that matches " + stringInput);
        }

        private IValue visitObjectAsAbstractData(Type type) throws IOException {
            Set<Type> alternatives = null;
            this.in.beginObject();
            int startPos = this.getPos();
            int startLine = this.getLine();
            int startCol = this.getCol();
            if (JsonValueReader.this.explicitConstructorNames || JsonValueReader.this.explicitDataTypes) {
                String consName = null;
                String typeName = null;
                String consLabel = this.nextName();
                if (JsonValueReader.this.explicitConstructorNames && "_constructor".equals(consLabel)) {
                    consName = this.in.nextString();
                } else if (JsonValueReader.this.explicitDataTypes && "_type".equals(consLabel)) {
                    typeName = this.in.nextString();
                }
                if (JsonValueReader.this.explicitDataTypes && typeName == null) {
                    consLabel = this.nextName();
                    if (JsonValueReader.this.explicitDataTypes && "_type".equals(consLabel)) {
                        typeName = this.in.nextString();
                    }
                } else if (JsonValueReader.this.explicitDataTypes && consName == null) {
                    consLabel = this.nextName();
                    if (JsonValueReader.this.explicitDataTypes && "_constructor".equals(consLabel)) {
                        consName = this.in.nextString();
                    }
                }
                if (JsonValueReader.this.explicitDataTypes && typeName == null) {
                    throw this.parseErrorHere("Missing a _type field: " + this.in.getPath());
                }
                if (JsonValueReader.this.explicitConstructorNames && consName == null) {
                    throw this.parseErrorHere("Missing a _constructor field: " + this.in.getPath());
                }
                if (typeName != null && consName != null) {
                    Type dataType = TF.abstractDataType(JsonValueReader.this.store, typeName, new Type[0]);
                    alternatives = JsonValueReader.this.store.lookupConstructor(dataType, consName);
                } else {
                    alternatives = JsonValueReader.this.store.lookupConstructors(consName);
                }
            } else {
                alternatives = JsonValueReader.this.store.lookupAlternatives(type);
            }
            if (alternatives.size() > 1) {
                JsonValueReader.this.monitor.warning("selecting arbitrary constructor for " + type, JsonValueReader.this.vf.sourceLocation(this.in.getPath()));
            } else if (alternatives.size() == 0) {
                throw this.parseErrorHere("No fitting constructor found for " + this.in.getPath());
            }
            Type cons = alternatives.iterator().next();
            IValue[] args = new IValue[cons.getArity()];
            HashMap<String, IValue> kwParams = new HashMap<String, IValue>();
            if (!cons.hasFieldNames() && cons.getArity() != 0) {
                throw this.parseErrorHere("For the object encoding constructors must have field names " + this.in.getPath());
            }
            while (this.in.hasNext()) {
                IValue val;
                String label = this.nextName();
                if (cons.hasField(label)) {
                    val = cons.getFieldType(label).accept(this);
                    if (val != null) {
                        args[cons.getFieldIndex((String)label)] = val;
                        continue;
                    }
                    throw this.parseErrorHere("Could not parse argument " + label + ":" + this.in.getPath());
                }
                if (cons.hasKeywordField(label, JsonValueReader.this.store)) {
                    if (!this.isNull()) {
                        val = JsonValueReader.this.store.getKeywordParameterType(cons, label).accept(this);
                        if (val == null) continue;
                        kwParams.put(label, val);
                        continue;
                    }
                    IValue nullValue = this.inferNullValue(JsonValueReader.this.nulls, cons.getAbstractDataType());
                    if (nullValue == null) continue;
                    kwParams.put(label, nullValue);
                    continue;
                }
                if (!JsonValueReader.this.explicitConstructorNames && "_constructor".equals(label)) {
                    this.in.nextString();
                    continue;
                }
                if (!JsonValueReader.this.explicitDataTypes && "_type".equals(label)) {
                    this.in.nextString();
                    continue;
                }
                throw this.parseErrorHere("Unknown field " + label + ":" + this.in.getPath());
            }
            this.in.endObject();
            int endPos = this.getPos();
            int endLine = this.getLine();
            int endCol = this.getCol();
            for (int i = 0; i < args.length; ++i) {
                if (args[i] != null) continue;
                throw this.parseErrorHere("Missing argument " + cons.getFieldName(i) + " to " + cons + ":" + this.in.getPath());
            }
            if (JsonValueReader.this.src != null) {
                kwParams.put(kwParams.containsKey("src") ? "rascal-src" : "src", JsonValueReader.this.vf.sourceLocation(JsonValueReader.this.src, startPos, endPos - startPos + 1, startLine, endLine, startCol, endCol + 1));
            }
            return JsonValueReader.this.vf.constructor(cons, args, kwParams);
        }

        @Override
        public IValue visitAbstractData(Type type) throws IOException {
            if (UtilMaybe.isMaybe(type)) {
                if (this.in.peek() == JsonToken.NULL) {
                    this.in.nextNull();
                    return UtilMaybe.nothing();
                }
                return UtilMaybe.just(type.getTypeParameters().getFieldType(0).accept(this));
            }
            switch (this.in.peek()) {
                case NULL: {
                    return this.visitNullAsAbstractData(type);
                }
                case STRING: {
                    return this.visitStringAsAbstractData(type);
                }
                case BEGIN_OBJECT: {
                    return this.visitObjectAsAbstractData(type);
                }
            }
            throw this.parseErrorHere("Expected ADT:" + type + ", but found " + this.in.peek().toString());
        }

        @Override
        public IValue visitConstructor(Type type) throws IOException {
            return type.getAbstractDataType().accept(this);
        }

        @Override
        public IValue visitNode(Type type) throws IOException {
            if (this.isNull()) {
                return this.inferNullValue(JsonValueReader.this.nulls, type);
            }
            this.in.beginObject();
            int startPos = this.getPos();
            int startLine = this.getLine();
            int startCol = this.getCol();
            HashMap<String, IValue> kws = new HashMap<String, IValue>();
            HashMap<String, IValue> args = new HashMap<String, IValue>();
            String name = "object";
            while (this.in.hasNext()) {
                String kwName = this.nextName();
                if (kwName.equals("_name")) {
                    name = ((IString)TF.stringType().accept(this)).getValue();
                    continue;
                }
                boolean positioned = kwName.startsWith("__arg");
                if (!this.isNull()) {
                    IValue val = TF.valueType().accept(this);
                    if (val == null) continue;
                    (positioned ? args : kws).put(kwName, val);
                    continue;
                }
                IValue nullValue = this.inferNullValue(JsonValueReader.this.nulls, TF.valueType());
                if (nullValue == null) continue;
                (positioned ? args : kws).put(kwName, nullValue);
            }
            this.in.endObject();
            int endPos = this.getPos();
            int endLine = this.getLine();
            int endCol = this.getCol();
            if (JsonValueReader.this.originTracking) {
                kws.put(kws.containsKey("src") ? "rascal-src" : "src", JsonValueReader.this.vf.sourceLocation(JsonValueReader.this.src, startPos, endPos - startPos + 1, startLine, endLine, startCol, endCol + 1));
            }
            IValue[] argArray = (IValue[])args.entrySet().stream().sorted((e, f) -> ((String)e.getKey()).compareTo((String)f.getKey())).filter(e -> e.getValue() != null).map(e -> (IValue)e.getValue()).toArray(IValue[]::new);
            return JsonValueReader.this.vf.node(name, argArray, kws);
        }

        @Override
        public IValue visitNumber(Type type) throws IOException {
            if (this.isNull()) {
                return this.inferNullValue(JsonValueReader.this.nulls, type);
            }
            if (this.in.peek() == JsonToken.BEGIN_ARRAY) {
                return this.visitRational(type);
            }
            String numberString = this.in.nextString();
            if (numberString.contains("r")) {
                return JsonValueReader.this.vf.rational(numberString);
            }
            if (numberString.matches(".*[\\.eE].*")) {
                return JsonValueReader.this.vf.real(numberString);
            }
            return JsonValueReader.this.vf.integer(numberString);
        }

        @Override
        public IValue visitParameter(Type type) throws IOException {
            return type.getBound().accept(this);
        }

        @Override
        public IValue visitDateTime(Type type) throws IOException {
            try {
                switch (this.in.peek()) {
                    case STRING: {
                        this.lastPos = this.getPos();
                        Date parsedDate = JsonValueReader.this.format.get().parse(this.nextString());
                        return JsonValueReader.this.vf.datetime(parsedDate.toInstant().toEpochMilli());
                    }
                    case NUMBER: {
                        return JsonValueReader.this.vf.datetime(this.in.nextLong());
                    }
                }
                throw this.parseErrorHere("Expected a datetime instant " + this.in.getPath());
            }
            catch (ParseException e) {
                throw this.parseErrorHere("Could not parse date: " + this.in.getPath());
            }
        }

        @Override
        public IValue visitList(Type type) throws IOException {
            if (this.isNull()) {
                return this.inferNullValue(JsonValueReader.this.nulls, type);
            }
            IListWriter w = JsonValueReader.this.vf.listWriter();
            this.in.beginArray();
            while (this.in.hasNext()) {
                IValue elem = this.isNull() ? this.inferNullValue(JsonValueReader.this.nulls, type.getElementType()) : type.getElementType().accept(this);
                if (elem == null) continue;
                w.append(elem);
            }
            this.in.endArray();
            return w.done();
        }

        @Override
        public IValue visitSet(Type type) throws IOException {
            if (this.isNull()) {
                return this.inferNullValue(JsonValueReader.this.nulls, type);
            }
            ISetWriter w = JsonValueReader.this.vf.setWriter();
            this.in.beginArray();
            while (this.in.hasNext()) {
                IValue elem = this.isNull() ? this.inferNullValue(JsonValueReader.this.nulls, type.getElementType()) : type.getElementType().accept(this);
                if (elem == null) continue;
                w.insert(elem);
            }
            this.in.endArray();
            return w.done();
        }

        private boolean isNull() throws IOException {
            if (this.in.peek() == JsonToken.NULL) {
                this.in.nextNull();
                return true;
            }
            return false;
        }
    }
}

