/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.gtd.stack;

import io.usethesource.vallang.IConstructor;
import java.util.Arrays;
import org.rascalmpl.parser.gtd.result.AbstractNode;
import org.rascalmpl.parser.gtd.result.struct.Link;
import org.rascalmpl.parser.gtd.stack.StackNodeVisitor;
import org.rascalmpl.parser.gtd.stack.edge.EdgesSet;
import org.rascalmpl.parser.gtd.stack.filter.ICompletionFilter;
import org.rascalmpl.parser.gtd.stack.filter.IEnterFilter;
import org.rascalmpl.parser.gtd.util.ArrayList;
import org.rascalmpl.parser.gtd.util.BitSet;
import org.rascalmpl.parser.gtd.util.IntegerList;
import org.rascalmpl.parser.gtd.util.IntegerObjectList;
import org.rascalmpl.parser.util.DebugUtil;

public abstract class AbstractStackNode<P> {
    public static final int START_SYMBOL_ID = -1;
    public static final int DEFAULT_START_LOCATION = -1;
    protected AbstractStackNode<P>[] production;
    protected AbstractStackNode<P>[][] alternateProductions;
    protected IntegerObjectList<EdgesSet<P>> edgesMap;
    protected ArrayList<Link>[] prefixesMap;
    protected EdgesSet<P> incomingEdges;
    protected final int id;
    protected final int dot;
    protected final int startLocation;
    private boolean isEndNode;
    private boolean isSeparator;
    private boolean isLayout;
    private final IEnterFilter[] enterFilters;
    private final ICompletionFilter[] completionFilters;
    private P alternativeProduction;
    private BitSet propagatedPrefixes;
    private IntegerList propagatedReductions;

    protected AbstractStackNode(int id, int dot) {
        this(id, dot, -1);
    }

    protected AbstractStackNode(int id, int dot, int startLocation) {
        this.id = id;
        this.dot = dot;
        this.startLocation = startLocation;
        this.enterFilters = null;
        this.completionFilters = null;
    }

    protected AbstractStackNode(int id, int dot, IEnterFilter[] enterFilters, ICompletionFilter[] completionFilters) {
        this.id = id;
        this.dot = dot;
        this.startLocation = -1;
        this.enterFilters = enterFilters;
        this.completionFilters = completionFilters;
    }

    protected AbstractStackNode(AbstractStackNode<P> original, int startLocation) {
        this(original.id, original, startLocation);
    }

    protected AbstractStackNode(int id, AbstractStackNode<P> original, int startLocation) {
        this.id = id;
        this.dot = original.dot;
        this.production = original.production;
        this.alternateProductions = original.alternateProductions;
        this.startLocation = startLocation;
        this.isEndNode = original.isEndNode;
        this.isSeparator = original.isSeparator;
        this.isLayout = original.isLayout;
        this.alternativeProduction = original.alternativeProduction;
        this.enterFilters = original.enterFilters;
        this.completionFilters = original.completionFilters;
    }

    public int getId() {
        return this.id;
    }

    public int getStartLocation() {
        return this.startLocation;
    }

    public boolean isEndNode() {
        return this.isEndNode;
    }

    public boolean isRecovered() {
        return false;
    }

    public void markAsSeparator() {
        this.isSeparator = true;
    }

    public boolean isSeparator() {
        return this.isSeparator;
    }

    public void markAsLayout() {
        this.isLayout = true;
    }

    public boolean isLayout() {
        return this.isLayout;
    }

    public boolean isMatchable() {
        return false;
    }

    public boolean isExpandable() {
        return false;
    }

    public abstract boolean isEmptyLeafNode();

    public abstract String getName();

    public abstract boolean isEqual(AbstractStackNode<P> var1);

    public void setAlternativeProduction(P parentProduction) {
        this.alternativeProduction = parentProduction;
        this.isEndNode = true;
    }

    public P getParentProduction() {
        return this.alternativeProduction;
    }

    public IEnterFilter[] getEnterFilters() {
        return this.enterFilters;
    }

    public ICompletionFilter[] getCompletionFilters() {
        return this.completionFilters;
    }

    public boolean hasEqualFilters(AbstractStackNode<P> otherNode) {
        ICompletionFilter[] otherCompletionFilters;
        IEnterFilter[] otherEnterFilters = otherNode.enterFilters;
        if (otherEnterFilters != null) {
            if (this.enterFilters == null || this.enterFilters.length != otherEnterFilters.length) {
                return false;
            }
            block0: for (int i = this.enterFilters.length - 1; i >= 0; --i) {
                IEnterFilter enterFilter = this.enterFilters[i];
                for (int j = otherEnterFilters.length - 1; j >= 0; --j) {
                    if (enterFilter.isEqual(otherEnterFilters[j])) continue block0;
                }
                return false;
            }
        } else if (this.enterFilters != null) {
            return false;
        }
        if ((otherCompletionFilters = otherNode.completionFilters) != null) {
            if (this.completionFilters == null || this.completionFilters.length != otherCompletionFilters.length) {
                return false;
            }
            block2: for (int i = this.completionFilters.length - 1; i >= 0; --i) {
                ICompletionFilter completionFilter = this.completionFilters[i];
                for (int j = otherCompletionFilters.length - 1; j >= 0; --j) {
                    if (completionFilter.isEqual(otherCompletionFilters[j])) continue block2;
                }
                return false;
            }
        } else if (this.completionFilters != null) {
            return false;
        }
        return true;
    }

    public abstract int hashCode();

    public boolean equals(Object o) {
        if (o instanceof AbstractStackNode) {
            return this.isEqual((AbstractStackNode)o);
        }
        return false;
    }

    public abstract AbstractStackNode<P> getCleanCopy(int var1);

    public abstract AbstractStackNode<P> getCleanCopyWithResult(int var1, AbstractNode var2);

    public boolean isSimilar(AbstractStackNode<P> node) {
        return node.id == this.id;
    }

    public int getDot() {
        return this.dot;
    }

    public void setProduction(AbstractStackNode<P>[] production) {
        this.production = production;
    }

    public void addProduction(AbstractStackNode<P>[] production) {
        if (this.production == null) {
            this.production = production;
        } else if (this.alternateProductions == null) {
            this.alternateProductions = new AbstractStackNode[][]{production};
        } else {
            int nrOfAlternateProductions = this.alternateProductions.length;
            AbstractStackNode[][] newAlternateProductions = new AbstractStackNode[nrOfAlternateProductions + 1][];
            System.arraycopy(this.alternateProductions, 0, newAlternateProductions, 0, nrOfAlternateProductions);
            newAlternateProductions[nrOfAlternateProductions] = production;
            this.alternateProductions = newAlternateProductions;
        }
    }

    public boolean hasNext() {
        return this.production != null && this.dot + 1 != this.production.length;
    }

    public AbstractStackNode<P>[] getProduction() {
        return this.production;
    }

    public AbstractStackNode<P>[][] getAlternateProductions() {
        return this.alternateProductions;
    }

    public void initEdges() {
        this.edgesMap = new IntegerObjectList();
    }

    public void setIncomingEdges(EdgesSet<P> incomingEdges) {
        this.incomingEdges = incomingEdges;
    }

    public EdgesSet<P> addEdge(AbstractStackNode<P> edge, int startLocation) {
        EdgesSet<P> edges = this.edgesMap.findValue(startLocation);
        if (edges == null) {
            edges = new EdgesSet(1);
            this.edgesMap.add(startLocation, edges);
        }
        edges.add(edge);
        return edges;
    }

    public void addEdges(EdgesSet<P> edges, int startLocation) {
        this.edgesMap.add(startLocation, edges);
    }

    public void setEdgesSetWithPrefix(EdgesSet<P> edges, Link prefix, int startLocation) {
        int edgesMapSize = this.edgesMap.size();
        if (this.prefixesMap == null) {
            this.prefixesMap = new ArrayList[edgesMapSize + 1 << 1];
        } else {
            int prefixesMapSize = this.prefixesMap.length;
            int possibleMaxSize = edgesMapSize + 1;
            if (prefixesMapSize < possibleMaxSize) {
                ArrayList<Link>[] oldPrefixesMap = this.prefixesMap;
                this.prefixesMap = new ArrayList[possibleMaxSize << 1];
                System.arraycopy(oldPrefixesMap, 0, this.prefixesMap, 0, edgesMapSize);
            }
        }
        this.edgesMap.add(startLocation, edges);
        ArrayList<Link> prefixes = this.prefixesMap[edgesMapSize];
        if (prefixes == null) {
            this.prefixesMap[edgesMapSize] = prefixes = new ArrayList(1);
        }
        prefixes.add(prefix);
    }

    private void addPrefix(Link prefix, int index) {
        ArrayList<Link> prefixes = this.prefixesMap[index];
        if (prefixes == null) {
            this.prefixesMap[index] = prefixes = new ArrayList(1);
        }
        prefixes.add(prefix);
    }

    public void updateNode(AbstractStackNode<P> predecessor, AbstractNode predecessorResult) {
        IntegerObjectList<EdgesSet<P>> edgesMapToAdd = predecessor.edgesMap;
        ArrayList<Link>[] prefixesMapToAdd = predecessor.prefixesMap;
        if (this.edgesMap == null) {
            this.edgesMap = new IntegerObjectList<EdgesSet<P>>(edgesMapToAdd);
            this.prefixesMap = new ArrayList[this.edgesMap.size()];
            if (prefixesMapToAdd == null) {
                int index = this.edgesMap.findKey(predecessor.getStartLocation());
                this.addPrefix(new Link(null, predecessorResult), index);
            } else {
                int nrOfPrefixes = edgesMapToAdd.size();
                for (int i = nrOfPrefixes - 1; i >= 0; --i) {
                    ArrayList<Link> prefixes = this.prefixesMap[i];
                    if (prefixes == null) {
                        this.prefixesMap[i] = prefixes = new ArrayList(1);
                    }
                    prefixes.add(new Link(prefixesMapToAdd[i], predecessorResult));
                }
            }
        } else if (this.edgesMap != edgesMapToAdd) {
            this.handleStackMergeForNonCyclicProduction(predecessorResult, edgesMapToAdd, prefixesMapToAdd);
        } else {
            this.handleStackMergeForSelfCyclicProduction(predecessor, predecessorResult, edgesMapToAdd, prefixesMapToAdd);
        }
    }

    private void handleStackMergeForSelfCyclicProduction(AbstractStackNode<P> predecessor, AbstractNode predecessorResult, IntegerObjectList<EdgesSet<P>> edgesMapToAdd, ArrayList<Link>[] prefixesMapToAdd) {
        if (prefixesMapToAdd == null) {
            int index = this.edgesMap.findKey(predecessor.getStartLocation());
            this.addPrefix(new Link(null, predecessorResult), index);
        } else {
            int nrOfPrefixes = edgesMapToAdd.size();
            for (int i = nrOfPrefixes - 1; i >= 0; --i) {
                this.prefixesMap[i].add(new Link(prefixesMapToAdd[i], predecessorResult));
            }
        }
    }

    private void handleStackMergeForNonCyclicProduction(AbstractNode predecessorResult, IntegerObjectList<EdgesSet<P>> edgesMapToAdd, ArrayList<Link>[] prefixesMapToAdd) {
        int edgesMapSize = this.edgesMap.size();
        int possibleMaxSize = edgesMapSize + edgesMapToAdd.size();
        if (this.prefixesMap == null) {
            this.prefixesMap = new ArrayList[possibleMaxSize];
        } else if (this.prefixesMap.length < possibleMaxSize) {
            ArrayList<Link>[] oldPrefixesMap = this.prefixesMap;
            this.prefixesMap = new ArrayList[possibleMaxSize];
            System.arraycopy(oldPrefixesMap, 0, this.prefixesMap, 0, edgesMapSize);
        }
        if (prefixesMapToAdd == null) {
            this.addPrefix(new Link(null, predecessorResult), edgesMapSize);
            this.edgesMap.add(edgesMapToAdd.getKey(0), edgesMapToAdd.getValue(0));
        } else {
            for (int i = edgesMapToAdd.size() - 1; i >= 0; --i) {
                ArrayList<Link> prefixes;
                int locationStart = edgesMapToAdd.getKey(i);
                int index = this.edgesMap.findKeyBefore(locationStart, edgesMapSize);
                if (index == -1) {
                    index = this.edgesMap.size();
                    this.edgesMap.add(locationStart, edgesMapToAdd.getValue(i));
                    this.prefixesMap[index] = prefixes = new ArrayList(1);
                } else {
                    prefixes = this.prefixesMap[index];
                }
                prefixes.add(new Link(prefixesMapToAdd[i], predecessorResult));
            }
        }
    }

    public void updateNodeAfterNonEmptyMatchable(AbstractStackNode<P> predecessor, AbstractNode result) {
        ArrayList<Link>[] prefixesMapToAdd = predecessor.prefixesMap;
        this.edgesMap = predecessor.edgesMap;
        this.prefixesMap = new ArrayList[this.edgesMap.size()];
        if (prefixesMapToAdd == null) {
            this.addPrefix(new Link(null, result), this.edgesMap.findKey(predecessor.getStartLocation()));
        } else {
            int nrOfPrefixes = this.edgesMap.size();
            for (int i = nrOfPrefixes - 1; i >= 0; --i) {
                ArrayList<Link> prefixes = new ArrayList<Link>(1);
                this.prefixesMap[i] = prefixes;
                prefixes.add(new Link(prefixesMapToAdd[i], result));
            }
        }
    }

    public int updateOvertakenNode(AbstractStackNode<P> predecessor, AbstractNode result) {
        IntegerObjectList<EdgesSet<P>> edgesMapToAdd = predecessor.edgesMap;
        ArrayList<Link>[] prefixesMapToAdd = predecessor.prefixesMap;
        int edgesMapSize = this.edgesMap.size();
        int possibleMaxSize = edgesMapSize + edgesMapToAdd.size();
        if (this.prefixesMap == null) {
            this.prefixesMap = new ArrayList[possibleMaxSize];
        } else if (this.prefixesMap.length < possibleMaxSize) {
            ArrayList<Link>[] oldPrefixesMap = this.prefixesMap;
            this.prefixesMap = new ArrayList[possibleMaxSize];
            System.arraycopy(oldPrefixesMap, 0, this.prefixesMap, 0, edgesMapSize);
        }
        int nrOfAddedEdges = 0;
        if (prefixesMapToAdd == null) {
            this.addPrefix(new Link(null, result), edgesMapSize);
            this.edgesMap.add(predecessor.getStartLocation(), edgesMapToAdd.getValue(0));
            nrOfAddedEdges = 1;
        } else {
            for (int i = edgesMapToAdd.size() - 1; i >= 0; --i) {
                ArrayList<Link> prefixes;
                int locationStart = edgesMapToAdd.getKey(i);
                int index = this.edgesMap.findKey(locationStart);
                if (index == -1) {
                    index = this.edgesMap.size();
                    this.edgesMap.add(locationStart, edgesMapToAdd.getValue(i));
                    this.prefixesMap[index] = prefixes = new ArrayList(1);
                    ++nrOfAddedEdges;
                } else {
                    prefixes = this.prefixesMap[index];
                }
                prefixes.add(new Link(prefixesMapToAdd[i], result));
            }
        }
        return nrOfAddedEdges;
    }

    public int updateOvertakenNullableNode(AbstractStackNode<P> predecessor, AbstractNode result, int potentialNewEdges) {
        IntegerObjectList<EdgesSet<P>> edgesMapToAdd = predecessor.edgesMap;
        ArrayList<Link>[] prefixesMapToAdd = predecessor.prefixesMap;
        int edgesMapSize = this.edgesMap.size();
        int possibleMaxSize = edgesMapSize + edgesMapToAdd.size();
        if (this.prefixesMap == null) {
            this.prefixesMap = new ArrayList[possibleMaxSize];
            this.propagatedPrefixes = new BitSet(edgesMapSize);
        } else {
            if (this.prefixesMap.length < possibleMaxSize) {
                ArrayList<Link>[] oldPrefixesMap = this.prefixesMap;
                this.prefixesMap = new ArrayList[possibleMaxSize];
                System.arraycopy(oldPrefixesMap, 0, this.prefixesMap, 0, edgesMapSize);
            }
            if (this.propagatedPrefixes == null) {
                this.propagatedPrefixes = new BitSet(possibleMaxSize);
            } else {
                this.propagatedPrefixes.enlargeTo(possibleMaxSize);
            }
        }
        int nrOfAddedEdges = 0;
        if (prefixesMapToAdd == null) {
            this.addPrefix(new Link(null, result), edgesMapSize);
            this.edgesMap.add(predecessor.getStartLocation(), edgesMapToAdd.getValue(0));
            nrOfAddedEdges = 1;
        } else {
            for (int i = edgesMapToAdd.size() - 1; i >= 0; --i) {
                ArrayList<Link> prefixes;
                int locationStart = edgesMapToAdd.getKey(i);
                int index = this.edgesMap.findKey(locationStart);
                if (index == -1) {
                    index = this.edgesMap.size();
                    this.edgesMap.add(locationStart, edgesMapToAdd.getValue(i));
                    this.propagatedPrefixes.set(index);
                    this.prefixesMap[index] = prefixes = new ArrayList(1);
                    ++nrOfAddedEdges;
                } else {
                    if (this.propagatedPrefixes.isSet(index)) continue;
                    prefixes = this.prefixesMap[index];
                }
                prefixes.add(new Link(prefixesMapToAdd[i], result));
            }
        }
        return nrOfAddedEdges;
    }

    public void updatePrefixSharedNode(IntegerObjectList<EdgesSet<P>> edgesMap, ArrayList<Link>[] prefixesMap) {
        this.edgesMap = edgesMap;
        this.prefixesMap = prefixesMap;
    }

    public IntegerObjectList<EdgesSet<P>> getEdges() {
        return this.edgesMap;
    }

    public EdgesSet<P> getIncomingEdges() {
        return this.incomingEdges;
    }

    public ArrayList<Link>[] getPrefixesMap() {
        return this.prefixesMap;
    }

    public IntegerList getPropagatedReductions() {
        if (this.propagatedReductions == null) {
            this.propagatedReductions = new IntegerList();
        }
        return this.propagatedReductions;
    }

    public abstract String toShortString();

    public String toString() {
        StringBuilder builder = new StringBuilder(this.id + "." + this.dot + "@" + this.startLocation);
        if (this.production != null) {
            builder.append(",prod=[");
            boolean first = true;
            for (AbstractStackNode<P> prodElem : this.production) {
                if (first) {
                    first = false;
                } else {
                    builder.append(",");
                }
                builder.append(prodElem.toShortString());
            }
            builder.append("]");
        }
        if (this.isEndNode) {
            builder.append(",endNode");
        }
        if (this.isSeparator) {
            builder.append(",separator");
        }
        if (this.isLayout) {
            builder.append(",layout");
        }
        if (this.alternateProductions != null && this.alternateProductions.length != 0) {
            builder.append(",alternateProductions=" + Arrays.toString(this.alternateProductions));
        }
        if (this.prefixesMap != null && this.prefixesMap.length != 0) {
            builder.append(",prefixes=" + Arrays.toString(this.prefixesMap));
        }
        if (this.incomingEdges != null && this.incomingEdges.size() != 0) {
            builder.append(",incomingEdges=" + this.incomingEdges);
        }
        if (this.alternativeProduction != null) {
            builder.append(",alternativeProduction=" + DebugUtil.prodToString((IConstructor)this.alternativeProduction));
        }
        if (this.propagatedPrefixes != null) {
            builder.append(",propagatedPrefixes=" + this.propagatedPrefixes);
        }
        if (this.propagatedReductions != null) {
            builder.append(",propagatedReductions=" + this.propagatedReductions);
        }
        return builder.toString();
    }

    public abstract <R> R accept(StackNodeVisitor<P, R> var1);

    public abstract AbstractNode match(int[] var1, int var2);

    public abstract int getLength();

    public abstract AbstractNode getResult();

    public abstract AbstractStackNode<P>[] getChildren();

    public abstract boolean canBeEmpty();

    public abstract AbstractStackNode<P> getEmptyChild();
}

