/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.gtd.stack;

import java.net.URI;
import org.rascalmpl.parser.gtd.result.AbstractNode;
import org.rascalmpl.parser.gtd.result.SkippedNode;
import org.rascalmpl.parser.gtd.stack.AbstractMatchableStackNode;
import org.rascalmpl.parser.gtd.stack.AbstractStackNode;
import org.rascalmpl.parser.gtd.stack.StackNodeVisitor;

public final class SkippingStackNode<P>
extends AbstractMatchableStackNode<P> {
    private final SkippedNode result;

    public static SkippedNode createResultUntilCharClass(URI uri, int[] until, int[] input, int startLocation, int errorPosition) {
        for (int to = startLocation; to < input.length; ++to) {
            for (int i = 0; i < until.length; ++i) {
                if (input[to] != until[i]) continue;
                int length = to - startLocation;
                return new SkippedNode(uri, SkippingStackNode.createSkippedToken(input, startLocation, length), startLocation, errorPosition);
            }
        }
        return new SkippedNode(uri, new int[0], startLocation, errorPosition);
    }

    public static SkippedNode createResultUntilEndOfInput(URI uri, int[] input, int startLocation, int errorPosition) {
        int length = input.length - startLocation;
        return new SkippedNode(uri, SkippingStackNode.createSkippedToken(input, startLocation, length), startLocation, errorPosition);
    }

    public static SkippedNode createResultUntilChar(URI uri, int[] input, int startLocation, int endLocation, int errorPosition) {
        return new SkippedNode(uri, SkippingStackNode.createSkippedToken(input, startLocation, endLocation - startLocation), startLocation, errorPosition);
    }

    private static int[] createSkippedToken(int[] input, int startLocation, int length) {
        int[] token = new int[length];
        System.arraycopy(input, startLocation, token, 0, length);
        return token;
    }

    public SkippingStackNode(int id, P parentProduction, SkippedNode result) {
        super(id, 0);
        this.result = result;
        this.setAlternativeProduction(parentProduction);
    }

    public SkippingStackNode(int id, P parentProduction, SkippedNode result, int startLocation) {
        super(id, 0, startLocation);
        this.result = result;
        this.setAlternativeProduction(parentProduction);
    }

    private SkippingStackNode(SkippingStackNode<P> original, int startLocation) {
        super(original, startLocation);
        this.result = original.result;
    }

    private SkippingStackNode(SkippingStackNode<P> original, SkippedNode result, int startLocation) {
        super(original, startLocation);
        this.result = result;
    }

    @Override
    public boolean isEmptyLeafNode() {
        return this.result.isEmpty();
    }

    @Override
    public AbstractNode match(int[] input, int location) {
        return this.result;
    }

    @Override
    public AbstractStackNode<P> getCleanCopy(int startLocation) {
        return new SkippingStackNode<P>(this, startLocation);
    }

    @Override
    public AbstractStackNode<P> getCleanCopyWithResult(int startLocation, AbstractNode result) {
        return new SkippingStackNode<P>(this, (SkippedNode)result, startLocation);
    }

    @Override
    public int getLength() {
        return this.result.getLength();
    }

    @Override
    public AbstractNode getResult() {
        return this.result;
    }

    @Override
    public String toShortString() {
        return "skip(" + this.result.toString() + ")";
    }

    @Override
    public String toString() {
        return "SkippingStackNode[result=" + this.result + "," + super.toString() + "]";
    }

    @Override
    public int hashCode() {
        return this.getParentProduction().hashCode();
    }

    @Override
    public boolean equals(Object rhs) {
        return super.equals(rhs);
    }

    @Override
    public boolean isEqual(AbstractStackNode<P> stackNode) {
        if (!(stackNode instanceof SkippingStackNode)) {
            return false;
        }
        SkippingStackNode otherNode = (SkippingStackNode)stackNode;
        return otherNode.id == this.id;
    }

    @Override
    public <R> R accept(StackNodeVisitor<P, R> visitor) {
        return visitor.visit(this);
    }
}

