/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.gtd.util;

public class IntegerList {
    private static final int DEFAULT_SIZE = 8;
    private int[] data;
    private int size;

    public IntegerList() {
        this.data = new int[8];
        this.size = 0;
    }

    public IntegerList(int initialSize) {
        this.data = new int[initialSize];
        this.size = 0;
    }

    public void enlarge() {
        int[] oldData = this.data;
        this.data = new int[this.size << 1];
        System.arraycopy(oldData, 0, this.data, 0, this.size);
    }

    public void add(int integer) {
        while (this.size >= this.data.length) {
            this.enlarge();
        }
        this.data[this.size++] = integer;
    }

    public int get(int index) {
        return this.data[index];
    }

    public boolean contains(int integer) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (this.data[i] != integer) continue;
            return true;
        }
        return false;
    }

    public boolean containsBefore(int integer, int limit) {
        for (int i = limit - 1; i >= 0; --i) {
            if (this.data[i] != integer) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.size = 0;
    }

    public int[] getBackingArray() {
        return this.data;
    }
}

