/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.repl.completers;

import java.util.List;
import java.util.function.Function;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;
import org.rascalmpl.repl.completers.RascalQualifiedNames;

public class RascalModuleCompletion
implements Completer {
    private final Function<String, List<String>> searchPathLookup;

    public RascalModuleCompletion(Function<String, List<String>> searchPathLookup) {
        this.searchPathLookup = searchPathLookup;
    }

    @Override
    public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
        if (line.wordIndex() != 1) {
            return;
        }
        switch (line.words().get(0)) {
            case "import": 
            case "extend": {
                this.completeModuleNames(line.word(), candidates, true);
                return;
            }
        }
    }

    public void completeModuleNames(String word, List<Candidate> candidates, boolean importStatement) {
        int rootedIndex = (word = RascalQualifiedNames.unescape(word)).lastIndexOf("::");
        String moduleRoot = rootedIndex == -1 ? "" : word.substring(0, rootedIndex);
        Object modulePrefix = moduleRoot.isEmpty() ? "" : moduleRoot + "::";
        for (String mod : this.searchPathLookup.apply(moduleRoot)) {
            String fullPath = RascalQualifiedNames.escape((String)modulePrefix + mod);
            boolean isFullModulePath = !mod.endsWith("::");
            candidates.add(new Candidate(fullPath + (isFullModulePath & importStatement ? ";" : ""), fullPath, "modules", null, null, null, false));
        }
    }
}

