/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.repl.http;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import io.usethesource.vallang.IValue;
import java.io.IOException;
import java.util.Map;
import java.util.function.Function;
import org.rascalmpl.repl.http.REPLContentServer;

public class REPLContentServerManager {
    private static final int MAX_SERVER_COUNT = 125;
    private static final long HALFHOUR = 1800000L;
    private final Cache<String, REPLContentServer> servers = Caffeine.newBuilder().maximumSize(125L).removalListener(REPLContentServerManager::cleanupServer).build();

    private static void cleanupServer(String contentId, REPLContentServer server, RemovalCause cause) {
        server.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public REPLContentServer addServer(String id, Function<IValue, IValue> target) throws IOException {
        try {
            REPLContentServer oldServer = this.servers.get(id, i -> null);
            if (oldServer != null) {
                oldServer.updateCallback(target);
                REPLContentServer rEPLContentServer = oldServer;
                return rEPLContentServer;
            }
            REPLContentServer newServer = this.startContentServer(target);
            this.servers.put(id, newServer);
            REPLContentServer rEPLContentServer = newServer;
            return rEPLContentServer;
        }
        finally {
            this.collectDeadServers();
        }
    }

    private void collectDeadServers() {
        long now = System.currentTimeMillis();
        for (Map.Entry entry : this.servers.asMap().entrySet()) {
            REPLContentServer server = (REPLContentServer)entry.getValue();
            String contentId = (String)entry.getKey();
            if (server.getLastServedAt() >= now - 1800000L) continue;
            this.servers.invalidate(contentId);
        }
    }

    private REPLContentServer startContentServer(Function<IValue, IValue> target) throws IOException {
        REPLContentServer server = null;
        for (int port = 9050; port < 9175; ++port) {
            try {
                server = new REPLContentServer(port, target);
                server.start();
                break;
            }
            catch (IOException e) {
                continue;
            }
        }
        if (server == null) {
            throw new IOException("Could not find port to run single page server on");
        }
        return server;
    }
}

