/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.uri;

import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISetWriter;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.rascalmpl.library.Prelude;
import org.rascalmpl.unicode.UnicodeDetector;
import org.rascalmpl.unicode.UnicodeInputStreamReader;
import org.rascalmpl.unicode.UnicodeOffsetLengthReader;
import org.rascalmpl.unicode.UnicodeOutputStreamWriter;
import org.rascalmpl.uri.FileAttributes;
import org.rascalmpl.uri.ILogicalSourceLocationResolver;
import org.rascalmpl.uri.ISourceLocationInput;
import org.rascalmpl.uri.ISourceLocationOutput;
import org.rascalmpl.uri.ISourceLocationWatcher;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.uri.UnsupportedSchemeException;
import org.rascalmpl.uri.classloaders.IClassloaderLocationResolver;
import org.rascalmpl.uri.watch.WatchRegistry;
import org.rascalmpl.values.IRascalValueFactory;
import org.rascalmpl.values.ValueFactoryFactory;

public class URIResolverRegistry {
    private static final int FILE_BUFFER_SIZE = 8192;
    private static final String RESOLVERS_CONFIG = "org/rascalmpl/uri/resolvers.config";
    private static final IValueFactory vf = ValueFactoryFactory.getValueFactory();
    private final Map<String, ISourceLocationInput> inputResolvers = new ConcurrentHashMap<String, ISourceLocationInput>();
    private final Map<String, ISourceLocationOutput> outputResolvers = new ConcurrentHashMap<String, ISourceLocationOutput>();
    private final Map<String, Map<String, ILogicalSourceLocationResolver>> logicalResolvers = new ConcurrentHashMap<String, Map<String, ILogicalSourceLocationResolver>>();
    private final Map<String, IClassloaderLocationResolver> classloaderResolvers = new ConcurrentHashMap<String, IClassloaderLocationResolver>();
    private volatile @Nullable ISourceLocationInput fallbackInputResolver;
    private volatile @Nullable ISourceLocationOutput fallbackOutputResolver;
    private volatile @Nullable ILogicalSourceLocationResolver fallbackLogicalResolver;
    private volatile @Nullable IClassloaderLocationResolver fallbackClassloaderResolver;
    private final WatchRegistry watchers;
    private static final Pattern splitScheme = Pattern.compile("^([^\\+]*)\\+");
    private final TypeFactory tf = TypeFactory.getInstance();
    private final TypeStore capabilitiesStore = new TypeStore(new TypeStore[0]);
    private final Type IOcapability = this.tf.abstractDataType(this.capabilitiesStore, "IOCapability", new Type[0]);
    private final Type readCap = this.tf.constructor(this.capabilitiesStore, this.IOcapability, "reading", new Type[0]);
    private final Type writeCap = this.tf.constructor(this.capabilitiesStore, this.IOcapability, "writing", new Type[0]);
    private final Type loadCap = this.tf.constructor(this.capabilitiesStore, this.IOcapability, "classloading", new Type[0]);
    private final Type logicalCap = this.tf.constructor(this.capabilitiesStore, this.IOcapability, "resolving", new Type[0]);
    private final Type watchCap = this.tf.constructor(this.capabilitiesStore, this.IOcapability, "watching", new Type[0]);

    private URIResolverRegistry() {
        this.watchers = new WatchRegistry(this, this::safeResolve);
        this.loadServices();
    }

    public void reinitialize() {
        this.loadServices();
    }

    private void loadServices() {
        try {
            Enumeration<URL> resources = this.getClass().getClassLoader().getResources(RESOLVERS_CONFIG);
            Collections.list(resources).forEach(f -> this.loadServices((URL)f));
            String fallbackResolverClassName = System.getProperty("rascal.fallbackResolver");
            if (fallbackResolverClassName != null) {
                this.loadFallback(fallbackResolverClassName);
            }
        }
        catch (IOException e) {
            throw new Error("WARNING: Could not load URIResolverRegistry extensions from org/rascalmpl/uri/resolvers.config", e);
        }
    }

    public Set<String> getRegisteredInputSchemes() {
        return Collections.unmodifiableSet(this.inputResolvers.keySet());
    }

    public Set<String> getRegisteredOutputSchemes() {
        return Collections.unmodifiableSet(this.outputResolvers.keySet());
    }

    public Set<String> getRegisteredLogicalSchemes() {
        return Collections.unmodifiableSet(this.logicalResolvers.keySet());
    }

    public Set<String> getRegisteredClassloaderSchemes() {
        return Collections.unmodifiableSet(this.classloaderResolvers.keySet());
    }

    private Object constructService(String name) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, SecurityException {
        Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(name);
        try {
            return clazz.getDeclaredConstructor(URIResolverRegistry.class).newInstance(this);
        }
        catch (NoSuchMethodException e) {
            return clazz.newInstance();
        }
    }

    private void loadFallback(String fallbackClass) {
        try {
            Object instance = this.constructService(fallbackClass);
            boolean ok = false;
            if (instance instanceof ILogicalSourceLocationResolver) {
                this.fallbackLogicalResolver = (ILogicalSourceLocationResolver)instance;
                ok = true;
            }
            if (instance instanceof ISourceLocationInput) {
                this.fallbackInputResolver = (ISourceLocationInput)instance;
                ok = true;
            }
            if (instance instanceof ISourceLocationOutput) {
                this.fallbackOutputResolver = (ISourceLocationOutput)instance;
                ok = true;
            }
            if (instance instanceof IClassloaderLocationResolver) {
                this.fallbackClassloaderResolver = (IClassloaderLocationResolver)instance;
                ok = true;
            }
            if (instance instanceof ISourceLocationWatcher) {
                this.watchers.setFallback((ISourceLocationWatcher)instance);
            }
            if (!ok) {
                System.err.println("WARNING: could not load fallback resolver " + fallbackClass + " because it does not implement ISourceLocationInput or ISourceLocationOutput or ILogicalSourceLocationResolver");
            }
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
            System.err.println("WARNING: could not load resolver due to " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void loadServices(URL nextElement) {
        try {
            for (String name : this.readConfigFile(nextElement)) {
                if ((name = name.trim()).startsWith("#") || name.isEmpty()) continue;
                Object instance = this.constructService(name);
                boolean ok = false;
                if (instance instanceof ILogicalSourceLocationResolver) {
                    this.registerLogical((ILogicalSourceLocationResolver)instance);
                    ok = true;
                }
                if (instance instanceof ISourceLocationInput) {
                    this.registerInput((ISourceLocationInput)instance);
                    ok = true;
                }
                if (instance instanceof ISourceLocationOutput) {
                    this.registerOutput((ISourceLocationOutput)instance);
                    ok = true;
                }
                if (instance instanceof IClassloaderLocationResolver) {
                    this.registerClassloader((IClassloaderLocationResolver)instance);
                    ok = true;
                }
                if (instance instanceof ISourceLocationWatcher) {
                    this.registerWatcher((ISourceLocationWatcher)instance);
                }
                if (ok) continue;
                System.err.println("WARNING: could not load resolver " + name + " because it does not implement ISourceLocationInput or ISourceLocationOutput or ILogicalSourceLocationResolver");
            }
        }
        catch (IOException | ClassCastException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
            System.err.println("WARNING: could not load resolver due to " + e.getMessage());
            e.printStackTrace();
        }
    }

    private String[] readConfigFile(URL nextElement) throws IOException {
        try (InputStreamReader in = new InputStreamReader(nextElement.openStream());){
            int read;
            StringBuilder res = new StringBuilder();
            char[] chunk = new char[1024];
            while ((read = ((Reader)in).read(chunk, 0, chunk.length)) != -1) {
                res.append(chunk, 0, read);
            }
            String[] stringArray = res.toString().split("\n");
            return stringArray;
        }
    }

    public static URIResolverRegistry getInstance() {
        return InstanceHolder.sInstance;
    }

    private static InputStream makeBuffered(InputStream original) {
        if (original instanceof BufferedInputStream || original instanceof ByteArrayInputStream) {
            return original;
        }
        return new BufferedInputStream(original);
    }

    private OutputStream makeBuffered(ISourceLocation loc, boolean existed, OutputStream original) {
        if (original instanceof NotifyingOutputStream) {
            return original;
        }
        if (original instanceof BufferedOutputStream || original instanceof ByteArrayOutputStream) {
            return new NotifyingOutputStream(original, loc, existed ? ISourceLocationWatcher.modified(loc) : ISourceLocationWatcher.created(loc));
        }
        return new NotifyingOutputStream(new BufferedOutputStream(original), loc, existed ? ISourceLocationWatcher.modified(loc) : ISourceLocationWatcher.created(loc));
    }

    public ISourceLocation logicalToPhysical(ISourceLocation loc) throws IOException {
        ISourceLocation result = this.physicalLocation(loc);
        if (result == null) {
            throw new FileNotFoundException(loc == null ? "null loc passed!" : loc.toString());
        }
        return result;
    }

    private static ISourceLocation resolveAndFixOffsets(ISourceLocation loc, ILogicalSourceLocationResolver resolver, Iterable<ILogicalSourceLocationResolver> backups) throws IOException {
        ISourceLocation prev = loc;
        boolean removedOffset = false;
        if (resolver != null) {
            loc = resolver.resolve(loc);
        }
        if (loc == null && prev.hasOffsetLength()) {
            loc = resolver.resolve(URIUtil.removeOffset(prev));
            removedOffset = true;
        }
        if (loc == null || prev.equals(loc)) {
            for (ILogicalSourceLocationResolver backup : backups) {
                removedOffset = false;
                loc = backup.resolve(prev);
                if (loc == null && prev.hasOffsetLength()) {
                    loc = backup.resolve(URIUtil.removeOffset(prev));
                    removedOffset = true;
                }
                if (loc == null || prev.equals(loc)) continue;
                break;
            }
        }
        if (loc == null || prev.equals(loc)) {
            return null;
        }
        if (removedOffset || !loc.hasOffsetLength()) {
            if (prev.hasLineColumn()) {
                return vf.sourceLocation(loc, prev.getOffset(), prev.getLength(), prev.getBeginLine(), prev.getEndLine(), prev.getBeginColumn(), prev.getEndColumn());
            }
            if (prev.hasOffsetLength()) {
                if (loc.hasOffsetLength()) {
                    return vf.sourceLocation(loc, prev.getOffset() + loc.getOffset(), prev.getLength());
                }
                return vf.sourceLocation(loc, prev.getOffset(), prev.getLength());
            }
        } else if (loc.hasLineColumn()) {
            if (prev.hasLineColumn()) {
                return vf.sourceLocation(loc, loc.getOffset() + prev.getOffset(), loc.getLength(), loc.getBeginLine() + prev.getBeginLine() - 1, loc.getEndLine() + prev.getEndLine() - 1, loc.getBeginColumn(), loc.getEndColumn());
            }
            if (prev.hasOffsetLength()) {
                return vf.sourceLocation(loc, loc.getOffset() + prev.getOffset(), loc.getLength());
            }
        } else if (loc.hasOffsetLength() && prev.hasOffsetLength()) {
            return vf.sourceLocation(loc, loc.getOffset() + prev.getOffset(), loc.getLength());
        }
        return loc;
    }

    private ISourceLocation physicalLocation(ISourceLocation loc) throws IOException {
        ISourceLocation original = loc;
        while (loc != null && this.logicalResolvers.containsKey(loc.getScheme())) {
            Map<String, ILogicalSourceLocationResolver> map = this.logicalResolvers.get(loc.getScheme());
            String auth = loc.hasAuthority() ? loc.getAuthority() : "";
            ILogicalSourceLocationResolver resolver = map.get(auth);
            loc = URIResolverRegistry.resolveAndFixOffsets(loc, resolver, map.values());
        }
        if (this.fallbackLogicalResolver != null) {
            ISourceLocation fallbackResult = URIResolverRegistry.resolveAndFixOffsets(loc == null ? original : loc, this.fallbackLogicalResolver, Collections.emptyList());
            return fallbackResult == null ? loc : fallbackResult;
        }
        return loc;
    }

    private @NonNull ISourceLocation safeResolve(@NonNull ISourceLocation loc) {
        ISourceLocation resolved = null;
        try {
            resolved = this.physicalLocation(loc);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return resolved != null ? resolved : loc;
    }

    private void registerInput(ISourceLocationInput resolver) {
        this.inputResolvers.put(resolver.scheme(), resolver);
    }

    private void registerOutput(ISourceLocationOutput resolver) {
        this.outputResolvers.put(resolver.scheme(), resolver);
    }

    public void registerLogical(ILogicalSourceLocationResolver resolver) {
        Map map = this.logicalResolvers.computeIfAbsent(resolver.scheme(), k -> new ConcurrentHashMap());
        map.put(resolver.authority(), resolver);
    }

    private void registerClassloader(IClassloaderLocationResolver resolver) {
        this.classloaderResolvers.put(resolver.scheme(), resolver);
    }

    private void registerWatcher(ISourceLocationWatcher resolver) {
        this.watchers.registerNative(resolver.scheme(), resolver);
    }

    public void unregisterLogical(String scheme, String auth) {
        Map<String, ILogicalSourceLocationResolver> map = this.logicalResolvers.get(scheme);
        if (map != null) {
            map.remove(auth);
        }
    }

    private ISourceLocationInput getInputResolver(String scheme) {
        ISourceLocationInput result = this.inputResolvers.get(scheme);
        if (result == null) {
            String subScheme;
            Matcher m4 = splitScheme.matcher(scheme);
            if (m4.find() && (result = this.inputResolvers.get(subScheme = m4.group(1))) != null) {
                return result;
            }
            return this.fallbackInputResolver;
        }
        return result;
    }

    private IClassloaderLocationResolver getClassloaderResolver(String scheme) {
        IClassloaderLocationResolver result = this.classloaderResolvers.get(scheme);
        if (result == null) {
            String subScheme;
            Matcher m4 = splitScheme.matcher(scheme);
            if (m4.find() && (result = this.classloaderResolvers.get(subScheme = m4.group(1))) != null) {
                return result;
            }
            return this.fallbackClassloaderResolver;
        }
        return result;
    }

    private ISourceLocationOutput getOutputResolver(String scheme) {
        ISourceLocationOutput result = this.outputResolvers.get(scheme);
        if (result == null) {
            String subScheme;
            Matcher m4 = splitScheme.matcher(scheme);
            if (m4.find() && (result = this.outputResolvers.get(subScheme = m4.group(1))) != null) {
                return result;
            }
            return this.fallbackOutputResolver;
        }
        return result;
    }

    public boolean supportsHost(ISourceLocation uri) {
        ISourceLocationInput resolver = this.getInputResolver((uri = this.safeResolve(uri)).getScheme());
        if (resolver == null) {
            ISourceLocationOutput resolverOther = this.getOutputResolver(uri.getScheme());
            if (resolverOther == null) {
                return false;
            }
            return resolverOther.supportsHost();
        }
        return resolver.supportsHost();
    }

    public boolean supportsReadableFileChannel(ISourceLocation uri) {
        ISourceLocationInput resolver = this.getInputResolver((uri = this.safeResolve(uri)).getScheme());
        if (resolver == null) {
            return false;
        }
        return resolver.supportsReadableFileChannel();
    }

    public boolean supportsWritableFileChannel(ISourceLocation uri) {
        ISourceLocationOutput resolver = this.getOutputResolver((uri = this.safeResolve(uri)).getScheme());
        if (resolver == null) {
            return false;
        }
        return resolver.supportsWritableFileChannel();
    }

    public boolean exists(ISourceLocation uri) {
        ISourceLocationInput resolver = this.getInputResolver((uri = this.safeResolve(uri)).getScheme());
        if (resolver == null) {
            return false;
        }
        return resolver.exists(uri);
    }

    public void setLastModified(ISourceLocation uri, long timestamp) throws IOException {
        ISourceLocationOutput resolver = this.getOutputResolver((uri = this.safeResolve(uri)).getScheme());
        if (resolver == null) {
            throw new FileNotFoundException(uri.toString());
        }
        resolver.setLastModified(uri, timestamp);
    }

    public boolean isDirectory(ISourceLocation uri) {
        ISourceLocationInput resolver = this.getInputResolver((uri = this.safeResolve(uri)).getScheme());
        if (resolver == null) {
            return false;
        }
        return resolver.isDirectory(uri);
    }

    public void mkDirectory(ISourceLocation uri) throws IOException {
        ISourceLocationOutput resolver = this.getOutputResolver((uri = this.safeResolve(uri)).getScheme());
        if (resolver == null) {
            throw new UnsupportedSchemeException(uri.getScheme());
        }
        this.mkParentDir(uri);
        resolver.mkDirectory(uri);
        this.notifyWatcher(URIUtil.getParentLocation(uri), ISourceLocationWatcher.created(uri));
    }

    private void notifyWatcher(ISourceLocation key, ISourceLocationWatcher.ISourceLocationChanged event) {
        this.watchers.notifySimulatedWatchers(key, event);
    }

    public void remove(ISourceLocation uri, boolean recursive) throws IOException {
        ISourceLocationOutput out = this.getOutputResolver((uri = this.safeResolve(uri)).getScheme());
        if (out == null) {
            throw new UnsupportedSchemeException(uri.getScheme());
        }
        boolean isDir = this.isDirectory(uri);
        if (isDir) {
            if (recursive) {
                for (ISourceLocation element : this.list(uri)) {
                    this.remove(element, recursive);
                }
            } else if (this.listEntries(uri).length != 0) {
                throw new IOException("directory is not empty " + uri);
            }
        }
        out.remove(uri);
        this.notifyWatcher(uri, ISourceLocationWatcher.deleted(uri));
    }

    public void rename(ISourceLocation from, ISourceLocation to, boolean overwrite) throws IOException {
        from = this.safeResolve(from);
        to = this.safeResolve(to);
        if (from.getScheme().equals(to.getScheme())) {
            ISourceLocationOutput out = this.getOutputResolver(from.getScheme());
            if (out == null) {
                throw new UnsupportedSchemeException(from.getScheme());
            }
            out.rename(from, to, overwrite);
        } else {
            this.copy(from, to, true, overwrite);
            this.remove(from, true);
        }
    }

    public boolean isFile(ISourceLocation uri) {
        ISourceLocationInput resolver = this.getInputResolver((uri = this.safeResolve(uri)).getScheme());
        if (resolver == null) {
            return false;
        }
        return resolver.isFile(uri);
    }

    public long lastModified(ISourceLocation uri) throws IOException {
        ISourceLocationInput resolver = this.getInputResolver((uri = this.safeResolve(uri)).getScheme());
        if (resolver == null) {
            throw new UnsupportedSchemeException(uri.getScheme());
        }
        long result = resolver.lastModified(uri);
        if (result == 0L) {
            throw new FileNotFoundException(uri.toString());
        }
        return result;
    }

    public long created(ISourceLocation uri) throws IOException {
        ISourceLocationInput resolver = this.getInputResolver((uri = this.safeResolve(uri)).getScheme());
        if (resolver == null) {
            throw new UnsupportedSchemeException(uri.getScheme());
        }
        long result = resolver.created(uri);
        if (result == 0L) {
            throw new FileNotFoundException(uri.toString());
        }
        return result;
    }

    public boolean isWritable(ISourceLocation uri) throws IOException {
        ISourceLocationOutput resolver = this.getOutputResolver((uri = this.safeResolve(uri)).getScheme());
        if (resolver != null) {
            return resolver.isWritable(uri);
        }
        if (!this.exists(uri)) {
            throw new FileNotFoundException(uri.toString());
        }
        return false;
    }

    public boolean isReadable(ISourceLocation uri) throws IOException {
        ISourceLocationInput resolver = this.getInputResolver((uri = this.safeResolve(uri)).getScheme());
        if (resolver == null) {
            throw new UnsupportedSchemeException(uri.getScheme());
        }
        return resolver.isReadable(uri);
    }

    public long size(ISourceLocation uri) throws IOException {
        ISourceLocationInput resolver = this.getInputResolver((uri = this.safeResolve(uri)).getScheme());
        if (resolver == null) {
            throw new UnsupportedSchemeException(uri.getScheme());
        }
        return resolver.size(uri);
    }

    private boolean isRootLogical(ISourceLocation uri) {
        return uri.getAuthority().isEmpty() && uri.getPath().equals("/") && this.logicalResolvers.containsKey(uri.getScheme());
    }

    public String[] listEntries(ISourceLocation uri) throws IOException {
        Map<String, ILogicalSourceLocationResolver> candidates;
        if (this.isRootLogical(uri = this.safeResolve(uri)) && (candidates = this.logicalResolvers.get(uri.getScheme())) != null) {
            return candidates.keySet().toArray(new String[0]);
        }
        ISourceLocationInput resolver = this.getInputResolver(uri.getScheme());
        if (resolver == null) {
            throw new UnsupportedSchemeException(uri.getScheme());
        }
        String[] results = resolver.list(uri);
        if (results == null) {
            throw new FileNotFoundException(uri.toString());
        }
        return results;
    }

    public void copy(ISourceLocation source, ISourceLocation target, boolean recursive, boolean overwrite) throws IOException {
        if (this.isFile(source)) {
            this.copyFile(source, target, overwrite);
        } else {
            if (this.exists(target) && !this.isDirectory(target)) {
                if (overwrite) {
                    this.remove(target, false);
                } else {
                    throw new IOException("can not make directory because file exists: " + target);
                }
            }
            this.mkDirectory(target);
            for (String elem : URIResolverRegistry.getInstance().listEntries(source)) {
                ISourceLocation srcChild = URIUtil.getChildLocation(source, elem);
                ISourceLocation targetChild = URIUtil.getChildLocation(target, elem);
                if (this.isFile(srcChild) || recursive) {
                    this.copy(srcChild, targetChild, recursive, overwrite);
                    continue;
                }
                this.mkDirectory(targetChild);
            }
        }
    }

    private void copyFile(ISourceLocation source, ISourceLocation target, boolean overwrite) throws IOException {
        if (this.exists(target) && !overwrite) {
            throw new IOException("file exists " + source);
        }
        if (this.exists(target) && overwrite) {
            this.remove(target, false);
        }
        if (this.supportsReadableFileChannel(source) && this.supportsWritableFileChannel(target)) {
            try (FileChannel from = this.getReadableFileChannel(source);
                 FileChannel to = this.getWriteableFileChannel(target, false);){
                for (long transferred = 0L; transferred < from.size(); transferred += from.transferTo(transferred, from.size() - transferred, to)) {
                }
            }
            return;
        }
        try (InputStream from = this.getInputStream(source);
             OutputStream to = this.getOutputStream(target, false);){
            int read;
            byte[] buffer = new byte[8192];
            while ((read = from.read(buffer, 0, buffer.length)) != -1) {
                to.write(buffer, 0, read);
            }
        }
    }

    public ISourceLocation[] list(ISourceLocation uri) throws IOException {
        String[] entries = this.listEntries(uri);
        if (entries == null) {
            return new ISourceLocation[0];
        }
        ISourceLocation[] list = new ISourceLocation[entries.length];
        int i = 0;
        for (String entry : entries) {
            list[i++] = URIUtil.getChildLocation(uri, entry);
        }
        return list;
    }

    public Reader getCharacterReader(ISourceLocation uri) throws IOException {
        return this.getCharacterReader(uri, this.getCharset(uri));
    }

    public Reader getCharacterReader(ISourceLocation uri, String encoding) throws IOException {
        return this.getCharacterReader(uri, Charset.forName(encoding));
    }

    public Reader getCharacterReader(ISourceLocation uri, Charset encoding) throws IOException {
        uri = this.safeResolve(uri);
        UnicodeInputStreamReader res = new UnicodeInputStreamReader(this.getInputStream(uri), encoding);
        if (uri.hasOffsetLength()) {
            return new UnicodeOffsetLengthReader(res, uri.getOffset(), uri.getLength());
        }
        return res;
    }

    public Writer getCharacterWriter(ISourceLocation uri, String encoding, boolean append) throws IOException {
        uri = this.safeResolve(uri);
        return new UnicodeOutputStreamWriter(this.getOutputStream(uri, append), encoding);
    }

    public ClassLoader getClassLoader(ISourceLocation uri, ClassLoader parent) throws IOException {
        IClassloaderLocationResolver resolver = this.getClassloaderResolver(this.safeResolve(uri).getScheme());
        if (resolver != null) {
            return resolver.getClassLoader(uri, parent);
        }
        return new GenericSourceLocationClassLoader(uri, parent);
    }

    public InputStream getInputStream(ISourceLocation uri) throws IOException {
        ISourceLocationInput resolver = this.getInputResolver((uri = this.safeResolve(uri)).getScheme());
        if (resolver == null) {
            throw new UnsupportedSchemeException(uri.getScheme());
        }
        return URIResolverRegistry.makeBuffered(resolver.getInputStream(uri));
    }

    public FileChannel getReadableFileChannel(ISourceLocation uri) throws IOException {
        ISourceLocationInput resolver = this.getInputResolver((uri = this.safeResolve(uri)).getScheme());
        if (resolver == null || !resolver.supportsReadableFileChannel()) {
            throw new UnsupportedSchemeException(uri.getScheme());
        }
        return resolver.getReadableFileChannel(uri);
    }

    public Charset detectCharset(ISourceLocation sloc) {
        URIResolverRegistry reg = URIResolverRegistry.getInstance();
        Charset detected = null;
        try (InputStream in = reg.getInputStream(sloc);){
            detected = reg.getCharset(sloc);
            if (detected == null) {
                detected = UnicodeDetector.estimateCharset(in);
            }
        }
        catch (IOException e) {
            detected = null;
        }
        return detected != null ? Charset.forName(detected.name()) : Charset.defaultCharset();
    }

    public Charset getCharset(ISourceLocation uri) throws IOException {
        ISourceLocationInput resolver = this.getInputResolver((uri = this.safeResolve(uri)).getScheme());
        if (resolver == null) {
            throw new UnsupportedSchemeException(uri.getScheme());
        }
        return resolver.getCharset(uri);
    }

    public OutputStream getOutputStream(ISourceLocation uri, boolean append) throws IOException {
        uri = this.safeResolve(uri);
        boolean existedBefore = this.exists(uri);
        ISourceLocationOutput resolver = this.getOutputResolver(uri.getScheme());
        if (resolver == null) {
            throw new UnsupportedSchemeException(uri.getScheme());
        }
        if (uri.getPath() != null && uri.getPath().startsWith("/..")) {
            throw new IllegalArgumentException("Can not navigate beyond the root of a URI: " + uri);
        }
        this.mkParentDir(uri);
        return this.makeBuffered(uri, existedBefore, resolver.getOutputStream(uri, append));
    }

    public FileChannel getWriteableFileChannel(ISourceLocation uri, boolean append) throws IOException {
        ISourceLocationOutput resolver = this.getOutputResolver((uri = this.safeResolve(uri)).getScheme());
        if (resolver == null || !resolver.supportsWritableFileChannel()) {
            throw new UnsupportedSchemeException(uri.getScheme());
        }
        if (uri.getPath() != null && uri.getPath().startsWith("/..")) {
            throw new IllegalArgumentException("Can not navigate beyond the root of a URI: " + uri);
        }
        this.mkParentDir(uri);
        return resolver.getWritableOutputStream(uri, append);
    }

    private void mkParentDir(ISourceLocation uri) throws IOException {
        ISourceLocation parentURI = URIUtil.getParentLocation(uri = this.safeResolve(uri));
        if (parentURI != null && !parentURI.equals(uri) && !this.exists(parentURI)) {
            this.mkDirectory(parentURI);
        }
    }

    public void watch(ISourceLocation loc, boolean recursive, Consumer<ISourceLocationWatcher.ISourceLocationChanged> callback) throws IOException {
        this.watchers.watch(loc, recursive, this::anyIOResolverRegistered, callback);
    }

    private boolean anyIOResolverRegistered(ISourceLocation loc) {
        return this.inputResolvers.containsKey(loc.getScheme()) || this.outputResolvers.containsKey(loc.getScheme());
    }

    public void unwatch(ISourceLocation loc, boolean recursive, Consumer<ISourceLocationWatcher.ISourceLocationChanged> callback) throws IOException {
        this.watchers.unwatch(loc, recursive, this::anyIOResolverRegistered, callback);
    }

    public ISet capabilities(ISourceLocation loc) {
        IRascalValueFactory vf = IRascalValueFactory.getInstance();
        String scheme = loc.getScheme();
        ISetWriter result = vf.setWriter();
        if (this.logicalResolvers.containsKey(scheme)) {
            result.insert(vf.constructor(this.logicalCap));
            ISourceLocation resolved = this.safeResolve(loc);
            if (resolved != loc) {
                result.insertAll(this.capabilities(resolved));
            }
        }
        if (this.inputResolvers.containsKey(scheme)) {
            result.insert(vf.constructor(this.readCap));
        }
        if (this.outputResolvers.containsKey(scheme)) {
            result.insert(vf.constructor(this.writeCap));
        }
        if (this.classloaderResolvers.containsKey(scheme)) {
            result.insert(vf.constructor(this.loadCap));
        }
        if (this.watchers.hasNativeSupport(scheme)) {
            result.insert(vf.constructor(this.watchCap));
        }
        return (ISet)result.done();
    }

    public boolean hasReadableResolver(ISourceLocation loc) {
        return this.inputResolvers.containsKey(loc.getScheme()) || this.inputResolvers.containsKey(this.safeResolve(loc).getScheme());
    }

    public boolean hasWritableResolver(ISourceLocation loc) {
        return this.outputResolvers.containsKey(loc.getScheme()) || this.outputResolvers.containsKey(this.safeResolve(loc).getScheme());
    }

    public boolean hasEfficientlyClassloadableResolver(ISourceLocation loc) {
        return this.classloaderResolvers.containsKey(loc.getScheme()) || this.classloaderResolvers.containsKey(this.safeResolve(loc).getScheme());
    }

    public boolean hasLogicalResolver(ISourceLocation loc) {
        return this.logicalResolvers.containsKey(loc.getScheme());
    }

    public boolean hasNativelyWatchableResolver(ISourceLocation loc) {
        return this.watchers.hasNativeSupport(loc.getScheme()) || this.watchers.hasNativeSupport(this.safeResolve(loc).getScheme()) || this.watchers.hasFallback();
    }

    public FileAttributes stat(ISourceLocation loc) throws IOException {
        ISourceLocationInput resolver = this.getInputResolver((loc = this.safeResolve(loc)).getScheme());
        if (resolver == null) {
            throw new IOException("Unsupported scheme: " + loc.getScheme());
        }
        try {
            return resolver.stat(loc);
        }
        catch (FileNotFoundException fe) {
            return new FileAttributes(false, false, -1L, -1L, false, false, 0L);
        }
    }

    private class GenericSourceLocationClassLoader
    extends ClassLoader {
        private final ISourceLocation root;

        public GenericSourceLocationClassLoader(ISourceLocation root, ClassLoader parent) {
            super(parent);
            this.root = root;
        }

        @Override
        protected Class<?> findClass(String qualifiedClassName) throws ClassNotFoundException {
            ISourceLocation file = URIUtil.getChildLocation(this.root, qualifiedClassName.replaceAll("\\.", "/") + ".class");
            if (URIResolverRegistry.this.exists(file)) {
                try {
                    byte[] bytes = Prelude.consumeInputStream(URIResolverRegistry.this.getInputStream(file));
                    return this.defineClass(qualifiedClassName, bytes, 0, bytes.length);
                }
                catch (IOException bytes) {
                    // empty catch block
                }
            }
            try {
                Class<?> c = Class.forName(qualifiedClassName);
                return c;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return super.findClass(qualifiedClassName);
            }
        }
    }

    private class NotifyingOutputStream
    extends FilterOutputStream {
        private final ISourceLocationWatcher.ISourceLocationChanged event;
        private ISourceLocation loc;

        public NotifyingOutputStream(OutputStream wrapped, ISourceLocation loc, ISourceLocationWatcher.ISourceLocationChanged event) {
            super(wrapped);
            assert (loc != null && event != null);
            this.loc = loc;
            this.event = event;
        }

        @Override
        public void close() throws IOException {
            super.close();
            URIResolverRegistry.this.notifyWatcher(this.loc, this.event);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }
    }

    private static class InstanceHolder {
        static URIResolverRegistry sInstance = new URIResolverRegistry();

        private InstanceHolder() {
        }
    }
}

