/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.uri.classloaders;

import io.usethesource.vallang.IList;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.rascalmpl.uri.URIResolverRegistry;

public class SourceLocationClassLoader
extends ClassLoader {
    private final Map<String, Class<?>> cache = new ConcurrentHashMap();
    private final List<ClassLoader> path;
    private final ThreadLocal<Deque<SearchItem>> stack = ThreadLocal.withInitial(LinkedList::new);

    public SourceLocationClassLoader(IList classpath, ClassLoader parent) {
        super(parent);
        this.path = this.initialize(classpath);
    }

    public SourceLocationClassLoader(List<ISourceLocation> classpath, ClassLoader parent) {
        super(parent);
        this.path = this.initialize(classpath);
    }

    private List<ClassLoader> initialize(Iterable<? extends IValue> locs) {
        URIResolverRegistry reg = URIResolverRegistry.getInstance();
        ArrayList<URL> fileLocations = new ArrayList<URL>(10);
        ArrayList<ClassLoader> result = new ArrayList<ClassLoader>(10);
        for (IValue iValue : locs) {
            try {
                ISourceLocation loc = reg.logicalToPhysical((ISourceLocation)iValue);
                ClassLoader loader = reg.getClassLoader(loc, this);
                if (loader instanceof URLClassLoader) {
                    for (URL url : ((URLClassLoader)loader).getURLs()) {
                        fileLocations.add(url);
                    }
                    continue;
                }
                result.add(loader);
            }
            catch (IOException iOException) {}
        }
        if (!fileLocations.isEmpty()) {
            result.add(new URLClassLoader(fileLocations.toArray(new URL[0]), (ClassLoader)this));
        }
        return result;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> cls;
        try {
            cls = super.loadClass(name, resolve);
        }
        catch (ClassNotFoundException e) {
            cls = this.findClass(name);
        }
        if (resolve) {
            this.resolveClass(cls);
        }
        return cls;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> cached = this.cache.get(name);
        if (cached != null) {
            return cached;
        }
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            cached = this.cache.get(name);
            if (cached != null) {
                return cached;
            }
            String fileName = name.replace('.', '/') + ".class";
            Iterator<ClassLoader> iterator = this.path.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    throw new ClassNotFoundException(name);
                }
                ClassLoader l = iterator.next();
                try {
                    InputStream stream = l.getResourceAsStream(fileName);
                    try {
                        if (stream == null) continue;
                        Class<?> cls = this.defineClass(name, ByteBuffer.wrap(stream.readAllBytes()), null);
                        this.cache.put(name, cls);
                        Class<?> clazz = cls;
                        return clazz;
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getResource(String name) {
        URL parent = super.getResource(name);
        if (parent != null) {
            return parent;
        }
        Deque<SearchItem> theStack = this.stack.get();
        if (theStack.contains(new SearchItem(this, name))) {
            return null;
        }
        for (ClassLoader l : this.path) {
            try {
                theStack.push(new SearchItem(this, name));
                URL url = l.getResource(name);
                if (url == null) continue;
                URL uRL = url;
                return uRL;
            }
            finally {
                theStack.pop();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        ArrayList<URL> result = new ArrayList<URL>(this.path.size());
        result.addAll(Collections.list(super.getResources(name)));
        Deque<SearchItem> theStack = this.stack.get();
        for (ClassLoader l : this.path) {
            SearchItem item = new SearchItem(l, name);
            if (theStack.contains(item)) continue;
            try {
                theStack.push(item);
                result.addAll(Collections.list(l.getResources(name)));
            }
            finally {
                theStack.pop();
            }
        }
        return Collections.enumeration(result);
    }

    private static class SearchItem {
        private final ClassLoader loader;
        private final String className;

        public SearchItem(ClassLoader loader, String className) {
            this.loader = loader;
            this.className = className;
        }

        public boolean equals(Object obj) {
            if (obj.getClass().equals(this.getClass())) {
                SearchItem other = (SearchItem)obj;
                return other.loader == this.loader && other.className.equals(this.className);
            }
            return false;
        }

        public int hashCode() {
            return 17 + 7 * this.loader.hashCode() + 19 * this.className.hashCode();
        }
    }
}

