---
title: "module Boolean"
id: Boolean
slug: /Library//Boolean
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-Not specified</div>

Library functions for Booleans.
#### Usage

```rascal
import Boolean;
```

#### Dependencies
```rascal
import Exception;
```

#### Description


The following library functions are defined for Booleans:
* [arbBool](..//Library/Boolean.md#Boolean-arbBool)
* [fromString](..//Library/Boolean.md#Boolean-fromString)
* [toInt](..//Library/Boolean.md#Boolean-toInt)
* [toReal](..//Library/Boolean.md#Boolean-toReal)
* [toString](..//Library/Boolean.md#Boolean-toString)


## function arbBool {#Boolean-arbBool}

Return an arbitrary Boolean value.

```rascal
bool arbBool()
```

#### Examples



```rascal-shell 
rascal>import Boolean;
ok
rascal>arbBool();
bool: true
rascal>arbBool();
bool: true
rascal>arbBool();
bool: true
```

#### Benefits


* `arbBool` is a convenient generator for arbitrary binary choices.

## function fromString {#Boolean-fromString}

Convert the strings "true" or "false" to a bool.

```rascal
bool fromString(str s)
```

## function toInt {#Boolean-toInt}

Convert a Boolean value to integer.

```rascal
int toInt(bool b)
```


Maps `true` to `1` and `false` to `0`.

#### Examples



```rascal-shell 
rascal>import Boolean;
ok
rascal>toInt(true);
int: 1
rascal>toInt(false);
int: 0
```

## function toReal {#Boolean-toReal}

Convert Boolean value to real.

```rascal
real toReal(bool b)
```


Maps `true` to `1.0` and `false` to `0.0`.

#### Examples



```rascal-shell 
rascal>import Boolean;
ok
rascal>toReal(true);
real: 1.0
rascal>toReal(false);
real: 0.0
```

## function toString {#Boolean-toString}

Convert Boolean value to string.

```rascal
str toString(bool b)
```


Maps `true` to `"true"` and `false` to `"false"`.

#### Examples



```rascal-shell 
rascal>import Boolean;
ok
rascal>toString(true);
str: "true"
───
true
───
rascal>toString(false);
str: "false"
───
false
───
```

