---
title: "module util::Highlight"
id: Highlight
slug: /Library/util/Highlight
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-Not specified</div>

Maps parse trees to highlighting markup in ANSI, HTML or LaTeX format.
#### Usage

```rascal
import util::Highlight;
```

#### Dependencies
```rascal
import ParseTree;
import String;
```


## function ToHTML {#util-Highlight-ToHTML}

Yields the characters of a parse tree as the original input sentence in a <code>...</code> block, but with spans for highlighted segments in HTML

```rascal
str ToHTML(Tree t)
```

## function toLaTeX {#util-Highlight-toLaTeX}

Yields the characters of a parse tree as the original input sentence but using macros to wrap to-be-highlighted areas.

```rascal
str toLaTeX(Tree t)
```

## function toHTML {#util-Highlight-toHTML}

Yields the characters of a parse tree as the original input sentence in a <code>...</code> block, but with spans for highlighted segments in HTML

```rascal
str toHTML(Tree t)
```

## function toANSI {#util-Highlight-toANSI}

Unparse a parse tree to unicode characters, wrapping certain substrings with ANSI codes for highlighting.

```rascal
str toANSI(Tree t, bool underlineAmbiguity=false, int tabSize=4)
```

## function isKeyword {#util-Highlight-isKeyword}

Encodes when to highlight a literal as a keyword category

```rascal
bool isKeyword(str s)
```

