---
title: "module salix::canvas::Canvas"
id: Canvas
slug: /Packages/org.rascalmpl.salix-contrib/API/salix/canvas/Canvas
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.2</div> <div class="theme-doc-version-badge badge badge--secondary">org.rascalmpl.salix-contrib-0.2.9</div>

#### Usage

```rascal
import salix::canvas::Canvas;
```

#### Dependencies
```rascal
import salix::HTML;
import salix::Node;
import salix::Core;
import List;
import String;
import Node;
```


## data PredefinedColorSpace {#salix-canvas-Canvas-PredefinedColorSpace}

```rascal
data PredefinedColorSpace  
     = srgb()
     | \display-p3()
     ;
```

## data CanvasFillRule {#salix-canvas-Canvas-CanvasFillRule}

```rascal
data CanvasFillRule  
     = nonzero()
     | evenodd()
     ;
```

## data CanvasRenderingContext2DSettings {#salix-canvas-Canvas-CanvasRenderingContext2DSettings}

```rascal
data CanvasRenderingContext2DSettings  
     = ctxSettings(
  bool alpha = true,
  bool desynchronized = false,
  PredefinedColorSpace colorSpace = srgb(),
  bool willReadFrequently = false
)
     ;
```

## alias Path2D {#salix-canvas-Canvas-Path2D}

```rascal
list[Move]
```

## data Move {#salix-canvas-Canvas-Move}

```rascal
data Move (bool r=false) 
     = move(num x, num y)
     | line(num x, num y)
     | horizontal(num x)
     | vertical(num y)
     | cubic(num x1, num y1, num x2, num y2, num x, num y)
     | cubic(num x2, num y2, num x, num y)
     | quadratic(num x1, num y1, num x, num y)
     | quadratic(num x, num y)
     | arc(num rx, num ry, num xrot, num large, num sweep, num x, num y)
     | close()
     ;
```

## function lowerIfRel {#salix-canvas-Canvas-lowerIfRel}

```rascal
str lowerIfRel(Move m, str s)
```

## function move2svg {#salix-canvas-Canvas-move2svg}

```rascal
str move2svg(m:move(num x, num y))

str move2svg(m:line(num x, num y))

str move2svg(m:horizontal(num x))

str move2svg(m:vertical(num y))

str move2svg(m:cubic(num x1, num y1, num x2, num y2, num x, num y))

str move2svg(m:cubic(num x2, num y2, num x, num y))

str move2svg(m:quadratic(num x1, num y1, num x, num y))

str move2svg(m:quadratic(num x, num y))

str move2svg(m:arc(num rx, num ry, num xrot, num large, num sweep, num x, num y))

str move2svg(m:close())
```

## function path2dAsSVG {#salix-canvas-Canvas-path2dAsSVG}

```rascal
str path2dAsSVG(Path2D p)
```

## data ImageSmoothingQuality {#salix-canvas-Canvas-ImageSmoothingQuality}

```rascal
data ImageSmoothingQuality  
     = low()
     | medium()
     | high()
     ;
```

## data CanvasLineCap {#salix-canvas-Canvas-CanvasLineCap}

```rascal
data CanvasLineCap  
     = butt()
     | round()
     | square()
     ;
```

## data CanvasLineJoin {#salix-canvas-Canvas-CanvasLineJoin}

```rascal
data CanvasLineJoin  
     = round()
     | bevel()
     | miter()
     ;
```

## data CanvasTextAlign {#salix-canvas-Canvas-CanvasTextAlign}

```rascal
data CanvasTextAlign  
     = \start()
     | end()
     | left()
     | right()
     | center()
     ;
```

## data CanvasTextBaseline {#salix-canvas-Canvas-CanvasTextBaseline}

```rascal
data CanvasTextBaseline  
     = top()
     | hanging()
     | middle()
     | alphabetic()
     | ideographic()
     | bottom()
     ;
```

## data CanvasDirection {#salix-canvas-Canvas-CanvasDirection}

```rascal
data CanvasDirection  
     = ltr()
     | rtl()
     | inherit()
     ;
```

## data CanvasFontKerning {#salix-canvas-Canvas-CanvasFontKerning}

```rascal
data CanvasFontKerning  
     = auto()
     | normal()
     | none()
     ;
```

## data CanvasFontStretch {#salix-canvas-Canvas-CanvasFontStretch}

```rascal
data CanvasFontStretch  
     = \ultra-condensed()
     | \extra-condensed()
     | condensed()
     | \semi-condensed()
     | normal()
     | \semi-expanded()
     | expanded()
     | \extra-expanded()
     | \ultra-expanded()
     ;
```

## data CanvasFontVariantCaps {#salix-canvas-Canvas-CanvasFontVariantCaps}

```rascal
data CanvasFontVariantCaps  
     = normal()
     | \small-caps()
     | \all-small-caps()
     | \petite-caps()
     | \all-petite-caps()
     | unicase()
     | \titling-caps()
     ;
```

## data CanvasTextRendering {#salix-canvas-Canvas-CanvasTextRendering}

```rascal
data CanvasTextRendering  
     = auto()
     | optimizeSpeed()
     | optimizeLegibility()
     | geometricPrecision()
     ;
```

## alias GC {#salix-canvas-Canvas-GC}

```rascal
tuple[     void(num /* x */, num /* y */) scale,     void(num /* angle */) rotate,     void(num /* x */, num /* y */) translate,     void(num /* a */, num /* b */, num /* c */, num /* d */, num /* e */, num /* f */) transform,     void(num /* x */, num /* y */, num /* w */, num /* h */) clearRect,     void(num /* x */, num /* y */, num /* w */, num /* h */) fillRect,     void(num /* x */, num /* y */, num /* w */, num /* h */) strokeRect,      void() beginPath,     void(CanvasFillRule /* fillRule */) fill,     void(Path2D /* path */, CanvasFillRule /* fillRule */) fillPath,     void() stroke,     void(Path2D /* path */) strokePath,     void(CanvasFillRule /* fillRule */) clip,     void(Path2D /* path */, CanvasFillRule /* fillRule */) clipPath,      void(str /* text */, num /* x */, num /* y */, num /* maxWidth */) fillText,     void(str /* text */, num /* x */, num /* y */, num /* maxWidth */) strokeText,      void(str /* image */, num /* dx */, num /* dy */) drawImage1,     void(str /* image */, num /* dx */, num /* dy */, num /* dw */, num /* dh */) drawImage2,     void(str /* image */, num /* sx */, num /* sy */, num /* sw */, num /* sh */, num /* dx */, num /* dy */, num /* dw */, num /* dh */) drawImage3,      void() closePath,     void(num /* x */, num /* y */) moveTo,     void(num /* x */, num /* y */) lineTo,     void(num /* cpx */, num /* cpy */, num /* x */, num /* y */) quadraticCurveTo,     void(num /* cp1x */, num /* cp1y */, num /* cp2x */, num /* cp2y */, num /* x */, num /* y */) bezierCurveTo,     void(num /* x1 */, num /* y1 */, num /* x2 */, num /* y2 */, num /* radius */) arcTo,      void(num /* x */, num /* y */, num /* w */, num /* h */) rect,     void(num /* x */, num /* y */, num /* w */, num /* h */, list[num] /* radii */) roundRect,     void(num /* x */, num /* y */, num /* radius */, num /* startAngle */, num /* endAngle */, bool /* counterclockwise */) arc,      void(num /* x */, num /* y */, num /* radiusX */, num /* radiusY */, num /* rotation */, num /* startAngle */, num /* endAngle */, bool /* counterclockwise */) ellipse,        // Attributes     void(num) globalAlpha, // (default 1.0)     void(str) globalCompositeOperation, // (default "source-over")     void(bool) imageSmoothingEnabled, // (default true)     void(ImageSmoothingQuality) imageSmoothingQuality, // (default low)     void(str) strokeStyle, // (default black)     void(str) fillStyle, // (default black)     void(num) shadowOffsetX, // (default 0)     void(num) shadowOffsetY, // (default 0)     void(num) shadowBlur, // (default 0)     void(str) shadowColor, // (default transparent black)     void(str) \filter, // (default "none")     void(num) lineWidth, // (default 1)     void(CanvasLineCap) lineCap, // (default "butt")     void(CanvasLineJoin) lineJoin, // (default "miter")     void(num) miterLimit, // (default 10)     void (list[num] segments) setLineDash, // default empty     void(num) lineDashOffset,     void(str) font, // (default 10px sans-serif)     void(CanvasTextAlign) textAlign, // (default: "start")     void(CanvasTextBaseline) textBaseline, // (default: "alphabetic")     void(CanvasDirection) direction, // (default: "inherit")     void(str) letterSpacing, // (default: "0px")     void(CanvasFontKerning) fontKerning, // (default: "auto")     void(CanvasFontStretch) fontStretch, // (default: "normal")     void(CanvasFontVariantCaps) fontVariantCaps, // (default: "normal")     void(CanvasTextRendering) textRendering, // (default: "auto")     void(str) wordSpacing, // (default: "0px")      void() save,     void() restore ]
```

## function initCode {#salix-canvas-Canvas-initCode}

```rascal
str initCode(str name)
```

## function myCanvas {#salix-canvas-Canvas-myCanvas}

```rascal
void myCanvas(str name, int w, int h, list[Attr] attrs, void(GC) block)
```

