---
title: "module salix::jsplumb::JSPlumb"
id: JSPlumb
slug: /Packages/org.rascalmpl.salix-contrib/API/salix/jsplumb/JSPlumb
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.2</div> <div class="theme-doc-version-badge badge badge--secondary">org.rascalmpl.salix-contrib-0.2.9</div>

#### Usage

```rascal
import salix::jsplumb::JSPlumb;
```

#### Dependencies
```rascal
import salix::HTML;
import salix::Node;
import salix::Core;
import Node;
import lang::json::IO;
import String;
```


## alias N {#salix-jsplumb-JSPlumb-N}

```rascal
void(str id, void() block)
```

## alias E {#salix-jsplumb-JSPlumb-E}

```rascal
void(str from, str to)
```

## alias B {#salix-jsplumb-JSPlumb-B}

```rascal
void(N, E)
```

## function node2attr {#salix-jsplumb-JSPlumb-node2attr}

```rascal
Attr node2attr(node n)
```

## data Connector {#salix-jsplumb-JSPlumb-Connector}

```rascal
data Connector  
     = straight(int stub = 0, int gap = 0)
     | bezier(int curviness = 150)
     | flowchart(int stub = 30, bool alwaysRespectStub = false, int gap = 0, real midpoint = 0.5, int cornerRadius = 0)
     | stateMachine(int margin = 5, int curviness = 10, int proximityLimit = 80)
     ;
```

## data Face {#salix-jsplumb-JSPlumb-Face}

```rascal
data Face  
     = top()
     | left()
     | right()
     | bottom()
     ;
```

## data Anchor {#salix-jsplumb-JSPlumb-Anchor}

```rascal
data Anchor  
     = top()
     | topRight()
     | right()
     | bottomRight()
     | bottom()
     | bottomLeft()
     | left()
     | topLeft()
     | center()
     | autoDefault()
     | perimeter(Shape shape, int anchorCount = 60, int rotation = 0)
     | continuous(list[Face] faces = [Face::top(), 
        Face::left(), 
        Face::right(), 
        Face::bottom()])
     ;
```

## data Shape {#salix-jsplumb-JSPlumb-Shape}

```rascal
data Shape  
     = circle()
     | ellipse()
     | triangle()
     | diamond()
     | rectangle()
     | square()
     ;
```

## data Endpoint {#salix-jsplumb-JSPlumb-Endpoint}

```rascal
data Endpoint  
     = dot(int radius = 5, str cssClass = "", str hoverClass = "")
     | rectangle(int width = 20, int height = 20, str cssClass = "", str hoverClass = "")
     | blank()
     ;
```

## function initCode {#salix-jsplumb-JSPlumb-initCode}

```rascal
str initCode(str name)
```

## function jsplumb {#salix-jsplumb-JSPlumb-jsplumb}

```rascal
void jsplumb(str name, B block, str width="600px", str height="400xpx")
```

