---
title: "module salix::util::Mode"
id: Mode
slug: /Packages/org.rascalmpl.salix-contrib/API/salix/util/Mode
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.2</div> <div class="theme-doc-version-badge badge badge--secondary">org.rascalmpl.salix-contrib-0.2.9</div>

#### Usage

```rascal
import salix::util::Mode;
```

#### Dependencies
```rascal
import Type;
import ParseTree;
import String;
```


## data Mode {#salix-util-Mode-Mode}

```rascal
data Mode  
     = mode(str name, list[State] states, map[str, value] meta = ())
     ;
```

## data State {#salix-util-Mode-State}

```rascal
data State  
     = state(str name, list[Rule] rules)
     ;
```

## data Rule {#salix-util-Mode-Rule}

```rascal
data Rule  
     = rule(str regex, list[str] tokens, str next = "", bool indent=false, bool dedent=false)
     ;
```

## function cat2token {#salix-util-Mode-cat2token}

```rascal
str cat2token("StringLiteral")

str cat2token("Comment")

str cat2token("Constant")

str cat2token("Variable")

default str cat2token(str _)
```

## function grammar2mode {#salix-util-Mode-grammar2mode}

```rascal
Mode grammar2mode(str name, type[&T <: Tree] sym)
```

## function jsExample {#salix-util-Mode-jsExample}

```rascal
Mode jsExample()
```

