---
title: "module salix::Core"
id: Core
slug: /Packages/org.rascalmpl.salix-core/API/salix/Core
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0</div> <div class="theme-doc-version-badge badge badge--secondary">org.rascalmpl.salix-core-0.2.8</div>

#### Usage

```rascal
import salix::Core;
```

#### Dependencies
```rascal
import salix::Node;
import List;
import String;
import IO;
import lang::json::IO;
import Type;
```


## data Handle {#salix-Core-Handle}

```rascal
data Handle  
     = handle(int id, list[int] maps = [])
     ;
```

Handles represent (encoded) functions to decode events.
 id: identifies the decoder function (e.g., of type Msg(int))
 maps: identifies the active mappers for this handle.  

## alias Encoding {#salix-Core-Encoding}

```rascal
tuple[int id, map[int, value] from, map[value, int] to, map[int, value] closures]
```

## function switchTo {#salix-Core-switchTo}

```rascal
void switchTo(str appId)
```

## function switchFrom {#salix-Core-switchFrom}

```rascal
void switchFrom(str appId)
```

## function _encode {#salix-Core-_encode}

```rascal
int _encode(value x)
```

## function _partial {#salix-Core-_partial}

```rascal
&T(&V) _partial(list[value] key, &T(&V) closure)
```

## function partial {#salix-Core-partial}

```rascal
&T(&V) partial(&T(&U0, &V) f, &U0 u0)

&T(&V) partial(&T(&U0, &U1, &V) f, &U0 u0, &U1 u1)

&T(&V) partial(&T(&U0, &U1, &U2, &V) f, &U0 u0, &U1 u1, &U2 u2)

&T(&V) partial(&T(&U0, &U1, &U2, &U3, &V) f, &U0 u0, &U1 u1, &U2 u2, &U3 u3)
```

## function _decode {#salix-Core-_decode}

```rascal
&U _decode(int funcId, type[&U] _)

default &U _decode(int funcId, type[&U] _)
```

## function encode {#salix-Core-encode}

```rascal
Handle encode(value x)
```

## function decode {#salix-Core-decode}

```rascal
&T decode(Handle h, type[&T] t)

&T decode(int funcId, type[&T] t)
```

## function printNodeStack {#salix-Core-printNodeStack}

```rascal
void printNodeStack()
```

Print out the current node stack for debugging.

## function add {#salix-Core-add}

```rascal
void add(Node h)
```

Basic stack management functions.

## function addNode {#salix-Core-addNode}

```rascal
void addNode(Node h)
```

## function push {#salix-Core-push}

```rascal
void push(list[Node] l)
```

## function top {#salix-Core-top}

```rascal
list[Node] top()
```

## function pop {#salix-Core-pop}

```rascal
list[Node] pop()
```

## function initialize {#salix-Core-initialize}

```rascal
tuple[list[Cmd], &T] initialize(&T() init, void(&T) view)
```

Initialize viewContext for an initial model, so that cmds are properly mapped.

## function render {#salix-Core-render}

```rascal
Node render(&T model, void(&T) block)

Node render(void() block)
```

Render turns void returning views for a model &T into an Node node.

## function withExtra {#salix-Core-withExtra}

```rascal
void withExtra(map[str, value] stuff, void() block)
```

## function build {#salix-Core-build}

```rascal
void build(list[value] vals, str tagName)
```

The basic build function to construct html elements on the stack.
The list of argument values can contain any number of Attr values.
The last argument (if any) can be a blouitck, an Node node, or a value.
In the latter case it is converted to a txt node.

## function _text {#salix-Core-_text}

```rascal
void _text(value v)
```

Create a text node from an arbitrary value.

## data Sub {#salix-Core-Sub}

```rascal
data Sub  
     = subscription(str name, Handle handle, map[str, value] args = ())
     ;
```

Subs are like events: they are sent to JS, and messages are sent back.

## function timeEvery {#salix-Core-timeEvery}

```rascal
Sub timeEvery(Msg(int) int2msg, int interval)
```

Smart constructors for constructing encoded subscriptions.

## function observeFile {#salix-Core-observeFile}

```rascal
Sub observeFile(Msg(list[FSChange]) recs2msg, str key)
```

## alias Subs {#salix-Core-Subs}

```rascal
list[Sub](&T)
```

## function noSubs {#salix-Core-noSubs}

```rascal
list[Sub] noSubs(&T _)
```

## data Cmd {#salix-Core-Cmd}

```rascal
data Cmd  
     = command(str name, Handle handle, map[str,value] args = ())
     ;
```

Commands represent actions that need to be performed at the client.

## function do {#salix-Core-do}

```rascal
void do(Cmd cmd)
```

## function execute {#salix-Core-execute}

```rascal
tuple[list[Cmd], &T] execute(Msg msg, &T(Msg, &T) update, &T model)

tuple[list[Cmd], &T] execute(&T() init)
```

## function random {#salix-Core-random}

```rascal
Cmd random(Msg(int) f, int from, int to)
```

Smart constructors for constructing encoded commands.

## function setFocus {#salix-Core-setFocus}

```rascal
Cmd setFocus(Msg() f, str id)
```

## function pickFile {#salix-Core-pickFile}

```rascal
Cmd pickFile(Msg(FSHandle) f, str key)
```

## data Hnd {#salix-Core-Hnd}

```rascal
data Hnd  
     = handler(str name, Handle handle, map[str,value] args = ())
     ;
```

## alias Parser {#salix-Core-Parser}

```rascal
Msg(str,Handle,map[str,value])
```

## function params2msg {#salix-Core-params2msg}

```rascal
Msg params2msg(map[str, value] params, Parser parse)
```

Convert request parameters to a Msg value. Active mappers at `path`
transform the message according to f.

## function toHandle {#salix-Core-toHandle}

```rascal
Handle toHandle(map[str, value] params)
```

Parse request parameters into a Handle.

## function toMaps {#salix-Core-toMaps}

```rascal
list[int] toMaps(str x)
```

## function parseMsg {#salix-Core-parseMsg}

```rascal
Msg parseMsg("nothing", Handle h, map[str, value] p)

Msg parseMsg("string", Handle h, map[str,value] p)

Msg parseMsg("boolean", Handle h, map[str, value] p)

Msg parseMsg("integer", Handle h, map[str, value] p)

Msg parseMsg("real", Handle h, map[str,value] p)

Msg parseMsg("values", Handle h, map[str,value] p)
```

## alias FSHandle {#salix-Core-FSHandle}

```rascal
tuple[str kind, str name]
```

## alias FSChange {#salix-Core-FSChange}

```rascal
tuple[     FSHandle root,      FSHandle changedHandle,      list[str] relativePathComponents,      str \type,     list[str] relativePathMovedFrom // optional ]
```

## function parseMsg {#salix-Core-parseMsg}

```rascal
Msg parseMsg("fshandle", Handle h, map[str, value] p)

Msg parseMsg("fschange", Handle h, map[str, value] p)
```

## alias XY {#salix-Core-XY}

```rascal
tuple[int x, int y]
```

## alias MouseXY {#salix-Core-MouseXY}

```rascal
tuple[XY client, XY movement, XY offset, XY page, XY screen]
```

## function parseMsg {#salix-Core-parseMsg}

```rascal
Msg parseMsg("mouseXY", Handle h, map[str,value] p)

Msg parseMsg("json", Handle h, map[str, value] p)
```

## function applyMaps {#salix-Core-applyMaps}

```rascal
Msg applyMaps(Handle h, Msg msg)
```

## function withMapper {#salix-Core-withMapper}

```rascal
&T withMapper(Msg(Msg) f, &T() block)
```

## function mapSubs {#salix-Core-mapSubs}

```rascal
list[Sub] mapSubs(Msg(Msg) f, &T t, list[Sub](&T) subs)
```

## function mapCmds {#salix-Core-mapCmds}

```rascal
&T mapCmds(Msg(Msg) f, Msg msg, &T t, &T(Msg, &T) upd)

&T mapCmds(Msg(Msg) f, &T() init)
```

## function mapView {#salix-Core-mapView}

```rascal
void mapView(Msg(Msg) f, &T t, void(&T) block)
```

Record mapper to transform messages produced in block according f.

## function _reset {#salix-Core-_reset}

```rascal
void _reset()
```

