---
title: "module salix::Diff"
id: Diff
slug: /Packages/org.rascalmpl.salix-core/API/salix/Diff
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0</div> <div class="theme-doc-version-badge badge badge--secondary">org.rascalmpl.salix-core-0.2.8</div>

#### Usage

```rascal
import salix::Diff;
```

#### Dependencies
```rascal
import salix::Node;
import salix::util::LCS;
import List;
import util::Math;
import IO;
import vis::Text;
```


## data Patch {#salix-Diff-Patch}

```rascal
data Patch  
     = patch(int pos, list[Patch] patches = [], list[Edit] edits = [])
     ;
```

Patch are positioned at pos in the parent element where
they originate. This allows sparse/shallow traversal during
patching: not all kids of an element will have changes, so
patches for those kids will not end up in the patch at all.
At each level a list of edits can be applied.
A root patch will have pos = - 1.

## data EditType {#salix-Diff-EditType}

```rascal
data EditType  
     = setText()
     | replace()
     | removeNode()
     | appendNode()
     | insertNode()
     | setAttr()
     | setProp()
     | setEvent()
     | setExtra()
     | removeAttr()
     | removeProp()
     | removeEvent()
     | removeExtra()
     ;
```

## data Node {#salix-Diff-Node}

```rascal
data Node  
     = none()
     ;
```

## data Hnd {#salix-Diff-Hnd}

```rascal
data Hnd  
     = null()
     ;
```

## data Edit {#salix-Diff-Edit}

```rascal
data Edit  
     = edit(EditType \type, str contents="", Node html=none(), Hnd handler=null(),
        str name="", str val="", int pos=-1, value extra=())
     ;
```

## function diff {#salix-Diff-diff}

```rascal
Patch diff(Node old, Node new)
```

## function nodeEq {#salix-Diff-nodeEq}

```rascal
bool nodeEq(Node x, Node y)
```

## function diff {#salix-Diff-diff}

```rascal
Patch diff(Node old, Node new, int idx)
```

## function isAlien {#salix-Diff-isAlien}

```rascal
bool isAlien(Node nk)
```

## function getId {#salix-Diff-getId}

```rascal
str getId(Node n)
```

## function diffKids {#salix-Diff-diffKids}

```rascal
Patch diffKids(list[Node] oldKids, list[Node] newKids, Patch myPatch)
```

## function diffEventMap {#salix-Diff-diffEventMap}

```rascal
list[Edit] diffEventMap(map[str, Hnd] old, map[str, Hnd] new)
```

## function diffMap {#salix-Diff-diffMap}

```rascal
list[Edit] diffMap(map[str, str] old, map[str, str] new, EditType upd, EditType del)
```

## function diffExtra {#salix-Diff-diffExtra}

```rascal
list[Edit] diffExtra(map[str, value] old, map[str, value] new)
```

