---
title: "module salix::demo::basic::Counter"
id: Counter
slug: /Packages/org.rascalmpl.salix-core/API/salix/demo/basic/Counter
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0</div> <div class="theme-doc-version-badge badge badge--secondary">org.rascalmpl.salix-core-0.2.8</div>

#### Usage

```rascal
import salix::demo::basic::Counter;
```

#### Dependencies
```rascal
import salix::App;
import salix::HTML;
import salix::Index;
```


## function counterApp {#salix-demo-basic-Counter-counterApp}

```rascal
SalixApp[Model] counterApp(str id = "root") 
  = makeApp(id, init, withIndex("Counter", id, view), update);
```

## function counterWebApp {#salix-demo-basic-Counter-counterWebApp}

```rascal
App[Model] counterWebApp()
  = webApp(counterApp(),|project://salix-core/src/main/rascal|);
```

## alias Model {#salix-demo-basic-Counter-Model}

```rascal
tuple[int count]
```

## function init {#salix-demo-basic-Counter-init}

```rascal
Model init() = <0>;
```

## data Msg {#salix-demo-basic-Counter-Msg}

```rascal
data Msg  
     = inc()
     | dec()
     ;
```

## function update {#salix-demo-basic-Counter-update}

```rascal
Model update(Msg msg, Model m) {
  switch (msg) {
    case inc(): m.count += 1;
    case dec(): m.count -= 1;
  }
  return m;
}
```

## function view {#salix-demo-basic-Counter-view}

```rascal
void view(Model m) {
  h2("My first counter app in Rascal");
  counterView(m);
}
```

## function counterView {#salix-demo-basic-Counter-counterView}

```rascal
void counterView(Model m) {
  button(onClick(inc()), "+");
  span("<m.count>");
  button(onClick(dec()), "-");	
}
```

