---
title: "module salix::demo::basic::Loop"
id: Loop
slug: /Packages/org.rascalmpl.salix-core/API/salix/demo/basic/Loop
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0</div> <div class="theme-doc-version-badge badge badge--secondary">org.rascalmpl.salix-core-0.2.8</div>

#### Usage

```rascal
import salix::demo::basic::Loop;
```

#### Dependencies
```rascal
import salix::App;
import salix::Core;
import salix::HTML;
import salix::Index;
import String;
import List;
```


## alias Model {#salix-demo-basic-Loop-Model}

```rascal
tuple[int count, list[int] numbers]
```

## function init {#salix-demo-basic-Loop-init}

```rascal
Model init() {
  do(random(addNumber, 1, 100));
  return <100, []>;
}
```

## function loopApp {#salix-demo-basic-Loop-loopApp}

```rascal
SalixApp[Model] loopApp(str id = "root") 
  = makeApp(id, init, withIndex("Loop", id, view), update);
```

## function loopWebApp {#salix-demo-basic-Loop-loopWebApp}

```rascal
App[Model] loopWebApp() 
  = webApp(loopApp(), |project://salix/src/main/rascal|);
```

## data Msg {#salix-demo-basic-Loop-Msg}

```rascal
data Msg  
     = addNumber(int n)
     | updateCount(str x)
     ;
```

## function update {#salix-demo-basic-Loop-update}

```rascal
Model update(Msg msg, Model m) {

  switch (msg) {
    case addNumber(int x): {
      if (size(m.numbers) < m.count) {
        m.numbers += [x];
        do(random(addNumber, 1, 100));
      }
    }
    
    case updateCount(str x): {
      m.count = toInt(x);
      m.numbers = m.numbers[0..m.count];
      do(random(addNumber, 1, 100));
    }
      
  }
  
  return m;
}
```

## function view {#salix-demo-basic-Loop-view}

```rascal
void view(Model m) {
 text("Count: ");
 input(\type("text"), \value("<m.count>"), onInput(updateCount));
 for (int i <- [0..size(m.numbers)]) {
   p("<i>: <m.numbers[i]>");
 }
}
```

