---
title: "module salix::util::LCS"
id: LCS
slug: /Packages/org.rascalmpl.salix-core/API/salix/util/LCS
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0</div> <div class="theme-doc-version-badge badge badge--secondary">org.rascalmpl.salix-core-0.2.8</div>

#### Usage

```rascal
import salix::util::LCS;
```

#### Dependencies
```rascal
import List;
import util::Math;
```


## data Diff {#salix-util-LCS-Diff}

```rascal
data Diff[&T]  
     = same(&T t1, &T t2)
     | add(&T t, int pos)
     | remove(&T t, int pos)
     ;
```

## alias LCSMatrix {#salix-util-LCS-LCSMatrix}

```rascal
map[int,map[int,int]]
```

## function getDiff {#salix-util-LCS-getDiff}

```rascal
list[Diff[&T]] getDiff(LCSMatrix c, list[&T] x, list[&T] y, int i, int j, bool(&T, &T) equals)
```

## function lcsMatrix {#salix-util-LCS-lcsMatrix}

```rascal
LCSMatrix lcsMatrix(list[&T] x, list[&T] y, bool (&T,&T) equals)
```

