---
title: "module salix::util::WithPopups"
id: WithPopups
slug: /Packages/org.rascalmpl.salix-core/API/salix/util/WithPopups
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0</div> <div class="theme-doc-version-badge badge badge--secondary">org.rascalmpl.salix-core-0.2.8</div>

#### Usage

```rascal
import salix::util::WithPopups;
```

#### Dependencies
```rascal
import salix::App;
import salix::HTML;
import salix::Core;
import salix::Index;
import salix::Node;
import Node;
import List;
```


## alias Popups {#salix-util-WithPopups-Popups}

```rascal
lrel[str selector, Popup popup]
```

Mapping CSS selectors to Popup values

## data Popup {#salix-util-WithPopups-Popup}

```rascal
data Popup  
     = popup(str text, Placement placement = \auto()
             , list[Modifier] modifiers = []
             , Strategy strategy = fixed())
     ;
```

A Popup has a literal `text``, a `placement` defaulting to `auto()`
and placement `strategy` defaulting to `fixed()`.
In the future we want to support arbitrary HTML in `text`.

## data Placement {#salix-util-WithPopups-Placement}

```rascal
data Placement  
     = \auto()
     | \auto-start()
     | \auto-end()
     | \top()
     | \top-start()
     | \top-end()
     | \bottom()
     | \bottom-start()
     | \bottom-end()
     | \right()
     | \right-start()
     | \right-end()
     | \left()
     | \left-start()
     | \left-end()
     ;
```

Data type encoding PopperJS positions of the tooltip.
(see here https://popper.js.org/docs/v2/constructors/).

## data Strategy {#salix-util-WithPopups-Strategy}

```rascal
data Strategy  
     = absolute()
     | fixed()
     ;
```

## function withPopupsWeb {#salix-util-WithPopups-withPopupsWeb}

```rascal
App[&T] withPopupsWeb(Popups popups, &T appModel, void(&T) appView, str title
                     , str extraCss=DEFAULT_CSS, list[str] css=[], list[str] scripts=[])
```


Run a Salix app view function `appView` on a model value `appModel` and decorate
the resulting page with popups/tooltips according `popups`, which is a list relation
mapping CSS selectors (strings) to Popup values (see above). This function is primarily
intended for creating explanatory screenshots for documentation or slide decks.
The resulting page view is not interactive anymore; events are simply ignored. 

## function withPopups {#salix-util-WithPopups-withPopups}

```rascal
SalixApp[&T] withPopups(Popups popups, &T appModel, void(&T) appView, str title
                      , str extraCss=DEFAULT_CSS, list[str] css=[], list[str] scripts=[], str id = "root")
```

## function withPopupView {#salix-util-WithPopups-withPopupView}

```rascal
void withPopupView(Popups popups, &T model, void(&T) appView, str css)
```

