---
title: "module salix::App"
id: App
slug: /Packages/org.rascalmpl.salix-core/API/salix/App
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.2</div> <div class="theme-doc-version-badge badge badge--secondary">org.rascalmpl.salix-core-0.2.9</div>

#### Usage

```rascal
import salix::App;
```

#### Dependencies
```rascal
import salix::Node;
import salix::Core;
import salix::Diff;
import util::Webserver;
import util::Maybe;
import lang::json::IO;
import IO;
import String;
```


## alias App {#salix-App-App}

```rascal
Content
```

The basic Web App type for use within Rascal.

## data SalixRequest {#salix-App-SalixRequest}

```rascal
data SalixRequest  
     = boot()
     | begin()
     | message(map[str, value] params)
     ;
```

SalixRequest and SalixResponse are HTTP independent types that model
the basic workflow of Salix.

## data SalixResponse {#salix-App-SalixResponse}

```rascal
data SalixResponse  
     = next(list[Cmd] cmds, list[Sub] subs, Patch patch)
     | document(Node doc)
     ;
```

## alias SalixApp {#salix-App-SalixApp}

```rascal
tuple[str id, SalixResponse (SalixRequest) rr]
```

A function type to describe a basic SalixApp without committing to a 
particular HTTP server yet. The first argument represents the unique id of this application, 
which also must correspond to the DOM element with that string as id.
This allows using one web server to serve/multiplex different Salix apps
on a single page.

## function makeApp {#salix-App-makeApp}

```rascal
SalixApp[&T] makeApp(str appId, &T() init, void(&T) view, &T(Msg, &T) update, 
  Subs[&T] subs = list[Sub](&T _) {return [];}, Parser parser = parseMsg, bool debug = false)
```

Construct a SalixApp over model type &T, providing a view, a model update,
and optionally a list of subscriptions, and a possibly extended parser for
handling messages originating from wrapped "native" elements.

## function webApp {#salix-App-webApp}

```rascal
App[&T] webApp(SalixApp[&T] app, loc static, map[str,str] headers = ())
```

Turn a single Salix App into a web application. The index parameter should point to the local file which holds the index html.
The static parameter should point to the base directory from where static files should be served

## function standalone {#salix-App-standalone}

```rascal
tuple[void () serve, void () stop] standalone(loc host, App[&T] webapp)
```

