---
title: "module salix::Node"
id: Node
slug: /Packages/org.rascalmpl.salix-core/API/salix/Node
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.2</div> <div class="theme-doc-version-badge badge badge--secondary">org.rascalmpl.salix-core-0.2.9</div>

#### Usage

```rascal
import salix::Node;
```

#### Dependencies
```rascal
import List;
```


## data Node {#salix-Node-Node}

```rascal
data Node  
     = hnode(NodeType \type, str tagName="", list[Node] kids=[], map[str,str] attrs=(),
          map[str,str] props=(), map[str,Hnd] events=(), map[str,value] extra=(),
          str id="", str kind="", str contents="")
     ;
```

The basic Html node type, defining constructors for
elements, text nodes, and native nodes (which are managed in js).

## data NodeType {#salix-Node-NodeType}

```rascal
data NodeType  
     = element()
     | txt()
     | empty()
     ;
```

## data Attr {#salix-Node-Attr}

```rascal
data Attr  
     = attr(str name, str val)
     | prop(str name, str val)
     | event(str name, Hnd handler, map[str,str] options = ())
     | null()
     ;
```

Generalized attributes to be produced by explicit attribute construction
functions (such as class(str), onClick(Msg), or \value(str)).
null() acts as a zero element and is always ignored.

## function attrsOf {#salix-Node-attrsOf}

```rascal
map[str,str] attrsOf(list[Attr] attrs)
```

Helper functions to partition list of Attrs into attrs, props and events

## function propsOf {#salix-Node-propsOf}

```rascal
map[str,str] propsOf(list[Attr] attrs)
```

## function eventsOf {#salix-Node-eventsOf}

```rascal
map[str,Hnd] eventsOf(list[Attr] attrs)
```

## function bareHtml {#salix-Node-bareHtml}

```rascal
Node bareHtml(Node n)
```

## function toHtml {#salix-Node-toHtml}

```rascal
str toHtml(h:hnode(element()))

str toHtml(h:hnode(txt()))
```

## function kids2html {#salix-Node-kids2html}

```rascal
str kids2html(list[Node] kids)
```

## function attrs2str {#salix-Node-attrs2str}

```rascal
str attrs2str(map[str, str] attrs)
```

