---
title: "module salix::demo::basic::All"
id: All
slug: /Packages/org.rascalmpl.salix-core/API/salix/demo/basic/All
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.2</div> <div class="theme-doc-version-badge badge badge--secondary">org.rascalmpl.salix-core-0.2.9</div>

#### Usage

```rascal
import salix::demo::basic::All;
```

#### Dependencies
```rascal
import salix::HTML;
import salix::App;
import salix::Core;
import salix::Index;
import salix::util::Debug;
import salix::Index;
import salix::demo::basic::Celsius;
import salix::demo::basic::Counter;
import salix::demo::basic::Clock;
import salix::demo::basic::Random;
```


## alias AllModel {#salix-demo-basic-All-AllModel}

```rascal
tuple[   salix::demo::basic::Celsius::Model celsius,    salix::demo::basic::Counter::Model counter,    salix::demo::basic::Random::TwiceModel random,   salix::demo::basic::Clock::Model clock ]
```

## data Msg {#salix-demo-basic-All-Msg}

```rascal
data Msg  
     = celsius(Msg msg)
     | counter(Msg msg)
     | random(Msg msg)
     | clock(Msg msg)
     ;
```

## function allDemosApp {#salix-demo-basic-All-allDemosApp}

```rascal
SalixApp[AllModel] allDemosApp(str id = "root") 
  = makeApp(id, initAll, withIndex("All", id, viewAll), updateAll
           , subs = allSubs, parser = parseMsg);
```

## function allDemosWebApp {#salix-demo-basic-All-allDemosWebApp}

```rascal
App[AllModel] allDemosWebApp() 
  = webApp(
      allDemosApp(), 
      |project://salix/src/main/rascal|
    );
```

## function initAll {#salix-demo-basic-All-initAll}

```rascal
AllModel initAll() = <
  mapCmds(Msg::celsius, salix::demo::basic::Celsius::init), 
  mapCmds(Msg::counter, salix::demo::basic::Counter::init), 
  mapCmds(Msg::random, salix::demo::basic::Random::twiceInit),
  mapCmds(Msg::clock, salix::demo::basic::Clock::init) 
>;
```

## function allSubs {#salix-demo-basic-All-allSubs}

```rascal
list[Sub] allSubs(AllModel m) 
  = mapSubs(Msg::clock, m.clock, salix::demo::basic::Clock::subs);
```

## function myDebugView {#salix-demo-basic-All-myDebugView}

```rascal
void myDebugView(DebugModel[AllModel] m) {
  debugView(m, viewAll);
}
```

## function bla {#salix-demo-basic-All-bla}

```rascal
void bla() {
  updateAll(celsius(c("32.0")), initAll());
}
```

## function debugAll {#salix-demo-basic-All-debugAll}

```rascal
App[DebugModel[AllModel]] debugAll()
  = debug("debugAll"
      , salix::demo::basic::All::initAll
      , salix::demo::basic::All::myDebugView
      , updateAll
      , |project://salix/src/main/rascal|);
```

## function viewAll {#salix-demo-basic-All-viewAll}

```rascal
void viewAll(AllModel m) {
  mapView(Msg::celsius, m.celsius, salix::demo::basic::Celsius::view);
  mapView(Msg::counter, m.counter, salix::demo::basic::Counter::view);
  mapView(Msg::random, m.random, salix::demo::basic::Random::twiceView);
  mapView(Msg::clock, m.clock, salix::demo::basic::Clock::view);
}
```

## function updateAll {#salix-demo-basic-All-updateAll}

```rascal
AllModel updateAll(Msg msg, AllModel m) {
  
  switch (msg) {
    case celsius(Msg msg):
      m.celsius = mapCmds(Msg::celsius, msg, m.celsius, salix::demo::basic::Celsius::update);
      
    case counter(Msg msg):
      m.counter = mapCmds(Msg::counter, msg, m.counter, salix::demo::basic::Counter::update);
    
    case random(Msg msg): 
      m.random = mapCmds(Msg::random, msg, m.random, twiceUpdate);
      
    case clock(Msg msg):
      m.clock = mapCmds(Msg::clock, msg, m.clock, salix::demo::basic::Clock::update);
  }
  
  return m;
}
```

